/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testdata;

import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.db.DatabaseConnection;
import com.kms.katalon.core.db.ListObjectResultSetHandler;
import com.kms.katalon.core.db.SqlRunner;
import com.kms.katalon.core.testdata.AbstractTestData;
import com.kms.katalon.core.testdata.TestDataInfo;
import com.kms.katalon.core.testdata.TestDataType;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;

public class DBData
extends AbstractTestData {
    private String query;
    private DatabaseConnection databaseConnection;
    private List<List<Object>> fetchedData;
    private List<String> columnNames;
    private ListObjectResultSetHandler rsHandler;
    private Date retrievedDate;

    public DBData(DatabaseConnection databaseConnection, String query) throws SQLException {
        super(databaseConnection.getConnectionUrl(), true);
        this.query = query;
        this.databaseConnection = databaseConnection;
        this.rsHandler = new ListObjectResultSetHandler();
        this.fetchedData = this.fetchData();
        this.columnNames = this.rsHandler.getColumnNames();
    }

    public List<List<Object>> getData() {
        return this.fetchedData;
    }

    @Override
    public List<List<Object>> getAllData() {
        return this.getData();
    }

    public Date getRetrievedDate() {
        return this.retrievedDate;
    }

    @Override
    public TestDataType getType() {
        return TestDataType.DB_DATA;
    }

    @Override
    public String[] getColumnNames() {
        return this.rsHandler.getColumnNames().toArray(new String[this.getColumnNumbers()]);
    }

    @Override
    public int getRowNumbers() {
        return this.fetchedData.size();
    }

    @Override
    public int getColumnNumbers() {
        return this.rsHandler.getColumnCount();
    }

    @Override
    protected Object internallyGetValue(int columnIndex, int rowIndex) throws IndexOutOfBoundsException {
        return this.fetchedData.get(rowIndex).get(columnIndex);
    }

    @Override
    protected Object internallyGetValue(String columnName, int rowIndex) throws IndexOutOfBoundsException {
        return this.internallyGetValue(this.columnNames.indexOf(columnName), rowIndex);
    }

    @Override
    protected void verifyColumnName(String columnName) throws IOException {
        if (this.columnNames.indexOf(columnName) == -1) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.TD_COLUMN_NAME_X_FOR_TEST_DATA_Y_INVALID, columnName, this.getSourceUrl(), this.columnNames.toString()));
        }
    }

    private List<List<Object>> fetchData() throws SQLException {
        SqlRunner sqlRunner = null;
        try {
            sqlRunner = new SqlRunner(this.databaseConnection, this.query);
            List<List<Object>> list = sqlRunner.query(this.rsHandler);
            return list;
        }
        finally {
            if (sqlRunner != null) {
                sqlRunner.close();
            }
            this.retrievedDate = new Date();
        }
    }

    @Override
    public TestDataInfo getDataInfo() {
        if (this.databaseConnection == null) {
            return null;
        }
        return this.databaseConnection.getDBDataInfo();
    }
}

