/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testdata;

import com.kms.katalon.core.testdata.AbstractTestData;
import com.kms.katalon.core.testdata.TestDataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InternalData
extends AbstractTestData {
    private List<String[]> data;
    private List<String> columnNames;

    public InternalData(String fileSource, List<String[]> data, List<String> columnNames) {
        super(fileSource, true);
        this.data = data;
        this.columnNames = columnNames;
    }

    @Override
    public String internallyGetValue(String columnName, int rowIndex) throws IOException {
        return this.data.get(rowIndex)[this.getColumnIndex(columnName)];
    }

    @Override
    public String internallyGetValue(int columnIndex, int rowIndex) throws IOException {
        return this.data.get(rowIndex)[columnIndex];
    }

    private int getColumnIndex(String columnName) {
        String[] columnNames = this.getColumnNames();
        int i = 0;
        while (i < columnNames.length) {
            if (columnNames[i].equals(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public TestDataType getType() {
        return TestDataType.INTERNAL_DATA;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    @Override
    public int getRowNumbers() {
        return this.data.size();
    }

    @Override
    public int getColumnNumbers() {
        return this.columnNames.size();
    }

    public List<String[]> getData() {
        return this.data;
    }

    @Override
    public List<List<Object>> getAllData() {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        for (String[] row : this.getData()) {
            data.add(new ArrayList<String>(Arrays.asList(row)));
        }
        return data;
    }
}

