/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.trymonad;

import com.kms.katalon.core.trymonad.Try;
import com.kms.katalon.core.trymonad.TryConsumer;
import com.kms.katalon.core.trymonad.TryMapFunction;
import com.kms.katalon.core.trymonad.TrySupplier;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

class Success<T>
extends Try<T> {
    private final T value;

    public Success(T value) {
        this.value = value;
    }

    @Override
    public <U> Try<U> flatMap(TryMapFunction<? super T, Try<U>> f) {
        Objects.requireNonNull(f);
        try {
            return f.apply(this.value);
        }
        catch (Throwable t) {
            return Try.failure(t);
        }
    }

    @Override
    public T recover(Function<? super Throwable, T> f) {
        Objects.requireNonNull(f);
        return this.value;
    }

    @Override
    public Try<T> recoverWith(TryMapFunction<? super Throwable, Try<T>> f) {
        Objects.requireNonNull(f);
        return this;
    }

    @Override
    public T orElse(T value) {
        return this.value;
    }

    @Override
    public Try<T> orElseTry(TrySupplier<T> f) {
        Objects.requireNonNull(f);
        return this;
    }

    @Override
    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.value;
    }

    @Override
    public T get() throws Throwable {
        return this.value;
    }

    @Override
    public T getUnchecked() {
        return this.value;
    }

    @Override
    public <U> Try<U> map(TryMapFunction<? super T, ? extends U> f) {
        Objects.requireNonNull(f);
        try {
            return new Success<U>(f.apply(this.value));
        }
        catch (Throwable t) {
            return Try.failure(t);
        }
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public <E extends Throwable> Try<T> onSuccess(TryConsumer<T, E> action) throws E {
        action.accept(this.value);
        return this;
    }

    @Override
    public Try<T> filter(Predicate<T> p) {
        Objects.requireNonNull(p);
        if (p.test(this.value)) {
            return this;
        }
        return Try.failure(new NoSuchElementException("Predicate does not match for " + this.value));
    }

    @Override
    public Optional<T> toOptional() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public <E extends Throwable> Try<T> onFailure(TryConsumer<Throwable, E> action) {
        return this;
    }
}

