/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Debouncer<T> {
    private final ScheduledExecutorService sched = Executors.newScheduledThreadPool(1);
    private final ConcurrentHashMap<T, TimerTask> delayedMap = new ConcurrentHashMap();
    private final Callback<T> callback;
    private final long interval;

    public Debouncer(Callback<T> callback, long interval) {
        this.callback = callback;
        this.interval = interval;
    }

    public void call(T key) {
        TimerTask prev;
        TimerTask task = new TimerTask(key);
        do {
            if ((prev = this.delayedMap.putIfAbsent(key, task)) != null) continue;
            this.sched.schedule(task, this.interval, TimeUnit.MILLISECONDS);
        } while (prev != null && !prev.extend());
    }

    public void terminate() {
        this.sched.shutdownNow();
    }

    public boolean isStopped() {
        return this.sched.isShutdown();
    }

    public static interface Callback<T> {
        public void call(T var1);
    }

    private class TimerTask
    implements Runnable {
        private final T key;
        private long dueTime;
        private final Object lock = new Object();

        public TimerTask(T key) {
            this.key = key;
            this.extend();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean extend() {
            Object object = this.lock;
            synchronized (object) {
                block4: {
                    if (this.dueTime >= 0L) break block4;
                    return false;
                }
                this.dueTime = System.currentTimeMillis() + Debouncer.this.interval;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                long remaining = this.dueTime - System.currentTimeMillis();
                if (remaining > 0L) {
                    Debouncer.this.sched.schedule(this, remaining, TimeUnit.MILLISECONDS);
                } else {
                    this.dueTime = -1L;
                    try {
                        Debouncer.this.callback.call(this.key);
                    }
                    finally {
                        Debouncer.this.delayedMap.remove(this.key);
                    }
                }
            }
        }
    }
}

