/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.kms.katalon.core.util.internal.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.util.Arrays;

public class JsonBuilder<RootType> {
    RootType root;

    public JsonBuilder() {
    }

    public JsonBuilder(RootType root) {
        this.root = root;
    }

    public static JsonBuilder<Map<String, Object>> object() {
        return JsonBuilder.fromObject(new HashMap<String, Object>());
    }

    public static JsonBuilder<List<Object>> array() {
        return JsonBuilder.fromArray(new ArrayList<Object>());
    }

    public static JsonBuilder<List<Object>> fromArray(List<Object> array) {
        return JsonBuilder.from(array);
    }

    public static JsonBuilder<Map<String, Object>> fromObject(Map<String, Object> object) {
        return JsonBuilder.from(object);
    }

    public static <RootType> JsonBuilder<RootType> from(RootType root) {
        return new JsonBuilder<RootType>(root);
    }

    public JsonBuilder<RootType> property(String key, Object value) {
        if (this.root instanceof Map) {
            ((Map)this.root).put(key, value);
        }
        return this;
    }

    public JsonBuilder<RootType> push(Object ... items) {
        if (this.root instanceof List) {
            ((List)this.root).addAll(Arrays.asList((Object)items));
        }
        return this;
    }

    public JsonBuilder<RootType> array(String key, Object ... items) {
        return this.array(key, (JsonBuilder<List<Object>> arrayBuilder) -> arrayBuilder.push(items));
    }

    public JsonBuilder<RootType> array(String key, ArrayBuilder arrayProvider) {
        JsonBuilder<List<Object>> subArray = JsonBuilder.array();
        if (arrayProvider != null) {
            arrayProvider.build(subArray);
        }
        return this.property(key, subArray.root);
    }

    public JsonBuilder<RootType> object(String key, ObjectBuilder objectProvider) {
        JsonBuilder<Map<String, Object>> subObject = JsonBuilder.object();
        if (objectProvider != null) {
            objectProvider.build(subObject);
        }
        return this.property(key, subObject.root);
    }

    public RootType build() {
        return this.root;
    }

    public String toJson() {
        return JsonUtil.toJson(this.root, false);
    }

    public static interface ArrayBuilder {
        public void build(JsonBuilder<List<Object>> var1);
    }

    public static interface ObjectBuilder {
        public void build(JsonBuilder<Map<String, Object>> var1);
    }
}

