/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

public class DateUtil {
    public static final DecimalFormat SECOND_FORMAT = new DecimalFormat("#0.000");

    public static String getElapsedTime(long startTime, long endTime) {
        if (endTime < startTime) {
            return "";
        }
        long totalMillis = endTime - startTime;
        long totalSeconds = totalMillis / 1000L;
        long totalMinutes = totalSeconds / 60L;
        int elapsedMillis = (int)(totalMillis % 1000L);
        double elapsedSeconds = (double)((int)(totalSeconds % 60L)) + (double)elapsedMillis / 1000.0;
        int elapsedMinutes = (int)(totalMinutes % 60L);
        int elapsedHours = (int)(totalMinutes / 60L);
        StringBuilder elapsedTimeBuilder = new StringBuilder();
        if (elapsedHours > 0) {
            elapsedTimeBuilder.append(Integer.toString(elapsedHours)).append("h - ");
        }
        if (elapsedMinutes > 0) {
            elapsedTimeBuilder.append(Integer.toString(elapsedMinutes)).append("m - ");
        }
        elapsedTimeBuilder.append(SECOND_FORMAT.format(elapsedSeconds)).append("s");
        return elapsedTimeBuilder.toString();
    }

    public static String getDateTimeFormatted(long timeValue) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        return DateUtil.getDateTimeFormatted(timeValue, formatter);
    }

    public static String getISOLocalDateTimeFormatted(long timeValue) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy'T'HH:mm:ss");
        return DateUtil.getDateTimeFormatted(timeValue, formatter);
    }

    public static String getDateTimeFormatted(long timeValue, DateTimeFormatter format) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timeValue), TimeZone.getDefault().toZoneId()).format(format);
    }
}

