/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.logging;

import com.kms.katalon.logging.LogMode;
import com.kms.katalon.logging.SystemLogger;
import com.kms.katalon.logging.constant.LoggingMessageConstants;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class LogManager {
    private static final String UTF_8 = "utf-8";
    private static SystemLogger errorLogger;
    private static SystemLogger outputLogger;

    public static void active() {
        System.setErr(LogManager.getErrorLogger());
        System.setOut(LogManager.getOutputLogger());
    }

    public static SystemLogger getErrorLogger() {
        if (errorLogger == null) {
            try {
                errorLogger = new SystemLogger((OutputStream)System.err, LogMode.LOG, UTF_8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                errorLogger = new SystemLogger((OutputStream)System.err, LogMode.LOG);
            }
        }
        return errorLogger;
    }

    public static SystemLogger getOutputLogger() {
        if (outputLogger == null) {
            try {
                outputLogger = new SystemLogger((OutputStream)System.out, LogMode.CONSOLE, UTF_8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                outputLogger = new SystemLogger((OutputStream)System.out, LogMode.CONSOLE);
                outputLogger.println(LoggingMessageConstants.MSG_WARNING_SYSTEM_NOT_SUPPORT_UTF8);
            }
        }
        return outputLogger;
    }

    public static void disableIgnoreError() {
        if (outputLogger != null) {
            outputLogger.setShouldIgnoreErrorMessage(false);
        }
        if (errorLogger != null) {
            errorLogger.setShouldIgnoreErrorMessage(false);
        }
    }

    public static void enableIgnoreError() {
        if (outputLogger != null) {
            outputLogger.setShouldIgnoreErrorMessage(true);
        }
        if (errorLogger != null) {
            errorLogger.setShouldIgnoreErrorMessage(true);
        }
    }

    public static void stop() {
        LogManager.getErrorLogger().close();
        LogManager.getOutputLogger().close();
    }

    public static void reset() {
        outputLogger = null;
        errorLogger = null;
    }
}

