/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.logging;

import com.kms.katalon.logging.LogMode;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.Platform;

public class SystemLogger
extends PrintStream {
    private LogMode logMode;
    private boolean locked;
    private PrintStream writer;
    private boolean shouldIgnoreErrorMessage = false;
    private File logFile;

    SystemLogger(OutputStream os, LogMode defaultMode) {
        super(os, true);
        this.logMode = defaultMode;
        this.locked = false;
        this.logFile = this.getLogFile();
    }

    SystemLogger(OutputStream os, LogMode defaultMode, String encode) throws UnsupportedEncodingException {
        super(os, true, encode);
        this.logMode = defaultMode;
        this.locked = false;
        this.logFile = this.getLogFile();
    }

    void changeMode(LogMode mode) {
        this.logMode = mode;
    }

    LogMode getMode() {
        return this.logMode;
    }

    void lock() {
        this.locked = true;
    }

    void unlock() {
        this.locked = false;
    }

    void waitFor() {
        while (this.locked) {
        }
    }

    synchronized void waitForAndLock() {
        this.waitFor();
        this.lock();
    }

    @Override
    public void println(String message) {
        if (this.shouldIgnoreErrorMessage) {
            if (message.contains("Groovy:unable to resolve")) {
                return;
            }
            if (message.contains("Groovy:class") && message.contains("is not an annotation in")) {
                return;
            }
        }
        super.println(message);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) {
        try {
            switch (this.logMode) {
                case CONSOLE: {
                    super.write(buf, off, len);
                    if (this.writer != null) {
                        this.writer.write(buf, off, len);
                    }
                    break;
                }
                case LOG: {
                    FileUtils.writeByteArrayToFile((File)this.logFile, (byte[])ArrayUtils.subarray((byte[])buf, (int)off, (int)len), (boolean)true);
                }
            }
        }
        catch (IOException iOException) {}
    }

    private File getLogFile() {
        return Platform.getLogFileLocation().toFile();
    }

    public void setWriter(PrintStream printStream) {
        this.writer = printStream;
    }

    public boolean isShouldIgnoreErrorMessage() {
        return this.shouldIgnoreErrorMessage;
    }

    public void setShouldIgnoreErrorMessage(boolean shouldIgnoreErrorMessage) {
        this.shouldIgnoreErrorMessage = shouldIgnoreErrorMessage;
    }
}

