/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.editor;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.editor.AbstractNameValueBodyEditor;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.webservice.ParameterizedBodyContent;
import com.kms.katalon.entity.webservice.UrlEncodedBodyParameter;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class UrlEncodedBodyEditor
extends AbstractNameValueBodyEditor<UrlEncodedBodyParameter> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private boolean initialized = false;
    private TableColumn cName;
    private TableColumn cValue;

    public UrlEncodedBodyEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected AbstractNameValueBodyEditor.ParameterTable doCreateParameterTable(Composite parent) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        Composite tableComposite = new Composite(parent, 0);
        GridData gdData = new GridData(4, 4, true, true, 1, 1);
        gdData.heightHint = 150;
        tableComposite.setLayoutData((Object)gdData);
        tableComposite.setLayout((Layout)tableColumnLayout);
        final AbstractNameValueBodyEditor.ParameterTable tvParams = new AbstractNameValueBodyEditor.ParameterTable(this, tableComposite, 68354);
        tvParams.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final Table tParams = tvParams.getTable();
        tParams.setHeaderVisible(true);
        tParams.setLinesVisible(ControlUtils.shouldLineVisble((Display)tParams.getDisplay()));
        TableViewerColumn cvName = new TableViewerColumn((TableViewer)tvParams, 16384);
        this.cName = cvName.getColumn();
        this.cName.setText(StringConstants.NAME);
        cvName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((UrlEncodedBodyParameter)element).getName();
            }
        });
        cvName.setEditingSupport(new EditingSupport(cvName.getViewer()){

            protected void setValue(Object element, Object value) {
                ((UrlEncodedBodyParameter)element).setName(String.valueOf(value));
                tvParams.update(element, null);
                UrlEncodedBodyEditor.this.fireModifyEvent();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)tParams);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((UrlEncodedBodyParameter)element).getName();
            }
        });
        TableViewerColumn cvValue = new TableViewerColumn((TableViewer)tvParams, 16384);
        this.cValue = cvValue.getColumn();
        this.cValue.setText(StringConstants.VALUE);
        cvValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((UrlEncodedBodyParameter)element).getValue();
            }
        });
        cvValue.setEditingSupport(new EditingSupport(cvValue.getViewer()){

            protected void setValue(Object element, Object value) {
                ((UrlEncodedBodyParameter)element).setValue(String.valueOf(value));
                tvParams.update(element, null);
                UrlEncodedBodyEditor.this.fireModifyEvent();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)tParams);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((UrlEncodedBodyParameter)element).getValue();
            }
        });
        tableColumnLayout.setColumnData((Widget)this.cName, (ColumnLayoutData)new ColumnWeightData(50, 100));
        tableColumnLayout.setColumnData((Widget)this.cValue, (ColumnLayoutData)new ColumnWeightData(50, 100));
        return tvParams;
    }

    @Override
    protected UrlEncodedBodyParameter createEmptyParameter() {
        UrlEncodedBodyParameter param = new UrlEncodedBodyParameter();
        param.setName("");
        param.setValue("");
        return param;
    }

    @Override
    protected boolean isEmptyParameter(UrlEncodedBodyParameter parameter) {
        return StringUtils.isBlank((CharSequence)parameter.getName()) && StringUtils.isBlank((CharSequence)parameter.getValue());
    }

    @Override
    public void setInput(String httpBodyContent) {
        if (StringUtils.isEmpty((CharSequence)httpBodyContent)) {
            this.bodyContent = new ParameterizedBodyContent();
            this.bodyContent.setContentType(DEFAULT_CONTENT_TYPE);
            this.bodyContent.setCharset(DEFAULT_CHARSET);
        } else {
            this.bodyContent = (ParameterizedBodyContent)JsonUtil.fromJson((String)httpBodyContent, (Type)new TypeToken<ParameterizedBodyContent<UrlEncodedBodyParameter>>(){}.getType());
        }
        this.tvParams.setInput(this.bodyContent.getParameters());
        if (!this.bodyContent.getParameters().isEmpty()) {
            this.btnRemove.setEnabled(true);
        }
        this.updateViewModel();
    }

    @Override
    public void onBodyTypeChanged() {
        if (this.bodyContent == null) {
            this.bodyContent = new ParameterizedBodyContent();
            this.bodyContent.setContentType(DEFAULT_CONTENT_TYPE);
            this.bodyContent.setCharset(DEFAULT_CHARSET);
        }
        if (!this.initialized) {
            this.tvParams.setInput(this.bodyContent.getParameters());
            if (!this.bodyContent.getParameters().isEmpty()) {
                this.btnRemove.setEnabled(true);
            }
            this.initialized = true;
        }
        this.updateViewModel();
        this.setContentTypeUpdated(true);
    }
}

