/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.editor;

import com.kms.katalon.composer.components.impl.table.ColumnBuilder;
import com.kms.katalon.composer.components.impl.table.CustomColumnType;
import com.kms.katalon.composer.components.impl.table.CustomTable;
import com.kms.katalon.composer.components.impl.table.TableBuilder;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.ValidationDataType;
import com.kms.katalon.core.testobject.ValidationStep;
import com.kms.katalon.core.testobject.ValidationTarget;
import com.kms.katalon.core.testobject.ValidationType;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.core.webui.util.OSUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class ValidationComposite
extends Composite {
    private CustomTable<ValidationStep> stepTable;
    private final String columnNameSchemaType = "Schema Type";
    private final String columnNameInputType = "Input Type";
    private final String columnNameLocationOrValue = "Location/Value";
    private final String columnNameValidate = "Validate";
    private ValidationType[] supportedValidationTypes = (ValidationType[])ValidationType.class.getEnumConstants();
    private TableItem[] selectedRows;

    public ValidationComposite(Composite parent, int style, ValidationType[] supportedValidationTypes) {
        super(parent, style);
        this.supportedValidationTypes = supportedValidationTypes;
        this.createContent(this);
    }

    public ValidationComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent(this);
    }

    protected void createContent(Composite parent) {
        this.createTable();
        this.addTableListener();
    }

    public void update(ValidationStep step) {
        ArrayList<ValidationStep> validationSteps = new ArrayList<ValidationStep>();
        for (ValidationStep validationStep : this.stepTable.getRows()) {
            if (validationStep.id == step.id) {
                validationSteps.add(step);
                continue;
            }
            validationSteps.add(validationStep);
        }
        this.setRawValidationSteps(validationSteps);
    }

    public void removeValidationStep(ValidationStep removeStep) {
        List<ValidationStep> validationSteps = this.getPureValidationSteps();
        validationSteps.remove(removeStep);
        this.setRawValidationSteps(validationSteps);
    }

    public void createTable() {
        Composite container = (Composite)ComponentBuilder.fromGrid((Composite)this).fill().margin(8).build();
        ToolBar toolbar = (ToolBar)ComponentBuilder.toolBar((Composite)container, (int)131072).color(ColorUtil.getToolBarForegroundColor()).fillHorizontal().build();
        ComponentBuilder.toolItem((Composite)toolbar).text(StringConstants.ADD).image(ImageManager.getImage((String)"add_16.png")).onClick(event -> this.addNewValidation()).build();
        ComponentBuilder.toolItem((Composite)toolbar).text(StringConstants.REMOVE).image(ImageManager.getImage((String)"delete_16.png")).disabledImage(ImageManager.getImage((String)"delete_disabled_16.png")).onClick(event -> {
            ValidationStep selectedValidationStep = (ValidationStep)((StructuredSelection)this.stepTable.getViewer().getSelection()).getFirstElement();
            this.removeValidationStep(selectedValidationStep);
        }).build();
        int columnNameWidth = OSUtil.isMac() ? 100 : 200;
        int columnTypeWidth = OSUtil.isMac() ? 70 : 130;
        int columnDataWidth = OSUtil.isMac() ? 180 : 240;
        int columnTargetWidth = OSUtil.isMac() ? 50 : 80;
        int columnValidateWitdth = OSUtil.isMac() ? 50 : 70;
        int columnInputTypeWidth = OSUtil.isMac() ? 50 : 140;
        this.stepTable = TableBuilder.create((Composite)container).buildColumn(builder -> {
            ColumnBuilder columnBuilder = builder.headerName(ComposerWebserviceMessageConstants.TBL_COLUMN_NAME).getter(item -> item.name).setter((item, value) -> {
                String string = item.name = (String)value;
            }).width(columnNameWidth).editable();
        }).buildColumn(builder -> {
            ColumnBuilder columnBuilder = builder.headerName(ComposerWebserviceMessageConstants.TBL_COLUMN_TARGET).getter(item -> {
                if (item.target == null) {
                    return ValidationTarget.RESPONSE;
                }
                return item.target;
            }).setter((item, value) -> {
                ValidationTarget validationTarget = item.target = (ValidationTarget)value;
            }).type(ValidationTarget.class).on(24, event -> {
                columnBuilder.build().readyToUpdate = true;
                ValidationTarget target = (ValidationTarget)event.data;
                ValidationStep selectedValidationStep = this.getSelectedValidationStep();
                if (selectedValidationStep == null) {
                    return;
                }
                if (selectedValidationStep.target == ValidationTarget.REQUEST && selectedValidationStep.type == ValidationType.GRAPHQL_SCHEMA) {
                    try {
                        if (target == ValidationTarget.RESPONSE) {
                            columnBuilder.build().readyToUpdate = false;
                            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.WARN, (String)ComposerWebserviceMessageConstants.WRN_GRAPHQL_WITH_REQUEST);
                            return;
                        }
                    }
                    catch (Exception exception) {}
                }
            }).width(columnTargetWidth).editable();
        }).buildColumn(builder -> {
            ColumnBuilder columnBuilder = builder.headerName("Schema Type").getter(item -> item.type).setter((item, value) -> {
                ValidationType validationType = item.type = (ValidationType)value;
            }).renderCell((value, item) -> item.type != null ? item.type.toString() : "").options((Object[])this.supportedValidationTypes).width(columnTypeWidth).on(24, event -> {
                columnBuilder.build().readyToUpdate = true;
                ValidationType type = (ValidationType)event.data;
                ValidationStep selectedValidationStep = this.getSelectedValidationStep();
                if (selectedValidationStep == null) {
                    return;
                }
                if ((selectedValidationStep.target == ValidationTarget.RESPONSE || selectedValidationStep.target == null) && selectedValidationStep.type != ValidationType.GRAPHQL_SCHEMA) {
                    try {
                        if (type == ValidationType.GRAPHQL_SCHEMA) {
                            columnBuilder.build().readyToUpdate = false;
                            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.WARN, (String)ComposerWebserviceMessageConstants.WRN_GRAPHQL_WITH_REQUEST);
                            return;
                        }
                    }
                    catch (Exception exception) {}
                }
            }).editable();
        }).buildColumn(builder -> {
            ColumnBuilder columnBuilder = builder.headerName("Input Type").getter(item -> {
                if (item.dataType == null) {
                    return ValidationType.AUTO_DETECT;
                }
                return item.dataType;
            }).setter((item, value) -> {
                ValidationDataType validationDataType = item.dataType = (ValidationDataType)value;
            }).type(ValidationDataType.class).width(columnInputTypeWidth).editable();
        }).buildColumn(builder -> {
            ColumnBuilder columnBuilder = builder.headerName("Location/Value").getter(item -> item.data).editable().editorType(item -> {
                if (item.dataType == null) {
                    return null;
                }
                switch (item.dataType) {
                    case FILE: {
                        return CustomColumnType.FILE;
                    }
                }
                return CustomColumnType.TEXT;
            }).setter((item, value) -> {
                boolean isFromFile = item.dataType == ValidationDataType.FILE;
                item.data = isFromFile ? ProjectController.getInstance().getRelativePath((String)value) : (String)value;
            }).width(columnDataWidth);
        }).buildColumn(builder -> {
            ColumnBuilder columnBuilder = builder.headerName("Validate").getter(item -> item.activate).setter((item, value) -> {
                boolean bl = item.activate = ((Boolean)value).booleanValue();
            }).width(columnValidateWitdth).align(0x1000000).editable();
        }).cloneProvider(item -> {
            if (item instanceof ValidationStep) {
                ValidationStep chosenValidationStep = item;
                ValidationStep clonedValidationStep = (ValidationStep)ObjectUtil.clone((Object)chosenValidationStep);
                clonedValidationStep.name = this.getSuggestion(chosenValidationStep.name);
                clonedValidationStep.id = UUID.randomUUID().toString();
                return clonedValidationStep;
            }
            return null;
        }).newRowProvider(() -> {
            ValidationStep step = new ValidationStep(UUID.randomUUID().toString(), this.getSuggestion("New Validation"), ValidationType.AUTO_DETECT, ValidationDataType.AUTO, "");
            step.activate = true;
            return step;
        }).build();
        ComponentBuilder.from(this.stepTable).fill().onChange(event -> ComponentEventUtil.trigger((Widget)this, (int)24, (Event)event)).build();
    }

    private void addTableListener() {
        this.stepTable.getTable().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ValidationComposite.this.selectedRows = ValidationComposite.this.stepTable.getTable().getSelection();
            }

            public void mouseDown(MouseEvent e) {
                ValidationComposite.this.selectedRows = ValidationComposite.this.stepTable.getTable().getSelection();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    public List<ValidationStep> getValidationSteps() {
        return this.stepTable.getRows();
    }

    public List<ValidationStep> getPureValidationSteps() {
        return this.stepTable.getRows().stream().map(stepI -> {
            ValidationStep clone = (ValidationStep)ObjectUtil.clone((Object)stepI);
            clone.results = null;
            return clone;
        }).collect(Collectors.toList());
    }

    public void setRawValidationSteps(List<ValidationStep> validationSteps) {
        this.stepTable.setRows(validationSteps);
        this.stepTable.getViewer().refresh();
    }

    public void setValidationSteps(List<ValidationStep> validationSteps) {
        List curRows = this.stepTable.getRows();
        validationSteps.forEach(stepI -> {
            int existingIndex;
            if (stepI.results == null && (existingIndex = curRows.indexOf(stepI)) >= 0) {
                ValidationStep existingStep = (ValidationStep)curRows.get(existingIndex);
                stepI.results = existingStep.results;
            }
        });
        this.stepTable.setRows(validationSteps);
    }

    public void updateResults(List<ValidationStep> validationSteps) {
        List curRows = this.stepTable.getRows();
        validationSteps.forEach(stepI -> {
            int existingIndex = curRows.indexOf(stepI);
            if (existingIndex >= 0) {
                ValidationStep existingStep = (ValidationStep)curRows.get(existingIndex);
                existingStep.results = stepI.results;
            }
        });
        this.stepTable.setRows(curRows);
    }

    private boolean isNameDupplicated(String newName) {
        return this.getPureValidationSteps().parallelStream().filter(l -> l.name.equals(newName)).findAny().isPresent();
    }

    private String getSuggestion(String suggestion) {
        String newName = suggestion;
        int index = 0;
        while (this.isNameDupplicated(newName)) {
            newName = String.format("%s (%d)", suggestion, ++index);
        }
        return newName;
    }

    private void addNewValidation() {
        ValidationStep step = new ValidationStep(UUID.randomUUID().toString(), this.getSuggestion("New Validation"), ValidationType.AUTO_DETECT, ValidationDataType.AUTO, "");
        step.activate = true;
        List rows = this.stepTable.getRows();
        rows.add(step);
        this.stepTable.setRows(rows);
        this.notifyListeners(24, null);
    }

    private ValidationStep getSelectedValidationStep() {
        StructuredSelection selection;
        if (OSUtil.isMac()) {
            if (this.selectedRows.length == 1) {
                TableItem item = this.selectedRows[0];
                return (ValidationStep)item.getData();
            }
            return null;
        }
        TableViewer tableViewer = this.stepTable.getViewer();
        if (tableViewer != null && (selection = (StructuredSelection)tableViewer.getSelection()) != null) {
            return (ValidationStep)selection.getFirstElement();
        }
        return null;
    }
}

