/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.view.ImportWebServiceObjectsFromPostmanDialog;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ImportWebServiceRequestObjectFromPostmanHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;
    @Inject
    EPartService partService;
    @Inject
    IEclipseContext context;
    private FolderTreeEntity objectRepositoryTreeRoot;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("WSOBJECT/POSTMAN", new EventHandler(){

            public void handleEvent(Event event) {
                if (!ImportWebServiceRequestObjectFromPostmanHandler.this.canExecute()) {
                    return;
                }
                ImportWebServiceRequestObjectFromPostmanHandler.this.execute(null, Display.getCurrent().getActiveShell());
            }
        });
    }

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Optional @Named(value="org.eclipse.ui.selection") Object[] selectedObjects, @Named(value="activeShell") @Named(value="activeShell") Shell parentShell) {
        try {
            ITreeEntity parentTreeEntity = ImportWebServiceRequestObjectFromPostmanHandler.findParentTreeEntity(selectedObjects);
            if (parentTreeEntity == null) {
                if (this.objectRepositoryTreeRoot == null) {
                    return;
                }
                parentTreeEntity = this.objectRepositoryTreeRoot;
            }
            FolderEntity parentFolderEntity = (FolderEntity)parentTreeEntity.getObject();
            ObjectRepositoryController toController = ObjectRepositoryController.getInstance();
            ImportWebServiceObjectsFromPostmanDialog dialog = new ImportWebServiceObjectsFromPostmanDialog(parentShell, parentFolderEntity);
            if (dialog.open() == 0) {
                List<WebServiceRequestEntity> requestEntities = dialog.getWebServiceRequestEntities();
                int i = 0;
                for (WebServiceRequestEntity entity : requestEntities) {
                    try {
                        toController.saveNewTestObject((WebElementEntity)entity);
                    }
                    catch (Exception exception) {
                        if (i == 0) {
                            entity.setName(EntityNameController.getInstance().getAvailableName("New Postman Request", parentFolderEntity, false));
                            ++i;
                        } else {
                            entity.setName(EntityNameController.getInstance().getAvailableName("New Postman Request(" + i + ")", parentFolderEntity, false));
                            ++i;
                        }
                        toController.saveNewTestObject((WebElementEntity)entity);
                    }
                }
                this.trackImportPostman(dialog.getPostmanSpecLocation());
                this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
                ArrayList<WebElementTreeEntity> requestTreeEntities = new ArrayList<WebElementTreeEntity>();
                for (WebServiceRequestEntity request : requestEntities) {
                    requestTreeEntities.add(TreeEntityUtil.getWebElementTreeEntity((WebElementEntity)request, (ProjectEntity)ProjectController.getInstance().getCurrentProject()));
                }
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEMS", (Object)requestTreeEntities.toArray());
            }
        }
        catch (FilePathTooLongException e) {
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_NEW_REQ_OBJ);
        }
    }

    private void trackImportPostman(String postmanSpecLocation) {
        try {
            Paths.get(postmanSpecLocation, new String[0]);
            Trackings.trackImportPostman((String)"file");
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null) {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity) {
                    Object entityObject = ((ITreeEntity)entity).getObject();
                    if (entityObject instanceof FolderEntity) {
                        FolderEntity folder = (FolderEntity)entityObject;
                        if (folder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                            return (ITreeEntity)entity;
                        }
                    } else if (entityObject instanceof WebElementEntity) {
                        return ((ITreeEntity)entity).getParent();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void catchTestDataFolderTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            for (Object o : treeEntities) {
                void folder;
                FolderEntity folderEntity;
                Object entityObject = ((ITreeEntity)o).getObject();
                Object object = entityObject;
                if (!(object instanceof FolderEntity) || (folderEntity = (FolderEntity)object) != (FolderEntity)object || folder.getFolderType() != FolderEntity.FolderType.WEBELEMENT) continue;
                this.objectRepositoryTreeRoot = (FolderTreeEntity)o;
                return;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

