/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.importing.model;

import com.kms.katalon.composer.webservice.exception.ImportWebServiceException;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class WebServiceImportNode {
    protected Set<String> childNodeNames = new HashSet<String>();

    public abstract FileEntity getFileEntity();

    public abstract WebServiceImportNode getParentImportNode();

    public abstract List<WebServiceImportNode> getChildImportNodes();

    public FolderEntity newChildFolder(String name) {
        FolderEntity folder = new FolderEntity();
        FolderEntity parentFolder = (FolderEntity)this.getFileEntity();
        String folderName = this.getAvailableChildNodeName(name, parentFolder, true);
        this.childNodeNames.add(folderName);
        folder.setName(folderName);
        folder.setParentFolder(parentFolder);
        folder.setProject(parentFolder.getProject());
        folder.setFolderType(parentFolder.getFolderType());
        folder.setDescription("folder");
        return folder;
    }

    public String getAvailableChildNodeName(String suggestion, FolderEntity parentFolder, boolean isFolder) {
        String name = suggestion;
        try {
            name = EntityNameController.getInstance().getAvailableName(name, parentFolder, isFolder);
        }
        catch (Exception e) {
            throw new ImportWebServiceException(e);
        }
        int i = 1;
        while (this.childNodeNames.contains(name)) {
            name = String.valueOf(suggestion) + " (" + i + ")";
            ++i;
        }
        return name;
    }

    public void addChildNodeName(String name) {
        this.childNodeNames.add(name);
    }

    protected FolderEntity newFolder(String suggestionName, FolderEntity parentFolder) {
        String name = suggestionName;
        try {
            name = EntityNameController.getInstance().getAvailableName(name, parentFolder, true);
        }
        catch (Exception e) {
            throw new ImportWebServiceException(e);
        }
        FolderEntity folder = new FolderEntity();
        folder.setName(name);
        folder.setParentFolder(parentFolder);
        folder.setProject(parentFolder.getProject());
        folder.setFolderType(parentFolder.getFolderType());
        folder.setDescription("folder");
        return folder;
    }

    protected String toValidFileName(String fileName) {
        return fileName.replaceAll("[^a-zA-Z0-9-_\\.\\s]", "_");
    }
}

