/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.menu;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.handlers.ImportFromSoapUIHandler;
import com.kms.katalon.composer.webservice.handlers.ImportFromWadlHandler;
import com.kms.katalon.composer.webservice.handlers.ImportFromWsdlHandler;
import com.kms.katalon.composer.webservice.handlers.ImportOpenApiHandler;
import com.kms.katalon.composer.webservice.handlers.ImportWebServiceRequestObjectFromPostmanHandler;
import com.kms.katalon.composer.webservice.handlers.ImportWebServiceRequestObjectsFromSwaggerHandler;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.osgi.framework.FrameworkUtil;

public class ImportWebServicesPopupMenuContribution {
    private static final String CONTRIBUTOR_URI = FrameworkUtil.getBundle(ImportWebServicesPopupMenuContribution.class).getSymbolicName();
    public static final String CM_IMPORT_COMPOSER_BUNDLE_URI = "bundleclass://com.kms.katalon.composer.webservice/";
    @Inject
    private ESelectionService selectionService;
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            if (project == null) {
                return;
            }
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (selectedObjects == null || selectedObjects.length != 1) {
                return;
            }
            Object selectedObject = selectedObjects[0];
            if (selectedObject instanceof FolderTreeEntity && ((FolderTreeEntity)selectedObject).getObject() instanceof FolderEntity && FolderEntity.FolderType.WEBELEMENT.equals((Object)((FolderTreeEntity)selectedObject).getObject().getFolderType())) {
                MMenu importMenu = this.getImportMenu();
                MDirectMenuItem swaggerMenuItem = this.getSwaggerMenu();
                swaggerMenuItem.setContributionURI(CM_IMPORT_COMPOSER_BUNDLE_URI + ImportWebServiceRequestObjectsFromSwaggerHandler.class.getName());
                importMenu.getChildren().add(swaggerMenuItem);
                MDirectMenuItem openApi3MenuItem = this.getOpenApi3Menu();
                openApi3MenuItem.setContributionURI(CM_IMPORT_COMPOSER_BUNDLE_URI + ImportOpenApiHandler.class.getName());
                importMenu.getChildren().add(openApi3MenuItem);
                MDirectMenuItem wadlMenuItem = this.getWadlMenu();
                wadlMenuItem.setContributionURI(CM_IMPORT_COMPOSER_BUNDLE_URI + ImportFromWadlHandler.class.getName());
                importMenu.getChildren().add(wadlMenuItem);
                importMenu.getChildren().add(MMenuFactory.INSTANCE.createMenuSeparator());
                MDirectMenuItem wsdlMenuItem = this.getWSDLMenu();
                wsdlMenuItem.setContributionURI(CM_IMPORT_COMPOSER_BUNDLE_URI + ImportFromWsdlHandler.class.getName());
                importMenu.getChildren().add(wsdlMenuItem);
                importMenu.getChildren().add(MMenuFactory.INSTANCE.createMenuSeparator());
                MDirectMenuItem postmanMenuItem = this.getPostmanMenu();
                postmanMenuItem.setContributionURI(CM_IMPORT_COMPOSER_BUNDLE_URI + ImportWebServiceRequestObjectFromPostmanHandler.class.getName());
                importMenu.getChildren().add(postmanMenuItem);
                MDirectMenuItem soapUIMenuItem = this.getSoapUIMenu();
                soapUIMenuItem.setContributionURI(CM_IMPORT_COMPOSER_BUNDLE_URI + ImportFromSoapUIHandler.class.getName());
                importMenu.getChildren().add(soapUIMenuItem);
                if (importMenu.getChildren().size() > 0) {
                    menuItems.add(0, (MMenuElement)importMenu);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private MMenu getImportMenu() {
        MMenu dynamicItem = (MMenu)this.modelService.createModelElement(MMenu.class);
        dynamicItem.setLabel(StringConstants.MSG_IMPORT);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }

    private MDirectMenuItem getSwaggerMenu() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.MENU_CONTEXT_WEBSERVICE_REQ_OPENAPI2);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }

    private MDirectMenuItem getOpenApi3Menu() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.MENU_CONTEXT_WEBSERVICE_REQ_OPENAPI3);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }

    private MDirectMenuItem getWadlMenu() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.MENU_CONTEXT_WEBSERVICE_REQ_WADL);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }

    private MDirectMenuItem getWSDLMenu() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.MENU_CONTEXT_WEBSERVICE_REQ_WSDL);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }

    private MDirectMenuItem getPostmanMenu() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(ComposerWebserviceMessageConstants.MENU_CONTEXT_WEBSERVICE_REQ_POSTMAN);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }

    private MDirectMenuItem getSoapUIMenu() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.MENU_CONTEXT_WEBSERVICE_REQ_SOAPUI);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }
}

