/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parts;

import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.ImageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.editor.SoapRequestMessageEditor;
import com.kms.katalon.composer.webservice.editor.ValidationComposite;
import com.kms.katalon.composer.webservice.parts.WebServicePart;
import com.kms.katalon.composer.webservice.soap.response.body.SoapResponseBodyEditorsComposite;
import com.kms.katalon.composer.webservice.util.WebServiceUtil;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.WebServiceController;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.ValidationType;
import com.kms.katalon.core.util.StrSubstitutor;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.webservice.common.BasicRequestor;
import com.kms.katalon.core.webservice.common.HarLogger;
import com.kms.katalon.core.webservice.definition.WebServiceDefinitionLoaderProvider;
import com.kms.katalon.core.webservice.definition.WebServiceDefinitionLoaderSupplier;
import com.kms.katalon.core.webservice.helper.WsdlLocatorProvider;
import com.kms.katalon.core.webservice.util.WsdlUtil;
import com.kms.katalon.core.webservice.wsdl.support.wsdl.WsdlDefinitionLocator;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.UrlUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SoapServicePart
extends WebServicePart {
    protected SoapResponseBodyEditorsComposite soapResponseBodyEditor;
    private ProgressMonitorDialogWithThread progress;
    protected SoapRequestMessageEditor requestBodyEditor;
    private CCombo cbbRequestMethod;
    private Text txtWsdlLocation;
    private CCombo cbbServiceFunction;
    private Button btnLoadServiceFunctions;
    private Button btnLoadContent;
    private Button cbUseOldMechanism;
    private Label lblHelp;
    private Text txtServiceEndpoint;
    protected ValidationComposite validationComposite;

    @Override
    protected void createServiceInfoComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cbbRequestMethod = new CCombo(composite, 2048);
        this.cbbRequestMethod.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridData gdRequestMethod = new GridData(4, 0x1000000, false, false);
        gdRequestMethod.widthHint = 100;
        gdRequestMethod.heightHint = 22;
        this.cbbRequestMethod.setLayoutData((Object)gdRequestMethod);
        this.cbbRequestMethod.setEditable(true);
        this.cbbRequestMethod.setItems(WebServiceRequestEntity.SOAP_REQUEST_METHODS);
        this.cbbRequestMethod.setText(this.originalWsObject.getSoapRequestMethod());
        this.createApiControls(composite);
        this.wsApiControl.setLayoutData(new GridData(131072, 0x1000000, true, false, 2, 1));
        Label lblWsdlEndpoint = new Label(composite, 0);
        lblWsdlEndpoint.setText("WSDL URL");
        this.txtWsdlLocation = new Text(composite, 2048);
        GridData gdWsdlEndpoint = new GridData(4, 0x1000000, true, false, 1, 1);
        gdWsdlEndpoint.heightHint = 20;
        this.txtWsdlLocation.setLayoutData((Object)gdWsdlEndpoint);
        this.txtWsdlLocation.setText(this.originalWsObject.getWsdlAddress());
        this.btnLoadServiceFunctions = new Button(composite, 0x800000);
        this.btnLoadServiceFunctions.setText(StringConstants.LBL_LOAD_SERVICE_FUNCTION);
        this.btnLoadServiceFunctions.setLayoutData((Object)new GridData(131072, 4, false, false));
        Label lblServiceFunction = new Label(composite, 0);
        lblServiceFunction.setText(StringConstants.PA_LBL_SERVICE_FUNCTION);
        lblServiceFunction.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbbServiceFunction = new CCombo(composite, 0x800808);
        GridData gdServiceFunction = new GridData(4, 4, true, false, 1, 1);
        gdServiceFunction.heightHint = 22;
        this.cbbServiceFunction.setLayoutData((Object)gdServiceFunction);
        this.btnLoadContent = new Button(composite, 0x800000);
        this.btnLoadContent.setLayoutData((Object)new GridData(4, 4, false, false));
        this.btnLoadContent.setText(ComposerWebserviceMessageConstants.SoapServicePart_BTN_LOAD_NEW_CONTENT);
        Label lblEmpty = new Label(composite, 0);
        lblEmpty.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Composite oldMechanismComp = new Composite(composite, 0);
        GridLayout glWsdlComp = new GridLayout(2, false);
        glWsdlComp.marginWidth = 0;
        glWsdlComp.marginHeight = 0;
        oldMechanismComp.setLayout((Layout)glWsdlComp);
        oldMechanismComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cbUseOldMechanism = new Button(oldMechanismComp, 32);
        this.cbUseOldMechanism.setText(ComposerWebserviceMessageConstants.SoapServicePart_CB_USE_SERVICE_INFO_FROM_WSDL);
        this.lblHelp = new Label(oldMechanismComp, 0);
        GridData gdLblHelp = new GridData(131072, 0x1000000, false, true, 1, 1);
        gdLblHelp.heightHint = 20;
        this.lblHelp.setLayoutData((Object)gdLblHelp);
        this.lblHelp.setImage(ImageConstants.IMG_16_HELP);
        this.lblHelp.setCursor(Display.getDefault().getSystemCursor(21));
        Label lblServiceEndpoint = new Label(composite, 0);
        lblServiceEndpoint.setText(ComposerWebserviceMessageConstants.SoapServicePart_LBL_SERVICE_ENDPOINT);
        this.txtServiceEndpoint = new Text(composite, 2048);
        GridData gdServiceEndpoint = new GridData(4, 0x1000000, true, false, 2, 1);
        gdServiceEndpoint.heightHint = 20;
        this.txtServiceEndpoint.setLayoutData((Object)gdServiceEndpoint);
        Composite requestOptions = this.createRequestOptionsComposite(composite);
        requestOptions.setLayoutData((Object)new GridData(-1, -1, true, false, gridLayout.numColumns, 1));
        if (!this.originalWsObject.isCreatedBeforeV7_4_5()) {
            ((GridData)lblEmpty.getLayoutData()).exclude = true;
            lblEmpty.setVisible(false);
            ((GridData)oldMechanismComp.getLayoutData()).exclude = true;
            oldMechanismComp.setVisible(false);
        }
        this.registerControlListeners();
        this.txtServiceEndpoint.setEnabled(this.useCustomServiceEndpoint());
    }

    private void registerControlListeners() {
        this.txtWsdlLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SoapServicePart.this.setDirty(true);
            }
        });
        this.btnLoadServiceFunctions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoapServicePart.this.loadServiceFunctions();
            }
        });
        this.cbbServiceFunction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoapServicePart.this.setDirty(true);
            }
        });
        this.btnLoadContent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoapServicePart.this.loadContent();
            }
        });
        this.cbbRequestMethod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoapServicePart.this.cbbServiceFunction.removeAll();
                SoapServicePart.this.setDirty(true);
            }
        });
        this.cbUseOldMechanism.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoapServicePart.this.txtServiceEndpoint.setEnabled(SoapServicePart.this.useCustomServiceEndpoint());
                SoapServicePart.this.setDirty(true);
            }
        });
        this.txtServiceEndpoint.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SoapServicePart.this.setDirty(true);
            }
        });
        this.lblHelp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Program.launch((String)"https://docs.katalon.com/katalon-studio/docs/import-soap-requests-from-wsdl.html");
            }
        });
    }

    private boolean useCustomServiceEndpoint() {
        return !this.cbUseOldMechanism.getSelection();
    }

    private void loadServiceFunctions() {
        final String wsdlLocation = this.txtWsdlLocation.getText().trim();
        final String method = this.cbbRequestMethod.getText();
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (StringUtils.isBlank((String)wsdlLocation)) {
            MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR, (String)ComposerWebserviceMessageConstants.SoapServicePart_MSG_WSDL_LOCATION_UNDEFINED);
            return;
        }
        try {
            new ProgressMonitorDialogWithThread(activeShell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(StringConstants.MSG_FETCHING_FROM_WSDL, -1);
                    try {
                        try {
                            Map<String, Object> evaluatedVariables = SoapServicePart.this.evaluateRequestVariables();
                            StrSubstitutor substitutor = new StrSubstitutor(evaluatedVariables);
                            String url = substitutor.replace(wsdlLocation);
                            WsdlDefinitionLocator locator = SoapServicePart.this.getWsdlLocator(url);
                            if (locator != null) {
                                Definition definition = WsdlUtil.getDefinition((WSDLLocator)locator);
                                Port port = WsdlUtil.getFirstPortByBindingMethod((Definition)definition, (String)method);
                                Binding binding = null;
                                if (port != null) {
                                    binding = port.getBinding();
                                }
                                if (binding == null) {
                                    binding = WsdlUtil.getFirstBindingByMethod((Definition)definition, (String)method);
                                }
                                List bindingOperations = binding.getBindingOperations();
                                List servFuncs = bindingOperations.stream().map(bo -> bo.getName()).collect(Collectors.toList());
                                UISynchronizeService.asyncExec(() -> {
                                    SoapServicePart.this.cbbServiceFunction.setItems(servFuncs.toArray(new String[0]));
                                    if (servFuncs.size() > 0) {
                                        SoapServicePart.this.cbbServiceFunction.select(0);
                                    }
                                    SoapServicePart.this.setDirty(true);
                                });
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            LoggerSingleton.logError((Throwable)ex);
            MultiStatusErrorDialog.showErrorDialog((String)(String.valueOf(ComposerWebserviceMessageConstants.SoapServicePart_MSG_UNABLE_TO_LOAD_SERVICE_FUNCTION) + wsdlLocation), (String)ex.getTargetException().getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)ex.getTargetException()));
        }
        catch (InterruptedException ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void loadContent() {
        final String wsdlLocation = this.txtWsdlLocation.getText().trim();
        final String method = this.cbbRequestMethod.getText().trim();
        final String operation = this.cbbServiceFunction.getText();
        Shell shell = Display.getCurrent().getActiveShell();
        if (!MessageDialog.openConfirm((Shell)shell, (String)StringConstants.WARN, (String)ComposerWebserviceMessageConstants.SoapServicePart_MSG_WARN_OVERRIDE_CONTENT)) {
            return;
        }
        if (StringUtils.isBlank((String)wsdlLocation)) {
            MessageDialog.openError((Shell)shell, (String)StringConstants.ERROR, (String)ComposerWebserviceMessageConstants.SoapServicePart_MSG_WSDL_LOCATION_UNDEFINED);
            return;
        }
        if (StringUtils.isBlank((String)operation)) {
            MessageDialog.openError((Shell)shell, (String)StringConstants.ERROR, (String)ComposerWebserviceMessageConstants.SoapServicePart_MSG_SERVICE_FUNCTION_EMPTY);
            return;
        }
        try {
            new ProgressMonitorDialogWithThread(shell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        WebServiceRequestEntity newContentEntity = SoapServicePart.this.getNewContentEntity(wsdlLocation, method, operation);
                        UISynchronizeService.syncExec(() -> {
                            SoapServicePart.this.txtServiceEndpoint.setText(newContentEntity.getSoapServiceEndpoint());
                            SoapServicePart.this.httpHeaders.clear();
                            SoapServicePart.this.httpHeaders.addAll(newContentEntity.getHttpHeaderProperties());
                            SoapServicePart.this.tblHeaders.refresh();
                            SoapServicePart.this.requestBodyEditor.setInput(newContentEntity.getSoapBody());
                            SoapServicePart.this.setDirty(true);
                        });
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((String)(String.valueOf(ComposerWebserviceMessageConstants.SoapServicePart_MSG_UNABLE_TO_LOAD_CONTENT_FROM_URL) + wsdlLocation), (String)e.getTargetException().getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e.getTargetException()));
        }
        catch (InterruptedException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private WebServiceRequestEntity getNewContentEntity(String wsdlLocation, String method, String operationName) {
        try {
            Map<String, Object> evaluatedVariables = this.evaluateRequestVariables();
            StrSubstitutor substitutor = new StrSubstitutor(evaluatedVariables);
            String url = substitutor.replace(wsdlLocation);
            WsdlDefinitionLocator wsdlLocator = this.getWsdlLocator(url);
            Definition definition = WsdlUtil.getDefinition((WSDLLocator)wsdlLocator);
            Port port = WsdlUtil.getFirstPortByBindingMethod((Definition)definition, (String)method);
            Binding binding = null;
            String serviceEndpoint = null;
            if (port != null) {
                serviceEndpoint = WsdlUtil.getPortAddressLocation((Port)port);
                binding = port.getBinding();
            }
            if (binding == null) {
                binding = WsdlUtil.getFirstBindingByMethod((Definition)definition, (String)method);
            }
            if (binding != null) {
                BindingOperation operation = WsdlUtil.getBindingOperation((Binding)binding, (String)operationName);
                String operationUri = StringUtils.defaultIfBlank((String)WsdlUtil.getOperationUri((BindingOperation)operation), (String)"");
                String requestMessage = WsdlUtil.getSampleRequestMessage((String)wsdlLocator.getWsdlLocation(), (String)binding.getQName().toString(), (String)operationName);
                WebServiceRequestEntity newEntity = this.newRequestEntity();
                WebServiceRequestEntity entity = WsdlUtil.generateRequestEntity(() -> newEntity, (String)this.originalWsObject.getName(), (String)wsdlLocation, (String)serviceEndpoint, (String)method, (String)operationName, (String)operationUri, (String)requestMessage);
                entity.setWsdlAddress(wsdlLocation);
                return entity;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private WebServiceRequestEntity newRequestEntity() throws Exception {
        if (this.originalWsObject instanceof DraftWebServiceRequestEntity) {
            return ObjectRepositoryController.getInstance().newDraftWebServiceEntity(ProjectController.getInstance().getCurrentProject());
        }
        return ObjectRepositoryController.getInstance().newWSTestObjectWithoutSave(new FolderEntity(), this.originalWsObject.getName());
    }

    private WsdlDefinitionLocator getWsdlLocator(String wsdlLocation) throws IOException {
        WebServiceDefinitionLoaderSupplier loaderSupplier = UrlUtil.isWebUrl((String)wsdlLocation) ? location -> WebServiceDefinitionLoaderProvider.getLoaderForWebLocation((String)location, this.getAuthorizationHeaderMap()) : location -> WebServiceDefinitionLoaderProvider.getLoader((String)wsdlLocation);
        WsdlDefinitionLocator wsdlLocator = WsdlLocatorProvider.getLocator((String)wsdlLocation, (WebServiceDefinitionLoaderSupplier)loaderSupplier);
        return wsdlLocator;
    }

    private Map<String, String> getAuthorizationHeaderMap() {
        String authorizationHeaderValue = this.getAuthorizationHeaderValue();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)authorizationHeaderValue)) {
            headers.put("Authorization", authorizationHeaderValue);
        }
        return headers;
    }

    @Override
    protected void sendRequest(final boolean runVerificationScript) {
        if (this.dirtyable.isDirty()) {
            boolean isOK = MessageDialog.openConfirm(null, (String)StringConstants.WARN, (String)ComposerWebserviceMessageConstants.PART_MSG_DO_YOU_WANT_TO_SAVE_THE_CHANGES);
            if (!isOK) {
                return;
            }
            this.save();
        }
        this.clearPreviousResponse();
        if (this.cbUseOldMechanism.getSelection()) {
            if (StringUtils.isBlank((String)this.txtWsdlLocation.getText())) {
                MessageDialog.openError(null, (String)StringConstants.ERROR, (String)ComposerWebserviceMessageConstants.SoapServicePart_MSG_WSDL_LOCATION_UNDEFINED);
                return;
            }
            if (this.cbbServiceFunction.getText().isEmpty()) {
                LoggerSingleton.logError((String)ComposerWebserviceMessageConstants.SoapServicePart_MSG_SERVICE_FUNCTION_EMPTY);
                MessageDialog.openError(null, (String)StringConstants.ERROR, (String)ComposerWebserviceMessageConstants.SoapServicePart_MSG_SERVICE_FUNCTION_EMPTY);
                return;
            }
        }
        if (this.wsApiControl.getSendingState()) {
            this.progress.getProgressMonitor().setCanceled(true);
            this.wsApiControl.setSendButtonState(false);
            return;
        }
        if (!this.cbUseOldMechanism.getSelection() && StringUtils.isBlank((String)this.txtServiceEndpoint.getText())) {
            MessageDialog.openError(null, (String)StringConstants.ERROR, (String)ComposerWebserviceMessageConstants.SoapServicePart_MSG_SERVICE_ENDPOINT_UNDEFINED);
            return;
        }
        try {
            WebServiceUtil.setHttpsProtocol();
            boolean isValidateJsonAgainstJson = this.isValidateJsonAganistSchema(this.validationComposite.getValidationSteps());
            boolean isValidateXMLAgainstJson = this.isValidateXMLAganistSchema(this.validationComposite.getValidationSteps());
            boolean isValidateGraphQLAgainstSchema = this.isValidateGraphQLAgainstSchema(this.validationComposite.getValidationSteps());
            String requestType = this.getRequestType(this.getWSRequestObject());
            Trackings.trackTestWebServiceObject((boolean)runVerificationScript, (boolean)(this.getOriginalWsObject() instanceof DraftWebServiceRequestEntity), (String)this.ccbAuthType.getText(), (boolean)isValidateJsonAgainstJson, (boolean)isValidateXMLAgainstJson, (boolean)isValidateGraphQLAgainstSchema, (String)requestType);
            this.wsApiControl.setSendButtonState(true);
            this.progress = new ProgressMonitorDialogWithThread(Display.getCurrent().getActiveShell());
            this.progress.setOpenOnRun(false);
            this.displayResponseContentBasedOnSendingState(true);
            this.progress.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    RequestObject requestObject;
                    ResponseObject responseObject;
                    block7: {
                        monitor.beginTask(ComposerWebserviceMessageConstants.PART_MSG_SENDING_TEST_REQUEST, -1);
                        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                        WebServiceRequestEntity requestEntity = SoapServicePart.this.getWSRequestObject();
                        SoapServicePart.this.configRequest(requestEntity);
                        Map<String, Object> evaluatedVariables = SoapServicePart.this.evaluateRequestVariables();
                        HarLogger harLogger = new HarLogger();
                        harLogger.initHarFile();
                        responseObject = WebServiceController.getInstance().sendRequest(requestEntity, projectDir, ProxyPreferences.getSystemProxyInformation(), Collections.unmodifiableMap(evaluatedVariables), false);
                        SoapServicePart.this.deleteTempHarFile();
                        requestObject = WebServiceController.getRequestObject((WebServiceRequestEntity)requestEntity, (String)projectDir, Collections.unmodifiableMap(evaluatedVariables));
                        String logFolder = Files.createTempDirectory("har", new FileAttribute[0]).toFile().getAbsolutePath();
                        SoapServicePart.this.harFile = harLogger.logHarFile(requestObject, responseObject, logFolder);
                        if (!monitor.isCanceled()) break block7;
                        UISynchronizeService.syncExec(() -> SoapServicePart.this.wsApiControl.setSendButtonState(false));
                        monitor.done();
                        return;
                    }
                    try {
                        try {
                            String bodyContent = responseObject.getResponseText();
                            Display.getDefault().asyncExec(() -> {
                                SoapServicePart.this.setResponseStatus(responseObject);
                                SoapServicePart.this.mirrorEditor.setText(SoapServicePart.this.getPrettyHeaders(responseObject));
                                if (bodyContent == null) {
                                    return;
                                }
                                SoapServicePart.this.soapResponseBodyEditor.setInput(responseObject);
                            });
                            if (runVerificationScript) {
                                SoapServicePart.this.executeVerificationScript(responseObject);
                            }
                            if (runVerificationScript) {
                                SoapServicePart.this.executeValidationSteps(requestObject, responseObject);
                                UISynchronizeService.syncExec(() -> {
                                    SoapServicePart.this.validationComposite.updateResults(requestObject.getValidationSteps());
                                    SoapServicePart.this.getWSRequestObject().setValidationSteps(SoapServicePart.this.validationComposite.getPureValidationSteps());
                                    SoapServicePart.this.updateValidationResult(requestObject.getValidationSteps());
                                });
                            }
                            RequestHistoryEntity requestHistoryEntity = new RequestHistoryEntity(new Date(), (WebServiceRequestEntity)SoapServicePart.this.getWSRequestObject().clone());
                            SoapServicePart.this.eventBroker.post("WS_VERIFICATION/FINISHED", (Object)new Object[]{requestHistoryEntity});
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        UISynchronizeService.syncExec(() -> SoapServicePart.this.wsApiControl.setSendButtonState(false));
                        monitor.done();
                        throw throwable;
                    }
                    UISynchronizeService.syncExec(() -> SoapServicePart.this.wsApiControl.setSendButtonState(false));
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target == null) {
                return;
            }
            LoggerSingleton.logError((Throwable)target);
            MultiStatusErrorDialog.showErrorDialog((String)ComposerWebserviceMessageConstants.PART_MSG_CANNOT_SEND_THE_TEST_REQUEST, (String)target.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)target));
        }
        catch (InterruptedException interruptedException) {}
        this.displayResponseContentBasedOnSendingState(false);
    }

    @Override
    protected Composite createRequestOptionsComposite(Composite parent) {
        Composite requestOptionsComposite = super.createRequestOptionsComposite(parent);
        this.createSetRequestTimeoutLink(requestOptionsComposite);
        return requestOptionsComposite;
    }

    private void createSetRequestTimeoutLink(Composite parent) {
        Link lnkSetTimeout = new Link(parent, 0);
        lnkSetTimeout.setText(StringConstants.LINK_SET_REQUEST_TIMEOUT_AND_LIMIT);
        lnkSetTimeout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LicenseUtil.isNotFreeLicense()) {
                    SoapServicePart.this.eventBroker.post("PROJECT/SETTINGS_PAGE", (Object)"com.kms.katalon.composer.execution.settings.webservice");
                } else {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CUSTOM_WEB_SERVICE_REQUEST_TIMEOUT);
                }
            }
        });
    }

    @Override
    protected void addTabBody(CTabFolder parent) {
        super.addTabBody(parent);
        this.tabBody.setText(StringConstants.PA_LBL_XML_REQ_MSG);
        Composite tabComposite = (Composite)this.tabBody.getControl();
        this.requestBodyEditor = new SoapRequestMessageEditor(tabComposite, 0, this);
        this.requestBodyEditor.setLayoutData(new GridData(4, 4, true, true));
    }

    @Override
    protected void addTabValidation(CTabFolder parent) {
        super.addTabValidation(parent);
        Composite tabComposite = (Composite)this.tabValidation.getControl();
        ValidationType[] supportedValidationTypes = new ValidationType[]{ValidationType.AUTO_DETECT, ValidationType.XML_SCHEMA, ValidationType.GRAPHQL_SCHEMA};
        this.validationComposite = new ValidationComposite(tabComposite, 0, supportedValidationTypes);
        this.validationComposite.addListener(24, event -> this.setDirty(true));
    }

    @Override
    protected void createResponseComposite(Composite parent) {
        super.createResponseComposite(parent);
        this.soapResponseBodyEditor = new SoapResponseBodyEditorsComposite(this.responseBodyComposite, 0, this);
        this.soapResponseBodyEditor.setLayoutData(new GridData(4, 4, true, true));
    }

    @Override
    protected void preSaving() {
        this.originalWsObject.setWsdlAddress(this.txtWsdlLocation.getText());
        this.originalWsObject.setSoapRequestMethod(this.cbbRequestMethod.getText());
        this.originalWsObject.setSoapServiceFunction(this.cbbServiceFunction.getText());
        this.originalWsObject.setUseServiceInfoFromWsdl(this.cbUseOldMechanism.getSelection());
        this.originalWsObject.setSoapServiceEndpoint(this.txtServiceEndpoint.getText());
        this.tblHeaders.removeEmptyProperty();
        this.originalWsObject.setHttpHeaderProperties(this.httpHeaders);
        this.originalWsObject.setSoapBody(this.requestBodyEditor.getHttpBodyContent());
        this.originalWsObject.setValidationSteps(this.validationComposite.getValidationSteps());
        this.updateIconURL(WebServiceUtil.getRequestMethodIcon(this.originalWsObject.getServiceType(), this.originalWsObject.getSoapRequestMethod()));
    }

    @Override
    protected void populateDataToUI() {
        this.txtWsdlLocation.setText(this.originalWsObject.getWsdlAddress());
        String soapRequestMethod = this.originalWsObject.getSoapRequestMethod();
        int index = Arrays.asList(WebServiceRequestEntity.SOAP_REQUEST_METHODS).indexOf(soapRequestMethod);
        this.cbbRequestMethod.select(index < 0 ? 0 : index);
        this.cbbServiceFunction.setText(this.originalWsObject.getSoapServiceFunction());
        this.cbUseOldMechanism.setSelection(this.originalWsObject.isUseServiceInfoFromWsdl());
        this.txtServiceEndpoint.setText(this.originalWsObject.getSoapServiceEndpoint());
        this.txtServiceEndpoint.setEnabled(this.useCustomServiceEndpoint());
        this.tempPropList = new ArrayList(this.originalWsObject.getHttpHeaderProperties());
        this.httpHeaders.clear();
        this.httpHeaders.addAll(this.tempPropList);
        this.tblHeaders.refresh();
        this.populateBasicAndBearerAuthFromHeader();
        this.populateOAuth1FromHeader();
        this.populateOAuth2FromHeader();
        this.populateNTLMAuthorization();
        this.renderAuthenticationUI(this.ccbAuthType.getText());
        this.requestBodyEditor.setInput(this.originalWsObject.getSoapBody());
        this.validationComposite.setValidationSteps(this.originalWsObject.getValidationSteps());
        this.cbFollowRedirects.setSelection(this.originalWsObject.isFollowRedirects());
        this.populateVariableManualView();
        this.populateVariableScriptView();
        this.reloadVerificationScript();
        this.setDirty(false);
    }

    private String getAuthorizationHeaderValue() {
        Optional<WebElementPropertyEntity> definedAuthorization = this.httpHeaders.stream().filter(header -> "Authorization".equals(header.getName())).findFirst();
        if (definedAuthorization.isPresent()) {
            return definedAuthorization.get().getValue();
        }
        Map<String, String> map = this.oauth1Headers.stream().collect(Collectors.toMap(WebElementPropertyEntity::getName, WebElementPropertyEntity::getValue));
        String authType = map.get("Authorization:type");
        if (StringUtils.isBlank((String)authType)) {
            return null;
        }
        if ("OAuth 1.0".equals(authType)) {
            try {
                String oauth1AuthorizationHeader = BasicRequestor.createOAuth1AuthorizationHeaderValue((String)this.txtWsdlLocation.getText().trim(), map, (String)"POST");
                return StringUtils.isBlank((String)oauth1AuthorizationHeader) ? null : oauth1AuthorizationHeader;
            }
            catch (GeneralSecurityException e) {
                LoggerSingleton.logError((Throwable)e);
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected void updatePartImage() {
        this.updateIconURL(WebServiceUtil.getRequestMethodIcon(this.originalWsObject.getServiceType(), this.originalWsObject.getSoapRequestMethod()));
    }

    public boolean isDirty() {
        return this.mPart.isDirty();
    }
}

