/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.response.body;

import com.kms.katalon.composer.webservice.response.body.ResponseBodyEditor;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.ResponseObject;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PreviewEditor
extends Composite
implements ResponseBodyEditor {
    private Browser browser;
    private ResponseObject responseObjects;
    private File tempFile;

    public PreviewEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        this.browser = new Browser((Composite)this, 0);
        this.browser.setJavascriptEnabled(true);
        this.browser.setLayoutData((Object)new GridData(1808));
        this.tempFile = new File(ProjectController.getInstance().getTempDir(), "editor/mirror/Temp_" + System.currentTimeMillis() + ".html");
        this.tempFile.getParentFile().mkdirs();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PreviewEditor.this.tempFile != null && PreviewEditor.this.tempFile.exists()) {
                    FileUtils.deleteQuietly((File)PreviewEditor.this.tempFile);
                }
            }
        });
    }

    @Override
    public void setContentBody(ResponseObject responseOb) throws IOException {
        if (responseOb != null) {
            this.responseObjects = responseOb;
            FileUtils.write((File)this.tempFile, (CharSequence)this.responseObjects.getResponseText());
            this.browser.setUrl(this.tempFile.toURI().toURL().toString());
        }
    }

    @Override
    public void switchModeContentBody(ResponseObject responseOb) throws IOException {
        if (this.responseObjects != responseOb) {
            this.setContentBody(responseOb);
        }
    }

    @Override
    public String getContentType() {
        return this.responseObjects.getContentType();
    }
}

