/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.SSLClientCertificateSettings;
import com.kms.katalon.core.webservice.setting.SSLCertificateOption;
import com.kms.katalon.core.webservice.setting.WebServiceSettingStore;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NetworkSettingPage
extends PreferencePageWithHelp {
    private WebServiceSettingStore settingStore;
    private Map<SSLCertificateOption, Button> sslCertButtons;
    private Composite container;
    private Text txtKeyStore;
    private Text txtKeyStorePassword;
    private Button btnBrowse;
    private GridData gdClientCert;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    public NetworkSettingPage() {
        this.settingStore = WebServiceSettingStore.create((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        this.sslCertButtons = new HashMap<SSLCertificateOption, Button>();
    }

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        Group grpSSLCertOptions = new Group(this.container, 0);
        grpSSLCertOptions.setText(ComposerWebserviceMessageConstants.DIA_GRP_LBL_CERTITICATES);
        grpSSLCertOptions.setLayout((Layout)new GridLayout(1, false));
        grpSSLCertOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button rbtnNoneCertificateOpt = new Button((Composite)grpSSLCertOptions, 16);
        rbtnNoneCertificateOpt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        rbtnNoneCertificateOpt.setText(ComposerWebserviceMessageConstants.DIA_LBL_SSL_CERT_NONE_OPT);
        this.sslCertButtons.put(SSLCertificateOption.NONE, rbtnNoneCertificateOpt);
        Button rbtnBypassCertificateOpt = new Button((Composite)grpSSLCertOptions, 16);
        rbtnBypassCertificateOpt.setText(ComposerWebserviceMessageConstants.DIA_LBL_SSL_CERT_BYPASS_OPT);
        this.sslCertButtons.put(SSLCertificateOption.BYPASS, rbtnBypassCertificateOpt);
        Composite compositeClientCert = new Composite(this.container, 0);
        this.gdClientCert = new GridData(4, 4, true, false);
        compositeClientCert.setLayoutData((Object)this.gdClientCert);
        compositeClientCert.setLayout((Layout)new FillLayout());
        Group grpClientCert = new Group(compositeClientCert, 0);
        grpClientCert.setText(ComposerWebserviceMessageConstants.DIA_GRP_LBL_CLIENT_CERTIFICATES);
        grpClientCert.setLayout((Layout)new GridLayout(3, false));
        Label lblKeyStore = new Label((Composite)grpClientCert, 0);
        lblKeyStore.setText(ComposerWebserviceMessageConstants.DIA_LBL_KEYSTORE);
        this.txtKeyStore = new Text((Composite)grpClientCert, 2048);
        this.txtKeyStore.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnBrowse = new Button((Composite)grpClientCert, 0);
        this.btnBrowse.setText(ComposerWebserviceMessageConstants.DIA_BTN_BROWSE_FILE);
        Label lblKeyStorePassword = new Label((Composite)grpClientCert, 0);
        lblKeyStorePassword.setText(ComposerWebserviceMessageConstants.DIA_LBL_KEYSTORE_PASSWORD);
        this.txtKeyStorePassword = new Text((Composite)grpClientCert, 0x400800);
        this.txtKeyStorePassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.registerControlListeners();
        this.initializeInput();
        return this.container;
    }

    private void registerControlListeners() {
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
                String fileLocation = dialog.open();
                NetworkSettingPage.this.txtKeyStore.setText(fileLocation);
            }
        });
    }

    private void initializeInput() {
        try {
            SSLCertificateOption option = this.settingStore.getSSLCertificateOption();
            this.sslCertButtons.entrySet().stream().forEach(entry -> ((Button)entry.getValue()).setSelection(entry.getKey() == option));
            SSLClientCertificateSettings clientCertSettings = this.settingStore.getClientCertificateSettings();
            this.txtKeyStore.setText(clientCertSettings.getKeyStoreFile());
            this.txtKeyStorePassword.setText(clientCertSettings.getKeyStorePassword());
        }
        catch (IOException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerWebserviceMessageConstants.DIA_MSG_UNABLE_TO_LOAD_NETWORK_PAGE, (String)StringConstants.ERROR_TITLE);
        }
    }

    private boolean isInitialized() {
        return this.container != null;
    }

    public boolean performOk() {
        boolean useClientCert;
        if (!this.isInitialized()) {
            return true;
        }
        boolean bl = useClientCert = StringUtils.isNotBlank((CharSequence)this.txtKeyStore.getText()) || StringUtils.isNotBlank((CharSequence)this.txtKeyStorePassword.getText());
        if (!this.featureService.canUse(KSEFeature.SSL_CLIENT_CERTIFICATE) && useClientCert) {
            KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.SSL_CLIENT_CERTIFICATE);
            return false;
        }
        SSLCertificateOption selectedSSLOption = (SSLCertificateOption)this.sslCertButtons.entrySet().stream().filter(entry -> ((Button)entry.getValue()).getSelection()).findFirst().get().getKey();
        try {
            this.settingStore.saveSSLCertificateOption(selectedSSLOption);
            SSLClientCertificateSettings clientCertSettings = new SSLClientCertificateSettings();
            clientCertSettings.setKeyStoreFile(this.txtKeyStore.getText());
            clientCertSettings.setKeyStorePassword(this.txtKeyStorePassword.getText());
            this.settingStore.saveClientCerfiticateSettings(clientCertSettings);
            return true;
        }
        catch (IOException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerWebserviceMessageConstants.DIA_MSG_UNABLE_TO_UPDATE_NETWORK_PAGE, (String)StringConstants.ERROR_TITLE);
            return false;
        }
    }

    protected void performDefaults() {
        this.initializeInput();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTING_NETWORK;
    }
}

