/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.soapui;

import com.eviware.soapui.config.Interface;
import com.eviware.soapui.config.OAuth1ProfileContainer;
import com.eviware.soapui.config.OAuth2ProfileContainer;
import com.eviware.soapui.config.Project;
import com.eviware.soapui.config.RestService;
import com.eviware.soapui.config.SoapuiProjectDocument;
import com.eviware.soapui.config.WsdlInterface;
import com.eviware.soapui.config.impl.ProjectImpl;
import com.google.common.base.Preconditions;
import com.kms.katalon.composer.webservice.importer.AbstractWebServiceImporter;
import com.kms.katalon.composer.webservice.soapui.SoapUIOAuth1Credential;
import com.kms.katalon.composer.webservice.soapui.SoapUIOAuth2Credential;
import com.kms.katalon.composer.webservice.soapui.SoapUIProjectImportResult;
import com.kms.katalon.composer.webservice.soapui.SoapUIRestServiceImporter;
import com.kms.katalon.composer.webservice.soapui.SoapUISoapServiceImporter;
import com.kms.katalon.entity.folder.FolderEntity;
import java.io.File;
import java.net.URI;
import java.util.stream.Stream;

public class SoapUIImporter
extends AbstractWebServiceImporter {
    public SoapUIProjectImportResult importServices(String projectFilePath, FolderEntity rootFolder) throws Exception {
        Interface[] interfaces;
        Thread.currentThread().setContextClassLoader(ProjectImpl.class.getClassLoader());
        Preconditions.checkNotNull((Object)projectFilePath, (Object)"SoapUI project file path must not be null or empty.");
        File projectFile = new File(new URI(projectFilePath));
        Preconditions.checkArgument((boolean)projectFile.exists(), (Object)"SoapUI project file does not exist.");
        Preconditions.checkNotNull((Object)rootFolder, (Object)"Root folder must not be null.");
        SoapuiProjectDocument projectDocument = SoapuiProjectDocument.Factory.parse((File)projectFile);
        Project project = projectDocument.getSoapuiProject();
        SoapUIProjectImportResult projectImportResult = this.parseProject(project, rootFolder);
        Interface[] interfaceArray = interfaces = project.getInterfaceArray();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Interface iface = interfaceArray[n2];
            if (iface instanceof RestService) {
                this.parseRestService(projectImportResult, (RestService)iface);
            } else if (iface instanceof WsdlInterface) {
                this.parseSoapService(projectImportResult, (WsdlInterface)iface);
            }
            ++n2;
        }
        return projectImportResult;
    }

    private SoapUIProjectImportResult parseProject(Project project, FolderEntity parentFolder) throws Exception {
        SoapUIProjectImportResult projectResult = new SoapUIProjectImportResult(project.getName(), parentFolder);
        this.addOAuth1Credentials(projectResult, project);
        this.addOAuth2Credentials(projectResult, project);
        return projectResult;
    }

    private void addOAuth1Credentials(SoapUIProjectImportResult projectImportResult, Project project) {
        OAuth1ProfileContainer oAuth1ProfileContainer = project.getOAuth1ProfileContainer();
        if (oAuth1ProfileContainer == null) {
            return;
        }
        Stream.of(oAuth1ProfileContainer.getOAuth1ProfileArray()).forEach(p -> {
            SoapUIOAuth1Credential credential = projectImportResult.newOAuth1Credential(p.getName());
            credential.setConsumerKey(p.getConsumerKey());
            credential.setConsumerSecret(p.getConsumerSecret());
            credential.setToken(p.getAccessToken());
            credential.setTokenSecret(p.getTokenSecret());
        });
    }

    private void addOAuth2Credentials(SoapUIProjectImportResult projectImportResult, Project project) {
        OAuth2ProfileContainer oAuth2ProfileContainer = project.getOAuth2ProfileContainer();
        if (oAuth2ProfileContainer == null) {
            return;
        }
        Stream.of(oAuth2ProfileContainer.getOAuth2ProfileArray()).forEach(p -> {
            SoapUIOAuth2Credential credential = projectImportResult.newOAuth2Credential(p.getName());
            credential.setAccessToken(p.getAccessToken());
        });
    }

    private void parseRestService(SoapUIProjectImportResult projectImportResult, RestService restService) {
        SoapUIRestServiceImporter restImporter = new SoapUIRestServiceImporter();
        restImporter.importService(projectImportResult, restService);
    }

    private void parseSoapService(SoapUIProjectImportResult projectImportResult, WsdlInterface wsdlInterface) {
        SoapUISoapServiceImporter soapImporter = new SoapUISoapServiceImporter();
        soapImporter.importService(projectImportResult, wsdlInterface);
    }
}

