/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.soapui;

import com.eviware.soapui.config.AbstractRequest;
import com.eviware.soapui.config.Attachment;
import com.eviware.soapui.config.Credentials;
import com.eviware.soapui.config.RestMethod;
import com.eviware.soapui.config.RestParameter;
import com.eviware.soapui.config.RestRequest;
import com.eviware.soapui.config.RestResource;
import com.eviware.soapui.config.RestService;
import com.eviware.soapui.config.StringToStringMap;
import com.kms.katalon.composer.webservice.importing.model.RestMethodImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestParameterImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestResourceImportNode;
import com.kms.katalon.composer.webservice.importing.model.RestResourceImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestServiceImportResult;
import com.kms.katalon.composer.webservice.soapui.SoapUIProjectImportResult;
import com.kms.katalon.composer.webservice.soapui.SoapUIRestRequestImportResult;
import com.kms.katalon.composer.webservice.soapui.SoapUISoapServiceImporter;
import org.apache.commons.lang3.StringUtils;

public class SoapUIRestServiceImporter
extends SoapUISoapServiceImporter {
    public void importService(SoapUIProjectImportResult projectImportResult, RestService restService) {
        RestResource[] restResources;
        RestServiceImportResult serviceImportResult = this.parseService(projectImportResult, restService);
        RestResource[] restResourceArray = restResources = restService.getResourceArray();
        int n = restResources.length;
        int n2 = 0;
        while (n2 < n) {
            RestResource restResource = restResourceArray[n2];
            this.parseResource(serviceImportResult, restResource);
            ++n2;
        }
    }

    private RestServiceImportResult parseService(SoapUIProjectImportResult projectImportResult, RestService restService) {
        String name = this.getServiceFolderName(projectImportResult, restService);
        RestServiceImportResult serviceImportResult = projectImportResult.newRestService(name);
        serviceImportResult.setBasePath(restService.getBasePath());
        return serviceImportResult;
    }

    private String getServiceFolderName(SoapUIProjectImportResult projectImportResult, RestService restService) {
        String suggestion = restService.getName();
        if (StringUtils.isBlank((CharSequence)suggestion)) {
            suggestion = "Service";
        }
        suggestion = this.toValidFileName(suggestion);
        return suggestion;
    }

    private RestResourceImportResult parseResource(RestServiceImportResult serviceImportResult, RestResource restResource) {
        String resourcePath = restResource.getPath();
        String resourceName = this.getResourceFolderName(serviceImportResult, restResource);
        RestResourceImportResult resourceResult = serviceImportResult.newResource(resourceName, resourcePath);
        this.addParameters(resourceResult, restResource.getParameters().getParameterArray());
        RestMethod[] restMethodArray = restResource.getMethodArray();
        int n = restMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            RestMethod restMethod = restMethodArray[n2];
            this.parseMethod(resourceResult, restMethod);
            ++n2;
        }
        restMethodArray = restResource.getResourceArray();
        n = restMethodArray.length;
        n2 = 0;
        while (n2 < n) {
            RestMethod childResource = restMethodArray[n2];
            this.parseResource(resourceResult, (RestResource)childResource);
            ++n2;
        }
        return resourceResult;
    }

    private RestResourceImportResult parseResource(RestResourceImportResult parentResourceImportResult, RestResource restResource) {
        String resourcePath = restResource.getPath();
        String resourceName = this.getResourceFolderName(parentResourceImportResult, restResource);
        RestResourceImportResult resourceResult = parentResourceImportResult.newResource(resourceName, resourcePath);
        this.addParameters(resourceResult, restResource.getParameters().getParameterArray());
        RestMethod[] restMethodArray = restResource.getMethodArray();
        int n = restMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            RestMethod restMethod = restMethodArray[n2];
            this.parseMethod(resourceResult, restMethod);
            ++n2;
        }
        restMethodArray = restResource.getResourceArray();
        n = restMethodArray.length;
        n2 = 0;
        while (n2 < n) {
            RestMethod childResource = restMethodArray[n2];
            this.parseResource(resourceResult, (RestResource)childResource);
            ++n2;
        }
        return resourceResult;
    }

    private String getResourceFolderName(RestServiceImportResult serviceImportResult, RestResource restResource) {
        String suggestion = restResource.getName();
        if (StringUtils.isBlank((CharSequence)suggestion)) {
            suggestion = "Resource";
        }
        suggestion = this.toValidFileName(suggestion);
        return suggestion;
    }

    private String getResourceFolderName(RestResourceImportResult resourceImportResult, RestResource restResource) {
        String suggestion = restResource.getName();
        if (StringUtils.isBlank((CharSequence)suggestion)) {
            suggestion = "Resource";
        }
        suggestion = this.toValidFileName(suggestion);
        return suggestion;
    }

    private RestMethodImportResult parseMethod(RestResourceImportResult resourceImportResult, RestMethod restMethod) {
        String name = this.getMethodFolderName(resourceImportResult, restMethod);
        String httpMethod = restMethod.getMethod();
        RestMethodImportResult methodResult = resourceImportResult.newMethod(name, httpMethod);
        this.addParameters(methodResult, restMethod.getParameters().getParameterArray());
        RestRequest[] restRequestArray = restMethod.getRequestArray();
        int n = restRequestArray.length;
        int n2 = 0;
        while (n2 < n) {
            RestRequest restRequest = restRequestArray[n2];
            this.parseRequest(methodResult, restRequest);
            ++n2;
        }
        return methodResult;
    }

    private String getMethodFolderName(RestResourceImportResult resourceImportResult, RestMethod restMethod) {
        String suggestion = restMethod.getName();
        if (StringUtils.isBlank((CharSequence)suggestion)) {
            suggestion = "Method";
        }
        suggestion = this.toValidFileName(suggestion);
        return suggestion;
    }

    private SoapUIRestRequestImportResult parseRequest(RestMethodImportResult methodImportResult, RestRequest restRequest) {
        String name = this.getRequestFileName(methodImportResult, restRequest);
        SoapUIRestRequestImportResult requestResult = methodImportResult.newRequest(name, n -> new SoapUIRestRequestImportResult((String)n, methodImportResult));
        requestResult.setEndpoint(restRequest.getEndpoint());
        requestResult.setMediaType(restRequest.getMediaType());
        requestResult.setPostQueryString(restRequest.getPostQueryString());
        if (restRequest.getRequest() != null) {
            requestResult.setRequestBodyContent(restRequest.getRequest().getStringValue());
        }
        requestResult.setEncoding(restRequest.getEncoding());
        this.setParameters(requestResult, restRequest.getParameters().getEntryArray());
        if (restRequest.getParameterOrder() != null) {
            requestResult.setParameterOrder(restRequest.getParameterOrder().getEntryArray());
        }
        this.addHeaders(requestResult, restRequest);
        this.addAttachments(requestResult, restRequest);
        this.addCredential(requestResult, restRequest);
        requestResult.setHttpMethod(methodImportResult.getHttpMethod());
        return requestResult;
    }

    private void setParameters(SoapUIRestRequestImportResult requestResult, StringToStringMap.Entry[] parameterEntries) {
        StringToStringMap.Entry[] entryArray = parameterEntries;
        int n = parameterEntries.length;
        int n2 = 0;
        while (n2 < n) {
            StringToStringMap.Entry parameterEntry = entryArray[n2];
            requestResult.setParameter(parameterEntry.getKey(), parameterEntry.getValue());
            ++n2;
        }
    }

    private void addAttachments(SoapUIRestRequestImportResult requestResult, RestRequest restRequest) {
        Attachment[] attachmentArray = restRequest.getAttachmentArray();
        int n = attachmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attachment attachment = attachmentArray[n2];
            requestResult.newAttachment(attachment.getName(), attachment.getContentType(), attachment.getContentId(), attachment.getUrl());
            ++n2;
        }
    }

    private void addHeaders(SoapUIRestRequestImportResult requestImportResult, RestRequest restRequest) {
        this.getHeaderMap((AbstractRequest)restRequest).entrySet().forEach(e -> requestImportResult.setHeader((String)e.getKey(), (String)e.getValue()));
    }

    private void addCredential(SoapUIRestRequestImportResult requestImportResult, RestRequest restRequest) {
        Credentials credentials = restRequest.getCredentials();
        if (credentials != null && StringUtils.isNotBlank((CharSequence)credentials.getSelectedAuthProfile())) {
            String authProfile = credentials.getSelectedAuthProfile();
            if ("Basic".equals(authProfile)) {
                requestImportResult.setBasicCredential(credentials.getUsername(), credentials.getPassword());
                return;
            }
            if (credentials.getAuthType().toString().equals("OAuth 1.0")) {
                requestImportResult.setOAuth1Profile(authProfile);
                return;
            }
            if (credentials.getAuthType().toString().equals("OAuth 2.0")) {
                requestImportResult.setOAuth2Profile(authProfile);
                return;
            }
        }
    }

    private String getRequestFileName(RestMethodImportResult methodImportResult, RestRequest restRequest) {
        String suggestion = restRequest.getName();
        if (StringUtils.isBlank((CharSequence)suggestion)) {
            suggestion = "Request";
        }
        suggestion = this.toValidFileName(suggestion);
        return suggestion;
    }

    private void addParameters(RestResourceImportNode holder, RestParameter[] restParameters) {
        RestParameter[] restParameterArray = restParameters;
        int n = restParameters.length;
        int n2 = 0;
        while (n2 < n) {
            RestParameter parameter = restParameterArray[n2];
            int parameterStyleCode = parameter.getStyle().intValue();
            String name = parameter.getName();
            String value = parameter.getValue();
            RestParameterImportResult parameterImportResult = holder.hasParameter(name) ? holder.getParameter(name) : holder.addNewParameter(name);
            parameterImportResult.setName(name);
            parameterImportResult.setValue(value);
            if (parameterStyleCode == 1) {
                parameterImportResult.setStyle(RestParameterImportResult.Style.MATRIX);
            } else if (parameterStyleCode == 2) {
                parameterImportResult.setStyle(RestParameterImportResult.Style.HEADER);
            } else if (parameterStyleCode == 3) {
                parameterImportResult.setStyle(RestParameterImportResult.Style.QUERY);
            } else if (parameterStyleCode == 4) {
                parameterImportResult.setStyle(RestParameterImportResult.Style.TEMPLATE);
            }
            ++n2;
        }
    }
}

