/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.soapui;

import com.kms.katalon.composer.webservice.soapui.SoapUIBasicCredential;
import com.kms.katalon.composer.websesrvice.wsdl.SoapRequestFolderImportResult;
import com.kms.katalon.composer.websesrvice.wsdl.SoapRequestImportResult;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SoapUISoapRequestImportResult
extends SoapRequestImportResult {
    private SoapUIBasicCredential basicCredential;
    private Map<String, String> headers = new HashMap<String, String>();

    @Override
    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public SoapUISoapRequestImportResult(String operationName, SoapRequestFolderImportResult bindingImportResult) {
        super(operationName, bindingImportResult);
    }

    public void setBasicCredential(String username, String password) {
        if (this.basicCredential == null) {
            this.basicCredential = new SoapUIBasicCredential();
        }
        this.basicCredential.setUsername(username);
        this.basicCredential.setPassword(password);
    }

    @Override
    public FileEntity getFileEntity() {
        WebServiceRequestEntity requestEntity = (WebServiceRequestEntity)super.getFileEntity();
        requestEntity.getHttpHeaderProperties().addAll(this.getHeaders());
        return requestEntity;
    }

    private List<WebElementPropertyEntity> getHeaders() {
        ArrayList<WebElementPropertyEntity> headerPropertyEntities = new ArrayList<WebElementPropertyEntity>();
        this.headers.entrySet().stream().forEach(e -> {
            WebElementPropertyEntity headerPropertyEntity = new WebElementPropertyEntity();
            headerPropertyEntity.setName((String)e.getKey());
            headerPropertyEntity.setValue((String)e.getValue());
            headerPropertyEntities.add(headerPropertyEntity);
        });
        headerPropertyEntities.addAll(this.getAuthHeaders());
        return headerPropertyEntities;
    }

    private List<WebElementPropertyEntity> getAuthHeaders() {
        if (this.basicCredential != null) {
            return this.basicCredential.getAuthHeaders().entrySet().stream().map(e -> {
                WebElementPropertyEntity headerPropertyEntity = new WebElementPropertyEntity();
                headerPropertyEntity.setName((String)e.getKey());
                headerPropertyEntity.setValue((String)e.getValue());
                return headerPropertyEntity;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

