/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ExpandableComposite {
    private static final int DEFAULT_BODY_MARGIN = 24;
    private CLabel lblHeaderTitle;
    private Composite parent;
    private Composite bodyComposite;
    private Composite composite;
    boolean isExpanded;
    private String title;
    private int detailColumns;

    public ExpandableComposite(Composite parent, String title, int colums, boolean expandOnShow) {
        this.parent = parent;
        this.title = title;
        this.detailColumns = colums;
        this.isExpanded = expandOnShow;
    }

    public Composite createControl() {
        this.composite = new Composite(this.parent, 0);
        GridLayout glCompositeInfo = new GridLayout();
        glCompositeInfo.verticalSpacing = 0;
        glCompositeInfo.horizontalSpacing = 0;
        glCompositeInfo.marginWidth = 0;
        glCompositeInfo.marginHeight = 0;
        this.composite.setLayout((Layout)glCompositeInfo);
        this.composite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.lblHeaderTitle = new CLabel(this.composite, 0);
        this.lblHeaderTitle.setCursor(Display.getCurrent().getSystemCursor(21));
        this.lblHeaderTitle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.lblHeaderTitle.setText(this.title);
        this.lblHeaderTitle.setFont(JFaceResources.getFontRegistry().getBold(""));
        this.bodyComposite = new Composite(this.composite, 0);
        GridLayout glBodyComposite = new GridLayout(this.detailColumns, false);
        glBodyComposite.marginRight = 24;
        glBodyComposite.marginLeft = 24;
        glBodyComposite.marginHeight = 0;
        glBodyComposite.marginWidth = 0;
        this.bodyComposite.setLayout((Layout)glBodyComposite);
        this.bodyComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookControlSelectListerners();
        this.expandCollapseBody();
        return this.bodyComposite;
    }

    private void redrawHeaderTitleIndicator() {
        this.lblHeaderTitle.getParent().setRedraw(false);
        this.lblHeaderTitle.setImage(this.isExpanded ? ImageConstants.IMG_16_ARROW_DOWN : ImageConstants.IMG_16_ARROW);
        this.lblHeaderTitle.getParent().setRedraw(true);
    }

    private void hookControlSelectListerners() {
        this.lblHeaderTitle.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ExpandableComposite.this.expandCollapseBody();
            }
        });
    }

    private void expandCollapseBody() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ExpandableComposite.this.bodyComposite.setVisible(ExpandableComposite.this.isExpanded);
                GridData gdBodyComposite = (GridData)ExpandableComposite.this.bodyComposite.getLayoutData();
                gdBodyComposite.exclude = !ExpandableComposite.this.isExpanded;
                ExpandableComposite.this.composite.layout(true, true);
                ExpandableComposite.this.composite.getParent().layout();
                ExpandableComposite.this.redrawHeaderTitleIndicator();
                ExpandableComposite.this.isExpanded = !ExpandableComposite.this.isExpanded;
            }
        });
    }
}

