/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.importing.model.WebServiceImportNode;
import com.kms.katalon.composer.webservice.soapui.SoapUIImporter;
import com.kms.katalon.composer.webservice.soapui.SoapUIProjectImportResult;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.util.UrlUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportFromSoapUIDialog
extends CustomTitleAreaDialog {
    private FolderEntity parentFolder;
    private String projectFilePath = "";
    private Text txtProjectFile;
    private Button btnBrowseFile;
    private String directory = "";

    public ImportFromSoapUIDialog(Shell shell, FolderEntity parentFolder) {
        super(shell);
        this.parentFolder = parentFolder;
    }

    protected Composite createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setText(ComposerWebserviceMessageConstants.ImportFromSoapUIDialog_LBL_SOAPUI_PROJECT);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtProjectFile = new Text(composite, 2048);
        GridData gdTxtProjectFile = new GridData(4, 4, true, false);
        gdTxtProjectFile.widthHint = 300;
        this.txtProjectFile.setLayoutData((Object)gdTxtProjectFile);
        this.btnBrowseFile = new Button(composite, 8);
        this.btnBrowseFile.setText(StringConstants.BROWSE);
        this.btnBrowseFile.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.setMessage(ComposerWebserviceMessageConstants.ImportFromSoapUIDialog_MSG_IMPORT_REQUESTS_FROM_SOAPUI_PROJECT, 1);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void registerControlModifyListeners() {
        this.txtProjectFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Button btnOk = ImportFromSoapUIDialog.this.getButton(0);
                String text = ((Text)e.widget).getText();
                if (StringUtils.isBlank((CharSequence)text)) {
                    btnOk.setEnabled(false);
                } else {
                    btnOk.setEnabled(true);
                }
                ImportFromSoapUIDialog.this.projectFilePath = UrlUtil.toFileUrl((String)text);
            }
        });
        this.btnBrowseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(ImportFromSoapUIDialog.this.getParentShell(), 4);
                String filePath = fileDialog.open();
                ImportFromSoapUIDialog.this.txtProjectFile.setText(filePath);
                ImportFromSoapUIDialog.this.directory = filePath;
                ImportFromSoapUIDialog.this.projectFilePath = UrlUtil.toFileUrl((String)filePath);
            }
        });
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComposerWebserviceMessageConstants.ImportFromSoapUIDialog_DIA_TITLE_IMPORT_FROM_SOAPUI);
    }

    protected void okPressed() {
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(ComposerWebserviceMessageConstants.ImportFromSoapUIDialog_MSG_IMPORTING_FROM_SOAPUI, -1);
                            ImportFromSoapUIDialog.this.importRestServicesFromSoapUI();
                        }
                        catch (Exception e) {
                            LoggerSingleton.logError((Throwable)e);
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            super.okPressed();
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            LoggerSingleton.logError((Throwable)target);
            MultiStatusErrorDialog.showErrorDialog((String)ComposerWebserviceMessageConstants.ERROR_MSG_FAIL_TO_IMPORT_SOAPUI, (String)target.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)target));
        }
        catch (InterruptedException interruptedException) {}
    }

    private void importRestServicesFromSoapUI() throws Exception {
        SoapUIImporter importer = new SoapUIImporter();
        SoapUIProjectImportResult projectImportResult = importer.importServices(this.projectFilePath, this.parentFolder);
        this.saveImportedArtifacts(projectImportResult);
        this.getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)projectImportResult.getFileEntity()));
        this.getEventBroker().post("EXPLORER/SET_SELECTED_ITEM", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)projectImportResult.getFileEntity()));
    }

    private void saveImportedArtifacts(SoapUIProjectImportResult projectImportResult) throws Exception {
        List importNodes = this.flatten(projectImportResult).collect(Collectors.toList());
        for (WebServiceImportNode importNode : importNodes) {
            FileEntity fileEntity = importNode.getFileEntity();
            if (fileEntity != null && fileEntity instanceof FolderEntity) {
                FolderController.getInstance().saveFolder((FolderEntity)fileEntity);
            }
            if (fileEntity == null || !(fileEntity instanceof WebServiceRequestEntity)) continue;
            ObjectRepositoryController.getInstance().saveNewTestObject((WebElementEntity)((WebServiceRequestEntity)fileEntity));
        }
    }

    private Stream<WebServiceImportNode> flatten(WebServiceImportNode importNode) {
        Stream childImportNodes = importNode.getChildImportNodes().stream().flatMap(n -> this.flatten((WebServiceImportNode)n));
        return Stream.concat(Stream.of(importNode), childImportNodes);
    }

    private IEventBroker getEventBroker() {
        return EventBrokerSingleton.getInstance().getEventBroker();
    }

    protected void setInput() {
    }

    public String getSoapUISpecLocation() {
        return this.directory;
    }
}

