/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.parser.PostmanParseUtils;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportWebServiceObjectsFromPostmanDialog
extends CustomTitleAreaDialog {
    private FolderEntity parentFolder;
    private List<WebServiceRequestEntity> webServiceRequestEntities;
    private String directory = "";

    public ImportWebServiceObjectsFromPostmanDialog(Shell parentShell, FolderEntity parentFolder) {
        super(parentShell);
        Trackings.trackOpenImportingPostman();
        this.parentFolder = parentFolder;
    }

    public void createWebServiceRequestEntities() throws Exception {
        this.webServiceRequestEntities = PostmanParseUtils.newWSTestObjectsFromPostman(this.parentFolder, this.directory);
    }

    public List<WebServiceRequestEntity> getWebServiceRequestEntities() {
        return this.webServiceRequestEntities;
    }

    protected void okPressed() {
        Button ok = this.getButton(0);
        boolean closeTheDialog = true;
        try {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                monitor.beginTask("Importing Web Service Requests from Postman...", -1);
                                ImportWebServiceObjectsFromPostmanDialog.this.createWebServiceRequestEntities();
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (Exception e) {
                closeTheDialog = false;
                this.setMessage(e.getMessage(), 3);
                ok.setEnabled(false);
                if (closeTheDialog) {
                    super.okPressed();
                }
            }
        }
        finally {
            if (closeTheDialog) {
                super.okPressed();
            }
        }
    }

    protected boolean isResizable() {
        return false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ_POSTMAN);
    }

    protected Composite createContentArea(Composite parent) {
        this.setDialogTitle(StringConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ_POSTMAN);
        this.setMessage(StringConstants.DIA_MSG_IMPORT_WEBSERVICE_REQ_POSTMAN, 1);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("File location : ");
        final Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        Composite methodComposite = new Composite(composite, 0);
        GridLayout glMethodComposite = new GridLayout();
        methodComposite.setLayout((Layout)glMethodComposite);
        Button button = new Button(methodComposite, 8);
        button.setText(StringConstants.BROWSE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog directoryDialog = new FileDialog(ImportWebServiceObjectsFromPostmanDialog.this.getParentShell());
                String filePath = directoryDialog.open();
                if (filePath != null) {
                    text.setText(filePath);
                    ImportWebServiceObjectsFromPostmanDialog.this.directory = filePath;
                }
            }
        });
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Button ok = ImportWebServiceObjectsFromPostmanDialog.this.getButton(0);
                if (!ok.isEnabled()) {
                    ok.setEnabled(true);
                }
                ok.setEnabled(!text.getText().isEmpty());
                ImportWebServiceObjectsFromPostmanDialog.this.directory = ((Text)e.widget).getText();
            }
        };
        text.addModifyListener(listener);
        this.messageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"https://schema.getpostman.com/collection/json/v2.1.0/draft-07/docs/index.html");
            }
        });
        return composite;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = this.convertWidthInCharsToPixels(75);
        return size;
    }

    public String getPostmanSpecLocation() {
        return this.directory;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

