/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.impl.dialogs.CommonNewEntityDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewRequestDialog
extends CommonNewEntityDialog<WebServiceRequestEntity> {
    private String webServiveType = WebServiceRequestEntity.SERVICE_TYPES[1];
    private String endPoint = "";
    private Combo cbbRequestType;

    public NewRequestDialog(Shell parentShell, FolderEntity parentFolder, String suggestedName) {
        super(parentShell, parentFolder, suggestedName);
        this.setDialogTitle(StringConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ);
        this.setDialogMsg(StringConstants.VIEW_DIA_MSG_CREATE_NEW_WEBSERVICE_REQ);
    }

    protected Control createEntityCustomControl(Composite parent, int column, int span) {
        this.createRequestTypeControl(parent, column);
        this.createURIControl(parent, column);
        return super.createEntityCustomControl(parent, column, span);
    }

    private Control createRequestTypeControl(Composite parent, int column) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(column, false));
        Label labelRequestType = new Label(parent, 0);
        labelRequestType.setText(StringConstants.VIEW_LBL_REQ_TYPE);
        this.cbbRequestType = new Combo(parent, 8);
        this.cbbRequestType.setLayoutData((Object)new GridData(768));
        this.cbbRequestType.setItems(WebServiceRequestEntity.SERVICE_TYPES);
        this.cbbRequestType.select(1);
        this.cbbRequestType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRequestDialog.this.setWebServiveType(((Combo)e.getSource()).getText());
            }
        });
        return parent;
    }

    private void setWebServiveType(String webServiveType) {
        this.webServiveType = webServiveType;
    }

    private void setEndPoint(String url) {
        this.endPoint = url;
    }

    protected void createEntity() {
        try {
            this.entity = ObjectRepositoryController.getInstance().newWSTestObjectWithoutSave(this.parentFolder, this.getName());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void setEntityProperties() {
        super.setEntityProperties();
        ((WebServiceRequestEntity)this.entity).setServiceType(this.webServiveType);
        if ("SOAP".equals(this.webServiveType)) {
            ((WebServiceRequestEntity)this.entity).setWsdlAddress(this.endPoint);
            ((WebServiceRequestEntity)this.entity).setSoapRequestMethod("SOAP");
            ((WebServiceRequestEntity)this.entity).setUseServiceInfoFromWsdl(false);
        } else {
            ((WebServiceRequestEntity)this.entity).setRestUrl(this.endPoint);
            ((WebServiceRequestEntity)this.entity).setRestRequestMethod("GET");
        }
    }

    private Control createURIControl(Composite parent, int column) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(column, false));
        Label labelName = new Label(parent, 0);
        labelName.setText(StringConstants.PA_LBL_URL);
        Text textURL = new Text(parent, 2048);
        textURL.setLayoutData((Object)new GridData(768));
        textURL.setMessage(StringConstants.PA_LBL_URL);
        textURL.selectAll();
        textURL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRequestDialog.this.setEndPoint(((Text)e.getSource()).getText());
            }
        });
        return parent;
    }
}

