/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ParameterTable
extends TableViewer {
    public static final String[] columnNames = new String[]{StringConstants.VIEW_COL_NAME, StringConstants.VIEW_COL_VALUE};
    private List<WebElementPropertyEntity> data;
    private MDirtyable dirtyable;

    public ParameterTable(Composite parent, int style, MDirtyable dirtyable) {
        super(parent, style);
        this.dirtyable = dirtyable;
    }

    public void setInput(List<WebElementPropertyEntity> data) {
        this.data = data;
        super.setInput(data);
    }

    public void addRow() {
        this.addRow(new WebElementPropertyEntity(StringConstants.EMPTY, StringConstants.EMPTY));
    }

    public void addRow(WebElementPropertyEntity property) {
        this.data.add(property);
        this.markDirty();
        this.editElement(property, 0);
    }

    public void addRow(WebElementPropertyEntity property, int index) {
        this.data.add(index + 1, property);
        this.markDirty();
        this.editElement(property, 0);
    }

    public void addRows(List<WebElementPropertyEntity> properties) {
        this.data.addAll(properties);
        this.markDirty();
    }

    public boolean deleteRowByColumnValue(int columnIndex, String value) {
        return this.getInput().removeIf(i -> i.getName().equals(value));
    }

    public void deleteSelections() {
        ArrayList<WebElementPropertyEntity> selectedRows = new ArrayList<WebElementPropertyEntity>();
        Arrays.stream(this.getTable().getSelectionIndices()).forEach(i -> {
            boolean bl = selectedRows.add(this.data.get(i));
        });
        if (selectedRows.isEmpty()) {
            return;
        }
        this.deleteRows(selectedRows);
        if (OSUtil.isMacBigSurOrLater()) {
            this.getTable().redraw();
        }
    }

    public void deleteRows(List<WebElementPropertyEntity> properties) {
        this.data.removeAll(properties);
        if (OSUtil.isMacBigSurOrLater()) {
            this.getTable().redraw();
        }
        this.markDirty();
    }

    public void markDirty() {
        this.refresh();
        if (this.dirtyable != null) {
            this.dirtyable.setDirty(true);
        }
    }

    public List<WebElementPropertyEntity> getInput() {
        if (this.data == null) {
            this.data = new ArrayList<WebElementPropertyEntity>();
        }
        return this.data;
    }

    public void removeEmptyProperty() {
        ArrayList<WebElementPropertyEntity> excluded = new ArrayList<WebElementPropertyEntity>();
        for (WebElementPropertyEntity prop : this.data) {
            if (prop.getName() != null && !prop.getName().equals(StringConstants.EMPTY)) continue;
            excluded.add(prop);
        }
        this.data.removeAll(excluded);
        this.refresh();
    }

    public void createTableEditor() {
        Table table = this.getTable();
        TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                ParameterTable.this.createContextMenu();
            }
        });
    }

    private Menu createContextMenu() {
        final Table table = this.getTable();
        Menu menu = table.getMenu();
        if (menu != null) {
            menu.dispose();
        }
        menu = new Menu((Control)table);
        MenuItem menuItem = null;
        menuItem = new MenuItem(menu, 8);
        menuItem.setText(StringConstants.VIEW_MENU_CONTEXT_INSERT_PROP);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebElementPropertyEntity newProp = new WebElementPropertyEntity(StringConstants.EMPTY, StringConstants.EMPTY);
                TableItem[] items = table.getSelection();
                if (items.length > 0) {
                    ParameterTable.this.addRow(newProp, table.indexOf(items[0]));
                } else {
                    ParameterTable.this.addRow(newProp);
                }
            }
        });
        if (table.getItemCount() >= 1) {
            menuItem = new MenuItem(menu, 8);
            menuItem.setText(StringConstants.VIEW_MENU_CONTEXT_DEL_PROPS);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ParameterTable.this.deleteSelections();
                }
            });
        }
        table.setMenu(menu);
        return menu;
    }
}

