/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.websesrvice.wsdl;

import com.kms.katalon.composer.websesrvice.wsdl.SoapRequestFolderImportResult;
import com.kms.katalon.composer.websesrvice.wsdl.SoapRequestImportResult;
import com.kms.katalon.composer.websesrvice.wsdl.WsdlImportResult;
import com.kms.katalon.core.webservice.util.WsdlUtil;
import com.kms.katalon.core.webservice.wsdl.support.wsdl.WsdlDefinitionLocator;
import com.kms.katalon.entity.folder.FolderEntity;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLLocator;

public class WsdlImporter {
    private WsdlDefinitionLocator wsdlLocator;

    public WsdlImporter(WsdlDefinitionLocator wsdlLocator) {
        this.wsdlLocator = wsdlLocator;
    }

    public WsdlImportResult importWsdl(FolderEntity rootFolder) throws WSDLException {
        Collection bindings;
        WsdlImportResult importResult = new WsdlImportResult(this.wsdlLocator.getWsdlLocation(), "SOAP Service", rootFolder);
        Definition definition = WsdlUtil.getDefinition((WSDLLocator)this.wsdlLocator);
        Map serviceMap = definition.getAllServices();
        HashSet<String> bindingNames = new HashSet<String>();
        if (serviceMap != null && !serviceMap.isEmpty()) {
            Collection services = serviceMap.values();
            for (Service service : services) {
                Map portMap = service.getPorts();
                if (portMap == null || portMap.isEmpty()) continue;
                Collection ports = portMap.values();
                for (Port port : ports) {
                    String portAddress = WsdlUtil.getPortAddressLocation((Port)port);
                    Binding binding = port.getBinding();
                    if (binding == null) continue;
                    this.createRequestsFromBinding(binding, portAddress, importResult);
                    bindingNames.add(binding.getQName().toString());
                }
            }
        }
        if ((bindings = definition.getAllBindings().values()) != null && !bindings.isEmpty()) {
            for (Binding binding : bindings) {
                if (bindingNames.contains(binding.getQName().toString())) continue;
                this.createRequestsFromBinding(binding, "", importResult);
            }
        }
        return importResult;
    }

    private void createRequestsFromBinding(Binding binding, String portAddress, WsdlImportResult importResult) {
        String method = WsdlUtil.getBindingMethod((Binding)binding);
        SoapRequestFolderImportResult requestFolderImportResult = importResult.newRequestFolder(binding.getQName().getLocalPart(), method);
        List operations = binding.getBindingOperations();
        for (BindingOperation operation : operations) {
            SoapRequestImportResult requestResult = requestFolderImportResult.newRequest(operation.getName(), name -> new SoapRequestImportResult((String)name, requestFolderImportResult));
            requestResult.setServiceEndpoint(portAddress);
            requestResult.setOperationName(operation.getName());
            requestResult.setOperationUri(WsdlUtil.getOperationUri((BindingOperation)operation));
            String requestMessage = WsdlUtil.getSampleRequestMessage((String)this.wsdlLocator.getWsdlLocation(), (String)binding.getQName().toString(), (String)operation.getName());
            requestResult.setRequestMessage(requestMessage);
        }
    }
}

