/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.handler;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.qtest.constant.ComposerIntegrationQtestMessageConstants;
import com.kms.katalon.composer.integration.qtest.dialog.BatchCheckForTestCaseUpdatesResultDialog;
import com.kms.katalon.composer.integration.qtest.dialog.QTestIntegratedTestCaseSelectionDialog;
import com.kms.katalon.composer.integration.qtest.dialog.model.BatchCheckForTestCaseUpdatesResult;
import com.kms.katalon.composer.integration.qtest.handler.QTestCheckForUpdatesBaseHandler;
import com.kms.katalon.composer.integration.qtest.job.CheckForTestCaseUpdatesBatchJob;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class QTestBatchCheckForTestCaseUpdatesHandler
extends QTestCheckForUpdatesBaseHandler {
    private static final long DIALOG_CLOSED_DELAY_MILLIS = 500L;

    @CanExecute
    public boolean canExecute() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        return project != null && QTestIntegrationUtil.isIntegrationEnable((ProjectEntity)project);
    }

    @Execute
    public void execute() {
        try {
            ArrayList<TestCaseEntity> selectedTestCases = new ArrayList<TestCaseEntity>();
            QTestIntegratedTestCaseSelectionDialog dialog = new QTestIntegratedTestCaseSelectionDialog(this.getActiveShell());
            if (dialog.open() != 0) {
                return;
            }
            List selectedTestCaseTreeEntities = dialog.getSelectedTestCases();
            for (TestCaseTreeEntity entity : selectedTestCaseTreeEntities) {
                selectedTestCases.add(entity.getObject());
            }
            if (selectedTestCases.isEmpty()) {
                MessageDialog.openWarning((Shell)this.getActiveShell(), (String)StringConstants.WARN, (String)ComposerIntegrationQtestMessageConstants.QTestBatchCheckForTestCaseUpdatesHandler_MSG_NO_TEST_CASE_SELECTED);
                return;
            }
            if (!QTestBatchCheckForTestCaseUpdatesHandler.validateTestCasesNotDirty(selectedTestCases)) {
                MessageDialog.openWarning((Shell)this.getActiveShell(), (String)StringConstants.WARN, (String)ComposerIntegrationQtestMessageConstants.QTestBatchCheckForTestCaseUpdatesHandler_MSG_WARN_SAVE_ALL_TEST_CASES);
                return;
            }
            final CheckForTestCaseUpdatesBatchJob checkForUpdatesJob = new CheckForTestCaseUpdatesBatchJob("Check for updates", selectedTestCases);
            checkForUpdatesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (!checkForUpdatesJob.getResult().isOK()) {
                        return;
                    }
                    Executors.newSingleThreadExecutor().submit(() -> {
                        try {
                            TimeUnit.MILLISECONDS.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        UISynchronizeService.syncExec(() -> {
                            BatchCheckForTestCaseUpdatesResult result = checkForUpdatesJob.getCheckForUpdatesResult();
                            BatchCheckForTestCaseUpdatesResultDialog resultDialog = new BatchCheckForTestCaseUpdatesResultDialog(QTestBatchCheckForTestCaseUpdatesHandler.this.getActiveShell(), result);
                            resultDialog.open();
                        });
                    });
                }
            });
            checkForUpdatesJob.setUser(true);
            checkForUpdatesJob.schedule();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private Shell getActiveShell() {
        return Display.getCurrent().getActiveShell();
    }

    static /* synthetic */ Shell access$0(QTestBatchCheckForTestCaseUpdatesHandler qTestBatchCheckForTestCaseUpdatesHandler) {
        return qTestBatchCheckForTestCaseUpdatesHandler.getActiveShell();
    }
}

