/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.job;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.SynchronizedConfirmationDialog;
import com.kms.katalon.composer.components.impl.dialogs.YesNoAllOptions;
import com.kms.katalon.composer.components.impl.util.StatusUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.job.DisintegrateTestCaseJob;
import com.kms.katalon.composer.integration.qtest.job.QTestJob;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationFolderManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestCaseManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestModule;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.MessageDialog;

public class UploadTestCaseJob
extends QTestJob {
    private UISynchronize sync;
    private List<IntegratedFileEntity> uploadedEntities;
    private IQTestCredential credential;

    public UploadTestCaseJob(String name, UISynchronize sync) {
        super(name);
        this.setUser(true);
        this.sync = sync;
        this.credential = QTestSettingCredential.getCredential((String)this.getProjectDir());
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.uploadedEntities = new ArrayList<IntegratedFileEntity>();
        monitor.beginTask(StringConstants.JOB_TASK_UPLOAD_TEST_CASE, this.getFileEntities().size());
        for (FileEntity fileEntity : this.getFileEntities()) {
            try {
                if (monitor.isCanceled()) {
                    return this.canceled();
                }
                if (fileEntity instanceof TestCaseEntity) {
                    TestCaseEntity testCaseEntity = (TestCaseEntity)fileEntity;
                    this.uploadTestCase(testCaseEntity, monitor);
                } else if (fileEntity instanceof FolderEntity) {
                    FolderEntity folderEntity = (FolderEntity)fileEntity;
                    this.uploadFolder(folderEntity, monitor);
                }
                monitor.worked(1);
            }
            catch (OperationCanceledException operationCanceledException) {
                return this.canceled();
            }
            catch (Exception e) {
                this.performErrorNotification(e);
                monitor.setCanceled(true);
                LoggerSingleton.logError((Throwable)e);
                return StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus canceled() {
        final int uploadedCount = this.uploadedEntities.size();
        if (uploadedCount == 0) {
            return Status.CANCEL_STATUS;
        }
        SynchronizedConfirmationDialog dialog = new SynchronizedConfirmationDialog(){

            public void run() {
                boolean confirmed = MessageDialog.open((int)3, null, (String)StringConstants.CONFIRMATION, (String)MessageFormat.format(StringConstants.JOB_MSG_CONFIRM_CANCEL_UPLOAD, uploadedCount), (int)0);
                this.setConfirmedValue(confirmed ? YesNoAllOptions.YES : YesNoAllOptions.NO);
            }
        };
        this.sync.syncExec((Runnable)dialog);
        if (dialog.getConfirmedValue() == YesNoAllOptions.NO) {
            DisintegrateTestCaseJob job = new DisintegrateTestCaseJob(false);
            job.setFileEntities(this.uploadedEntities);
            job.doTask();
        }
        return Status.CANCEL_STATUS;
    }

    private void uploadFolder(FolderEntity folderEntity, IProgressMonitor monitor) throws Exception {
        String folderId = folderEntity.getIdForDisplay();
        monitor.subTask(MessageFormat.format(StringConstants.JOB_SUB_TASK_UPLOAD_TEST_CASE, folderId));
        QTestProject qTestProject = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)folderEntity, (ProjectEntity)this.projectEntity).getQTestProject();
        QTestModule qTestParentModule = QTestIntegrationFolderManager.getQTestModuleByFolderEntity((FolderEntity)folderEntity.getParentFolder());
        QTestModule qTestModule = null;
        QTestIntegrationFolderManager.updateModule((IQTestCredential)this.credential, (long)qTestProject.getId(), (QTestModule)qTestParentModule, (boolean)false);
        for (QTestModule siblingQTestModule : qTestParentModule.getChildModules()) {
            if (!folderEntity.getName().equalsIgnoreCase(siblingQTestModule.getName())) continue;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            SynchronizedConfirmationDialog dialog = this.performFolderDuplicatedConfirmation(folderId, siblingQTestModule);
            this.sync.syncExec((Runnable)dialog);
            if (dialog.getConfirmedValue() != YesNoAllOptions.YES) break;
            qTestModule = siblingQTestModule;
            break;
        }
        if (qTestModule == null) {
            qTestModule = this.createNewQTestModule(qTestProject, qTestParentModule, folderEntity);
        }
        folderEntity.getIntegratedEntities().add(QTestIntegrationFolderManager.getFolderIntegratedEntityByQTestModule(qTestModule));
        FolderController.getInstance().saveFolder(folderEntity);
        this.uploadedEntities.add((IntegratedFileEntity)folderEntity);
    }

    private void uploadTestCase(TestCaseEntity testCaseEntity, IProgressMonitor monitor) throws Exception {
        QTestProject qTestProject = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)testCaseEntity, (ProjectEntity)this.projectEntity).getQTestProject();
        String testCaseId = testCaseEntity.getIdForDisplay();
        monitor.subTask(MessageFormat.format(StringConstants.JOB_SUB_TASK_UPLOAD_TEST_CASE, testCaseId));
        QTestModule qTestParentModule = QTestIntegrationFolderManager.getQTestModuleByFolderEntity((FolderEntity)testCaseEntity.getParentFolder());
        if (qTestParentModule == null || qTestParentModule.getId() <= 0L) {
            return;
        }
        QTestTestCase qTestTestCase = null;
        QTestIntegrationFolderManager.updateModule((IQTestCredential)this.credential, (long)qTestProject.getId(), (QTestModule)qTestParentModule, (boolean)false);
        for (QTestTestCase siblingQTestCase : qTestParentModule.getChildTestCases()) {
            if (!testCaseEntity.getName().equalsIgnoreCase(siblingQTestCase.getName())) continue;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            SynchronizedConfirmationDialog dialog = this.performTestCaseDuplicatedConfirmation(testCaseId, siblingQTestCase);
            this.sync.syncExec((Runnable)dialog);
            if (dialog.getConfirmedValue() != YesNoAllOptions.YES) break;
            qTestTestCase = siblingQTestCase;
            break;
        }
        if (qTestTestCase == null) {
            qTestTestCase = this.createNewQTestCase(qTestProject, qTestParentModule, testCaseEntity);
        }
        if (qTestTestCase.getVersionId() <= 0L) {
            qTestTestCase.setVersionId(QTestIntegrationTestCaseManager.getTestCaseVersionId((IQTestCredential)this.credential, (long)qTestProject.getId(), (long)qTestTestCase.getId()));
        }
        testCaseEntity.getIntegratedEntities().add(QTestIntegrationTestCaseManager.getIntegratedEntityByQTestTestCase((QTestTestCase)qTestTestCase));
        TestCaseController.getInstance().updateTestCase(testCaseEntity);
        this.uploadedEntities.add((IntegratedFileEntity)testCaseEntity);
        this.getEventBroker().post("TESTCASE/UPDATED", (Object)new Object[]{testCaseEntity.getId(), testCaseEntity});
        this.getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)testCaseEntity, (ProjectEntity)this.projectEntity));
    }

    private IEventBroker getEventBroker() {
        return EventBrokerSingleton.getInstance().getEventBroker();
    }

    private QTestTestCase createNewQTestCase(QTestProject qTestProject, QTestModule qTestParentModule, TestCaseEntity testCaseEntity) throws Exception {
        return QTestIntegrationTestCaseManager.addTestCase((QTestProject)qTestProject, (long)qTestParentModule.getId(), (String)testCaseEntity.getName(), (String)testCaseEntity.getDescription(), (IQTestCredential)this.credential);
    }

    private QTestModule createNewQTestModule(QTestProject qTestProject, QTestModule qTestParentModule, FolderEntity folderEntity) throws QTestUnauthorizedException, QTestInvalidFormatException {
        return QTestIntegrationFolderManager.createNewQTestTCFolder((IQTestCredential)this.credential, (long)qTestProject.getId(), (long)qTestParentModule.getId(), (String)folderEntity.getName());
    }

    private void performErrorNotification(final Exception ex) {
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)StringConstants.DIA_MSG_UNABLE_UPLOAD_TEST_CASE, (String)ex.getClass().getSimpleName());
            }
        });
    }

    private SynchronizedConfirmationDialog performTestCaseDuplicatedConfirmation(final String testCaseId, final QTestTestCase siblingQTestCase) {
        return new SynchronizedConfirmationDialog(){

            public void run() {
                boolean confirmed = MessageDialog.open((int)3, null, (String)StringConstants.DIA_TITLE_TEST_CASE_DUPLICATION, (String)MessageFormat.format(StringConstants.DIA_MSG_CONFIRM_MERGE_UPLOADED_TEST_CASE, siblingQTestCase.getId(), testCaseId), (int)0);
                this.setConfirmedValue(confirmed ? YesNoAllOptions.YES : YesNoAllOptions.NO);
            }
        };
    }

    private SynchronizedConfirmationDialog performFolderDuplicatedConfirmation(final String folderId, final QTestModule siblingQTestModule) {
        return new SynchronizedConfirmationDialog(){

            public void run() {
                boolean confirmed = MessageDialog.open((int)3, null, (String)StringConstants.DIA_TITLE_FOLDER_DUPLICATION, (String)MessageFormat.format(StringConstants.DIA_MSG_CONFIRM_MERGE_UPLOADED_TEST_CASE_FOLDER, siblingQTestModule.getId(), folderId), (int)0);
                this.setConfirmedValue(confirmed ? YesNoAllOptions.YES : YesNoAllOptions.NO);
            }
        };
    }
}

