/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.job;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.SynchronizedConfirmationDialog;
import com.kms.katalon.composer.components.impl.dialogs.YesNoAllOptions;
import com.kms.katalon.composer.components.impl.util.StatusUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.handler.QTestDisintegrateReportHandler;
import com.kms.katalon.composer.integration.qtest.job.QTestJob;
import com.kms.katalon.composer.report.lookup.LogRecordLookup;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationReportManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestSuiteManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestLog;
import com.kms.katalon.integration.qtest.entity.QTestLogUploadedPreview;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestRun;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.model.ReportTestCaseLogPair;
import com.kms.katalon.integration.qtest.model.ReportUploadedPreviewPair;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

public class UploadTestCaseResultJob
extends QTestJob {
    private List<ReportUploadedPreviewPair> fUnuploadedPairs;
    private List<ReportTestCaseLogPair> fUploadedTestLogPairs;

    public UploadTestCaseResultJob(List<ReportUploadedPreviewPair> uploadedPairs) {
        super(StringConstants.JOB_TITLE_UPLOAD_TEST_RESULT);
        this.fUnuploadedPairs = uploadedPairs;
        this.fUploadedTestLogPairs = new ArrayList<ReportTestCaseLogPair>();
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            int total = this.fUnuploadedPairs.size();
            monitor.beginTask(StringConstants.JOB_TASK_UPLOAD_TEST_RESULT, total);
            for (ReportUploadedPreviewPair pair : this.fUnuploadedPairs) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = this.canceled();
                    return iStatus;
                }
                IStatus childStatus = this.uploadPair((IProgressMonitor)new SubProgressMonitor(monitor, 1, 4), pair);
                if (childStatus == Status.CANCEL_STATUS) {
                    IStatus iStatus = this.canceled();
                    return iStatus;
                }
                if (childStatus.getSeverity() != 4) continue;
                IStatus iStatus = childStatus;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private IStatus canceled() {
        final int uploadedCount = this.fUploadedTestLogPairs.size();
        if (uploadedCount == 0) {
            return Status.CANCEL_STATUS;
        }
        SynchronizedConfirmationDialog dialog = new SynchronizedConfirmationDialog(){

            public void run() {
                boolean confirmed = MessageDialog.open((int)3, null, (String)StringConstants.CONFIRMATION, (String)MessageFormat.format(StringConstants.JOB_MSG_CONFIRM_CANCEL_UPLOAD, uploadedCount), (int)0);
                this.setConfirmedValue(confirmed ? YesNoAllOptions.YES : YesNoAllOptions.NO);
            }
        };
        UISynchronizeService.getInstance().getSync().syncExec((Runnable)dialog);
        if (dialog.getConfirmedValue() == YesNoAllOptions.NO) {
            QTestDisintegrateReportHandler.performDisintegrateTestCaseLogs(this.fUploadedTestLogPairs, false);
        }
        return Status.CANCEL_STATUS;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus uploadPair(IProgressMonitor monitor, ReportUploadedPreviewPair pair) {
        IStatus iStatus;
        ArrayList<TestCaseLogRecord> uploadedTestCaseLogs;
        ReportEntity reportEntity;
        block17: {
            reportEntity = pair.getReportEntity();
            List uploadedPreviewLst = pair.getTestLogs();
            uploadedTestCaseLogs = new ArrayList<TestCaseLogRecord>();
            TestSuiteEntity testSuiteEntity = ReportController.getInstance().getTestSuiteByReport(reportEntity);
            monitor.beginTask(StringConstants.JOB_TASK_UPLOAD_TEST_RESULT, uploadedPreviewLst.size());
            ArrayList<IStatus> errorStatuses = new ArrayList<IStatus>();
            ArrayList<String> failedTestResultUploads = new ArrayList<String>();
            for (QTestLogUploadedPreview uploadedItem : uploadedPreviewLst) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.subTask(MessageFormat.format(StringConstants.JOB_SUB_TASK_UPLOAD_TEST_RESULT, this.getWrappedName(uploadedItem.getTestCaseLogRecord().getName())));
                IntegratedEntity testSuiteIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuiteEntity);
                List qTestSuiteCollection = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity((IntegratedEntity)testSuiteIntegratedEntity);
                QTestRun qTestRun = uploadedItem.getQTestRun();
                if (qTestRun == null) {
                    qTestRun = this.getQTestRun(uploadedItem, QTestIntegrationUtil.getCurrentQTestRuns((TestSuiteEntity)testSuiteEntity, (ProjectEntity)this.projectEntity));
                    if (qTestRun == null) {
                        try {
                            qTestRun = QTestIntegrationTestSuiteManager.uploadTestCaseInTestSuite((QTestTestCase)uploadedItem.getQTestCase(), (QTestSuite)uploadedItem.getQTestSuite(), (QTestProject)uploadedItem.getQTestProject(), (IQTestCredential)QTestSettingCredential.getCredential((String)this.getProjectDir()));
                            uploadedItem.setQTestRun(qTestRun);
                        }
                        catch (Exception e) {
                            monitor.setCanceled(true);
                            LoggerSingleton.logError((Throwable)e);
                            IStatus iStatus2 = StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)e);
                            ReportTestCaseLogPair uploadedPair = new ReportTestCaseLogPair(reportEntity, uploadedTestCaseLogs);
                            this.fUploadedTestLogPairs.add(uploadedPair);
                            monitor.done();
                            EventBrokerSingleton.getInstance().getEventBroker().post("REPORT/UPDATED", (Object)new Object[]{reportEntity.getId(), reportEntity});
                            return iStatus2;
                        }
                    } else {
                        qTestRun.setQTestCaseId(uploadedItem.getQTestCase().getId());
                    }
                    testSuiteEntity = QTestIntegrationUtil.addNewTestRunToTestSuite((TestSuiteEntity)testSuiteEntity, (IntegratedEntity)testSuiteIntegratedEntity, (QTestSuite)uploadedItem.getQTestSuite(), (QTestRun)qTestRun, (List)qTestSuiteCollection);
                    uploadedItem.setQTestRun(qTestRun);
                }
                try {
                    QTestLog qTestCaseLog = QTestIntegrationReportManager.uploadTestLog((String)this.getProjectDir(), (QTestLogUploadedPreview)uploadedItem, (String)QTestIntegrationUtil.getTempDirPath(), (TestSuiteLogRecord)LogRecordLookup.getInstance().getTestSuiteLogRecord(reportEntity));
                    uploadedItem.setQTestLog(qTestCaseLog);
                    QTestIntegrationUtil.saveReportEntity((ReportEntity)reportEntity, (QTestLogUploadedPreview)uploadedItem);
                    uploadedTestCaseLogs.add(uploadedItem.getTestCaseLogRecord());
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    errorStatuses.add(StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)e));
                    failedTestResultUploads.add(uploadedItem.getQTestCase().getName());
                }
                monitor.worked(1);
            }
            if (errorStatuses.isEmpty()) break block17;
            StringBuilder errorMsgBuilder = new StringBuilder().append(StringConstants.JOB_TASK_UNABLE_TO_UPLOAD_TEST_RESULTS_REASON).append("\n").append(StringUtils.join(failedTestResultUploads, (char)'\n'));
            IStatus iStatus3 = StatusUtil.getMultiStatus(((Object)((Object)this)).getClass(), (IStatus[])((IStatus[])errorStatuses.toArray(new Status[errorStatuses.size()])), (String)errorMsgBuilder.toString(), null);
            ReportTestCaseLogPair uploadedPair = new ReportTestCaseLogPair(reportEntity, uploadedTestCaseLogs);
            this.fUploadedTestLogPairs.add(uploadedPair);
            monitor.done();
            EventBrokerSingleton.getInstance().getEventBroker().post("REPORT/UPDATED", (Object)new Object[]{reportEntity.getId(), reportEntity});
            return iStatus3;
        }
        try {
            iStatus = Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            IStatus iStatus4 = Status.CANCEL_STATUS;
            {
                catch (Throwable throwable) {
                    ReportTestCaseLogPair uploadedPair = new ReportTestCaseLogPair(reportEntity, uploadedTestCaseLogs);
                    this.fUploadedTestLogPairs.add(uploadedPair);
                    monitor.done();
                    EventBrokerSingleton.getInstance().getEventBroker().post("REPORT/UPDATED", (Object)new Object[]{reportEntity.getId(), reportEntity});
                    throw throwable;
                }
            }
            ReportTestCaseLogPair uploadedPair = new ReportTestCaseLogPair(reportEntity, uploadedTestCaseLogs);
            this.fUploadedTestLogPairs.add(uploadedPair);
            monitor.done();
            EventBrokerSingleton.getInstance().getEventBroker().post("REPORT/UPDATED", (Object)new Object[]{reportEntity.getId(), reportEntity});
            return iStatus4;
            catch (Exception ex) {
                monitor.setCanceled(true);
                LoggerSingleton.logError((Throwable)ex);
                IStatus iStatus5 = StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)ex);
                uploadedPair = new ReportTestCaseLogPair(reportEntity, uploadedTestCaseLogs);
                this.fUploadedTestLogPairs.add(uploadedPair);
                monitor.done();
                EventBrokerSingleton.getInstance().getEventBroker().post("REPORT/UPDATED", (Object)new Object[]{reportEntity.getId(), reportEntity});
                return iStatus5;
            }
        }
        ReportTestCaseLogPair uploadedPair = new ReportTestCaseLogPair(reportEntity, uploadedTestCaseLogs);
        this.fUploadedTestLogPairs.add(uploadedPair);
        monitor.done();
        EventBrokerSingleton.getInstance().getEventBroker().post("REPORT/UPDATED", (Object)new Object[]{reportEntity.getId(), reportEntity});
        return iStatus;
    }

    private QTestRun getQTestRun(QTestLogUploadedPreview uploadedPreviewItem, List<QTestRun> currentQTestRunsOnQTest) {
        for (QTestRun currentQTestRun : currentQTestRunsOnQTest) {
            if (uploadedPreviewItem.getQTestCase().getId() != currentQTestRun.getQTestCaseId()) continue;
            return currentQTestRun;
        }
        return null;
    }
}

