/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.preference;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.constant.ComposerIntegrationQtestMessageConstants;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.GenerateNewTokenDialog;
import com.kms.katalon.composer.integration.qtest.wizard.SetupWizardDialog;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.credential.QTestTokenManager;
import com.kms.katalon.integration.qtest.credential.impl.QTestCredentialImpl;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.setting.QTestAttachmentSendingType;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import com.kms.katalon.integration.qtest.setting.QTestVersion;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QTestPreferenceMainPage
extends PreferencePageWithHelp {
    @Named(value="activeShell")
    private Shell shell;
    @Inject
    private IEventBroker eventBroker;
    private Text txtToken;
    private Button chckAutoSubmitTestRun;
    private Button chckEnableIntegration;
    private Button chckSubmitTestRunToLatestVersion;
    private Button btnOpenGenerateTokenDialog;
    private Composite container;
    private Composite mainComposite;
    private Composite includeAttachmentComposite;
    private GridData gdTxtToken;
    private Group grpReportFormatOptions;
    private Link setupLink;
    private Combo cbbQTestVersion;
    private Button chckGenerateParityReport;
    private String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
    private QTestCredentialImpl fCredential;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container.setLayout((Layout)new GridLayout(1, false));
        Composite enablerComposite = new Composite(this.container, 0);
        enablerComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        enablerComposite.setLayout((Layout)new GridLayout(2, false));
        this.chckEnableIntegration = new Button(enablerComposite, 32);
        this.chckEnableIntegration.setText(StringConstants.DIA_TITLE_ENABLE_INTEGRATION);
        this.setupLink = new Link(enablerComposite, 0);
        this.setupLink.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.setupLink.setText(StringConstants.DIA_INFO_QUICK_SETUP);
        this.mainComposite = new Composite(this.container, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glMainComposite = new GridLayout(1, false);
        glMainComposite.marginWidth = 0;
        glMainComposite.marginHeight = 0;
        glMainComposite.verticalSpacing = 10;
        this.mainComposite.setLayout((Layout)glMainComposite);
        this.createAuthenticationGroup();
        this.createTestResultGroup();
        this.createParityReportGroup();
        this.addToolItemListeners();
        this.initialize();
        return this.container;
    }

    private void createTestResultGroup() {
        Group testResultGroup = new Group(this.mainComposite, 0);
        testResultGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        testResultGroup.setText(ComposerIntegrationQtestMessageConstants.CM_TEST_RESULT);
        GridLayout gdTestResult = new GridLayout(1, false);
        gdTestResult.verticalSpacing = 10;
        testResultGroup.setLayout((Layout)gdTestResult);
        this.chckSubmitTestRunToLatestVersion = new Button((Composite)testResultGroup, 32);
        this.chckSubmitTestRunToLatestVersion.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.chckSubmitTestRunToLatestVersion.setText(StringConstants.DIA_TITLE_SUBMIT_TEST_RESULT_TO_LATEST_VERSION);
        Composite submitTestRunComposite = new Composite((Composite)testResultGroup, 0);
        submitTestRunComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gdSubmitTestRun = new GridLayout(1, false);
        gdSubmitTestRun.marginHeight = 0;
        gdSubmitTestRun.marginWidth = 0;
        submitTestRunComposite.setLayout((Layout)gdSubmitTestRun);
        this.chckAutoSubmitTestRun = new Button(submitTestRunComposite, 32);
        this.chckAutoSubmitTestRun.setText(StringConstants.DIA_TITLE_AUTO_SUBMIT_TEST_RESULT);
        this.includeAttachmentComposite = new Composite(submitTestRunComposite, 0);
        this.includeAttachmentComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout attachmentLayout = new GridLayout(1, true);
        attachmentLayout.marginLeft = 10;
        attachmentLayout.marginRight = 0;
        attachmentLayout.marginHeight = 0;
        this.includeAttachmentComposite.setLayout((Layout)attachmentLayout);
        QTestAttachmentSendingType[] qTestAttachmentSendingTypeArray = QTestAttachmentSendingType.values();
        int n = qTestAttachmentSendingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            QTestAttachmentSendingType sendingType = qTestAttachmentSendingTypeArray[n2];
            Button btnSendingType = new Button(this.includeAttachmentComposite, 32);
            btnSendingType.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            switch (sendingType) {
                case SEND_IF_FAILS: {
                    btnSendingType.setText(ComposerIntegrationQtestMessageConstants.DIA_LABEL_INCLUDE_ATTACH_IF_FAILS);
                    break;
                }
                case SEND_IF_PASSES: {
                    btnSendingType.setText(ComposerIntegrationQtestMessageConstants.DIA_LABEL_INCLUDE_ATTACH_IF_PASSES);
                    break;
                }
            }
            btnSendingType.setData((Object)sendingType);
            ++n2;
        }
        this.grpReportFormatOptions = new Group(this.mainComposite, 0);
        this.grpReportFormatOptions.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.grpReportFormatOptions.setText(StringConstants.DIA_TITLE_REPORT_FORMAT);
        GridLayout attachmentOptionsLayout = new GridLayout(1, true);
        attachmentOptionsLayout.marginLeft = 0;
        attachmentOptionsLayout.marginRight = 0;
        attachmentOptionsLayout.marginHeight = 5;
        this.grpReportFormatOptions.setLayout((Layout)attachmentOptionsLayout);
        ReportFormatType[] reportFormatTypeArray = ReportFormatType.values();
        int n3 = reportFormatTypeArray.length;
        n = 0;
        while (n < n3) {
            ReportFormatType formatType = reportFormatTypeArray[n];
            Button btnFormmatingType = new Button((Composite)this.grpReportFormatOptions, 32);
            btnFormmatingType.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            btnFormmatingType.setText(formatType.toString());
            btnFormmatingType.setData((Object)formatType);
            ++n;
        }
    }

    private void createParityReportGroup() {
        Group grpParityReport = new Group(this.mainComposite, 0);
        grpParityReport.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpParityReport.setText(ComposerIntegrationQtestMessageConstants.QTestPreferenceMainPage_GRP_PARITY_REPORT);
        GridLayout parityReportLayout = new GridLayout(2, true);
        parityReportLayout.marginLeft = 0;
        parityReportLayout.marginRight = 0;
        parityReportLayout.marginHeight = 5;
        grpParityReport.setLayout((Layout)parityReportLayout);
        this.chckGenerateParityReport = new Button((Composite)grpParityReport, 32);
        this.chckGenerateParityReport.setText(ComposerIntegrationQtestMessageConstants.QTestPreferenceMainPage_CHCK_GENERATE_PARITY_REPORT);
        Label lblHelp = new Label((Composite)grpParityReport, 0);
        lblHelp.setImage(ImageManager.getImage((String)"help_16.png"));
        lblHelp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                try {
                    Program.launch((String)"https://docs.katalon.com/katalon-studio/docs/qtest-integration.html#enable-qtest-integration");
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openWarning((Shell)QTestPreferenceMainPage.this.getShell(), (String)StringConstants.ERROR, (String)ex.getMessage());
                }
            }
        });
    }

    private void createAuthenticationGroup() {
        Group grpAuthentication = new Group(this.mainComposite, 0);
        grpAuthentication.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpAuthentication.setLayout((Layout)new GridLayout(4, false));
        grpAuthentication.setText(StringConstants.CM_AUTHENTICATION);
        Composite versioningComposite = new Composite((Composite)grpAuthentication, 0);
        versioningComposite.setLayoutData((Object)new GridData(4, 4, false, false, 4, 1));
        GridLayout glVersioningComposite = new GridLayout(2, false);
        glVersioningComposite.marginHeight = 0;
        glVersioningComposite.marginWidth = 0;
        versioningComposite.setLayout((Layout)glVersioningComposite);
        Label lblQTestVersion = new Label(versioningComposite, 0);
        GridData gd_lblQTestVersion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblQTestVersion.widthHint = 100;
        lblQTestVersion.setLayoutData((Object)gd_lblQTestVersion);
        lblQTestVersion.setText(StringConstants.DIA_TITLE_VERSION);
        this.cbbQTestVersion = new Combo(versioningComposite, 0x800008);
        this.cbbQTestVersion.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.cbbQTestVersion.setItems(QTestVersion.valuesAsStrings());
        Label lblToken = new Label((Composite)grpAuthentication, 0);
        GridData gdLblToken = new GridData(16384, 128, false, false, 1, 1);
        gdLblToken.widthHint = 100;
        gdLblToken.verticalIndent = 5;
        lblToken.setLayoutData((Object)gdLblToken);
        lblToken.setText(StringConstants.CM_TOKEN);
        this.txtToken = new Text((Composite)grpAuthentication, 2626);
        this.gdTxtToken = new GridData(4, 4, true, false, 2, 1);
        this.gdTxtToken.heightHint = 60;
        this.txtToken.setLayoutData((Object)this.gdTxtToken);
        this.btnOpenGenerateTokenDialog = new Button((Composite)grpAuthentication, 0);
        this.btnOpenGenerateTokenDialog.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnOpenGenerateTokenDialog.setText(StringConstants.DIA_TITLE_GENERATE);
    }

    private void addToolItemListeners() {
        this.btnOpenGenerateTokenDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateNewTokenDialog dialog = new GenerateNewTokenDialog(QTestPreferenceMainPage.this.btnOpenGenerateTokenDialog.getDisplay().getActiveShell(), (IQTestCredential)QTestPreferenceMainPage.this.fCredential);
                if (dialog.open() == 0) {
                    QTestPreferenceMainPage.this.fCredential = QTestPreferenceMainPage.this.getNewCredential(dialog.getNewCredential());
                    QTestPreferenceMainPage.this.txtToken.setText(QTestPreferenceMainPage.this.fCredential.getToken().getRawToken());
                    MessageDialog.openInformation((Shell)QTestPreferenceMainPage.this.shell, (String)StringConstants.INFO, (String)StringConstants.DIA_MSG_GENERATE_TOKEN_SUCESSFULLY);
                }
            }
        });
        this.chckEnableIntegration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestPreferenceMainPage.this.enableMainComposite();
                if (!QTestPreferenceMainPage.this.chckEnableIntegration.getSelection()) {
                    return;
                }
                IntegratedEntity qTestProjectIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)ProjectController.getInstance().getCurrentProject());
                if (QTestSettingStore.isTheFirstTime((String)QTestPreferenceMainPage.this.projectDir) && qTestProjectIntegratedEntity == null) {
                    QTestSettingStore.usedSetupWizard((String)QTestPreferenceMainPage.this.projectDir);
                    if (!MessageDialog.openQuestion(null, (String)StringConstants.INFO, (String)StringConstants.DIA_TITLE_ASK_USE_SETUP)) {
                        return;
                    }
                    QTestPreferenceMainPage.this.performWizardSetup();
                }
            }
        });
        this.txtToken.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                QTestPreferenceMainPage.this.gdTxtToken.widthHint = Math.max(300, QTestPreferenceMainPage.this.txtToken.getSize().x);
                QTestPreferenceMainPage.this.container.setSize(QTestPreferenceMainPage.this.container.getParent().getSize().x, QTestPreferenceMainPage.this.container.getSize().y);
                QTestPreferenceMainPage.this.container.layout(true, true);
            }
        });
        this.chckAutoSubmitTestRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestPreferenceMainPage.this.enableAttachmentsGroup();
            }
        });
        this.setupLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestPreferenceMainPage.this.performWizardSetup();
            }
        });
        this.cbbQTestVersion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestPreferenceMainPage.this.fCredential.setVersion(QTestVersion.valueOf((int)QTestPreferenceMainPage.this.cbbQTestVersion.getSelectionIndex()));
            }
        });
        this.txtToken.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    QTestPreferenceMainPage.this.fCredential.setToken(QTestTokenManager.getToken((String)QTestPreferenceMainPage.this.txtToken.getText()));
                }
                catch (QTestInvalidFormatException qTestInvalidFormatException) {}
            }
        });
    }

    private void performWizardSetup() {
        SetupWizardDialog wizard = new SetupWizardDialog(this.getShell());
        if (wizard.open() == 0) {
            this.eventBroker.post("QTEST/SETUP_FINISHED", null);
            this.initialize();
        }
    }

    private void enableAttachmentsGroup() {
        ControlUtils.recursiveSetEnabled((Control)this.includeAttachmentComposite, (this.chckEnableIntegration.getSelection() && this.chckAutoSubmitTestRun.getSelection() ? 1 : 0) != 0);
    }

    private void enableMainComposite() {
        ControlUtils.recursiveSetEnabled((Control)this.mainComposite, (boolean)this.chckEnableIntegration.getSelection());
    }

    private void initialize() {
        boolean autoSubmitResult = QTestSettingStore.isAutoSubmitResultActive((String)this.projectDir);
        boolean isIntegrationActive = QTestSettingStore.isIntegrationActive((String)this.projectDir);
        boolean submitResultToLatestVersion = QTestSettingStore.isSubmitResultToLatestVersionActive((String)this.projectDir);
        this.chckAutoSubmitTestRun.setSelection(autoSubmitResult);
        this.chckEnableIntegration.setSelection(isIntegrationActive);
        this.chckSubmitTestRunToLatestVersion.setSelection(submitResultToLatestVersion);
        this.fCredential = this.getNewCredential((IQTestCredential)QTestSettingCredential.getCredential((String)this.projectDir));
        QTestVersion version = QTestVersion.getLastest();
        String token = "";
        if (this.fCredential != null) {
            if (this.fCredential.getToken() != null) {
                token = this.fCredential.getToken().getRawToken();
            }
            version = this.fCredential.getVersion();
        }
        this.txtToken.setText(token != null ? token : "");
        this.cbbQTestVersion.select(version.ordinal());
        List selectedAttachmentSendingTypes = QTestSettingStore.getAttachmentSendingTypes((String)this.projectDir);
        Control[] controlArray = this.includeAttachmentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control chckButton = controlArray[n2];
            if (chckButton instanceof Button) {
                if (selectedAttachmentSendingTypes.contains(chckButton.getData())) {
                    ((Button)chckButton).setSelection(true);
                } else {
                    ((Button)chckButton).setSelection(false);
                }
            }
            ++n2;
        }
        List selectedFormattedReportTypes = QTestSettingStore.getFormatReportTypes((String)this.projectDir);
        Control[] controlArray2 = this.grpReportFormatOptions.getChildren();
        int n3 = controlArray2.length;
        n = 0;
        while (n < n3) {
            Control chckButton = controlArray2[n];
            if (chckButton instanceof Button) {
                if (selectedFormattedReportTypes.contains(chckButton.getData())) {
                    ((Button)chckButton).setSelection(true);
                } else {
                    ((Button)chckButton).setSelection(false);
                }
            }
            ++n;
        }
        this.chckGenerateParityReport.setSelection(QTestSettingStore.isGenerateParityReportEnabled((String)this.projectDir));
        this.enableMainComposite();
        this.enableAttachmentsGroup();
        this.container.pack();
    }

    public boolean performOk() {
        if (this.container == null) {
            return true;
        }
        try {
            QTestSettingStore.saveEnableIntegration((boolean)this.chckEnableIntegration.getSelection(), (String)this.projectDir);
            QTestSettingStore.saveUserProfile((IQTestCredential)this.fCredential, (String)this.projectDir);
            QTestSettingStore.saveAutoSubmit((boolean)this.chckAutoSubmitTestRun.getSelection(), (String)this.projectDir);
            QTestSettingStore.saveSubmitToLatestVersion((boolean)this.chckSubmitTestRunToLatestVersion.getSelection(), (String)this.projectDir);
            QTestSettingStore.saveEnableParityReport((boolean)this.chckGenerateParityReport.getSelection(), (String)this.projectDir);
            this.saveAttachmentSendingStatus();
            this.saveFormatOptions();
            this.eventBroker.post("EXPLORER/REFRESH", null);
            return true;
        }
        catch (IOException | GeneralSecurityException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR, (String)StringConstants.DIA_MSG_UNABLE_TO_SAVE_SETTING_PAGE);
            return false;
        }
    }

    private QTestCredentialImpl getNewCredential(IQTestCredential credential) {
        QTestCredentialImpl newCredential = new QTestCredentialImpl();
        if (credential != null) {
            newCredential.setServerUrl(credential.getServerUrl()).setUsername(credential.getUsername()).setPassword(credential.getPassword()).setToken(credential.getToken()).setVersion(credential.getVersion()).setPasswordEncryptionEnabled(credential.isEncryptionEnabled());
        }
        return newCredential;
    }

    private void saveAttachmentSendingStatus() {
        ArrayList<QTestAttachmentSendingType> selectedAttachmentSendingType = new ArrayList<QTestAttachmentSendingType>();
        Control[] controlArray = this.includeAttachmentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button sendingTypeRadioButton;
            Control radioButtonControl = controlArray[n2];
            if (radioButtonControl instanceof Button && (sendingTypeRadioButton = (Button)radioButtonControl).getSelection()) {
                QTestAttachmentSendingType attachmentSendingType = (QTestAttachmentSendingType)sendingTypeRadioButton.getData();
                selectedAttachmentSendingType.add(attachmentSendingType);
            }
            ++n2;
        }
        QTestSettingStore.saveAttachmentSendingType(selectedAttachmentSendingType, (String)this.projectDir);
    }

    private void saveFormatOptions() {
        ArrayList<ReportFormatType> selectedFormat = new ArrayList<ReportFormatType>();
        Control[] controlArray = this.grpReportFormatOptions.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button formateTypeRadioButton;
            Control radioButtonControl = controlArray[n2];
            if (radioButtonControl instanceof Button && (formateTypeRadioButton = (Button)radioButtonControl).getSelection()) {
                ReportFormatType resultSendingType = (ReportFormatType)formateTypeRadioButton.getData();
                selectedFormat.add(resultSendingType);
            }
            ++n2;
        }
        QTestSettingStore.saveFormatReportTypes(selectedFormat, (String)this.projectDir);
    }

    protected void performDefaults() {
        this.initialize();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_QTEST;
    }
}

