/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.view.testcase;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.qtest.constant.ComposerIntegrationQtestMessageConstants;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.handler.QTestCheckForTestCaseUpdatesHandler;
import com.kms.katalon.composer.integration.qtest.handler.QTestUploadTestCaseHandler;
import com.kms.katalon.composer.integration.qtest.job.UploadTestCaseJob;
import com.kms.katalon.composer.testcase.parts.integration.AbstractTestCaseIntegrationView;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationFolderManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestCaseManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.QTestSyncStatusUtil;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestModule;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.model.TestCaseRepo;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.qas.api.AuthServiceException;
import org.qas.api.internal.util.google.base.Preconditions;

public class QTestIntegrationTestCaseView
extends AbstractTestCaseIntegrationView
implements EventHandler {
    private StyledText txtID;
    private StyledText txtParentID;
    private StyledText txtAlias;
    private StyledText txtVersion;
    private QTestTestCase qTestTestCase;
    private Button btnUpload;
    private Button btnDisintegrate;
    private Button btnNavigate;
    private Button btnUpdate;
    private Button btnLinkTestCase;
    private Composite container;

    public QTestIntegrationTestCaseView(TestCaseEntity testCaseEntity, MPart mpart) {
        super(testCaseEntity, mpart);
    }

    public Composite createContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(1, false);
        glContainer.marginWidth = 0;
        glContainer.marginHeight = 0;
        this.container.setLayout((Layout)glContainer);
        Composite compositeButton = new Composite(this.container, 0);
        GridLayout gl_compositeButton = new GridLayout(5, false);
        gl_compositeButton.marginWidth = 0;
        compositeButton.setLayout((Layout)gl_compositeButton);
        compositeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.btnUpload = new Button(compositeButton, 0x800000);
        this.btnUpload.setToolTipText(StringConstants.VIEW_TOOLTIP_UPLOAD_TEST_CASE);
        this.btnUpload.setText(StringConstants.CM_UPLOAD);
        this.btnDisintegrate = new Button(compositeButton, 0x800000);
        this.btnDisintegrate.setToolTipText(StringConstants.VIEW_TOOLTIP_DISINTEGRATE_TEST_CASE);
        this.btnDisintegrate.setText(StringConstants.CM_DISINTEGRATE);
        this.btnNavigate = new Button(compositeButton, 0x800000);
        this.btnNavigate.setToolTipText(StringConstants.VIEW_TOOLTIP_NAVIGATE_TEST_CASE);
        this.btnNavigate.setText(StringConstants.CM_NAVIGATE);
        this.btnUpdate = new Button(compositeButton, 0x800000);
        this.btnUpdate.setToolTipText(StringConstants.VIEW_TOOLTIP_UDPATE);
        this.btnUpdate.setText(StringConstants.CM_UPDATE);
        this.btnLinkTestCase = new Button(compositeButton, 0x800000);
        this.btnLinkTestCase.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.btnLinkTestCase.setToolTipText(ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_LBL_TOOLTIP_LINK_TEST_CASE);
        this.btnLinkTestCase.setText(ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_LBL_LINK_TEST_CASE);
        Composite compositeInfo = new Composite(this.container, 2048);
        compositeInfo.setBackground(ColorUtil.getWhiteBackgroundColor());
        compositeInfo.setBackgroundMode(2);
        compositeInfo.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridLayout gl_compositeInfo = new GridLayout(2, false);
        gl_compositeInfo.verticalSpacing = 7;
        gl_compositeInfo.horizontalSpacing = 15;
        compositeInfo.setLayout((Layout)gl_compositeInfo);
        Label lblTestCaseId = new Label(compositeInfo, 0);
        lblTestCaseId.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblTestCaseId.setText(StringConstants.VIEW_TITLE_TEST_CASE_ID);
        this.txtID = new StyledText(compositeInfo, 8);
        this.txtID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPID = new Label(compositeInfo, 0);
        lblPID.setText(StringConstants.CM_ALIAS);
        this.txtAlias = new StyledText(compositeInfo, 8);
        this.txtAlias.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblParentId = new Label(compositeInfo, 0);
        lblParentId.setText(StringConstants.CM_PARENT_ID);
        this.txtParentID = new StyledText(compositeInfo, 8);
        this.txtParentID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblVersion = new Label(compositeInfo, 0);
        lblVersion.setText(ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_TXT_VERSION);
        this.txtVersion = new StyledText(compositeInfo, 8);
        this.txtVersion.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.initialize();
        this.controlModifyListeners();
        this.getEventBroker().subscribe("TESTCASE/UPDATED", (EventHandler)this);
        return this.container;
    }

    private void controlModifyListeners() {
        this.btnUpload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestIntegrationTestCaseView.this.performUploadTestCase();
            }
        });
        this.btnNavigate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestIntegrationTestCaseView.this.navigateToQTestTestCase();
            }
        });
        this.btnDisintegrate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestIntegrationTestCaseView.this.disIntegrateTestCaseWithQTest();
            }
        });
        this.btnUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestCheckForTestCaseUpdatesHandler.execute(QTestIntegrationTestCaseView.this.testCaseEntity);
            }
        });
        this.btnLinkTestCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    QTestIntegrationTestCaseView.this.performLinkTestCase();
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_MSG_UNABLE_TO_LINK_TEST_CASE, (String)ex.getClass().getSimpleName());
                }
            }
        });
    }

    protected void disIntegrateTestCaseWithQTest() {
        try {
            if (MessageDialog.openConfirm(null, (String)StringConstants.CONFIRMATION, (String)StringConstants.VIEW_CONFIRM_DISINTEGRATE_TEST_CASE)) {
                this.testCaseEntity.getIntegratedEntities().remove(QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)this.testCaseEntity));
                this.reloadView();
                this.setDirty(true);
            }
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.VIEW_MSG_UNABLE_DISINTEGRATE_TEST_CASE, (String)e.getClass().getSimpleName());
        }
    }

    private void navigateToQTestTestCase() {
        try {
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            QTestProject qTestProject = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)this.testCaseEntity, (ProjectEntity)projectEntity).getQTestProject();
            URL url = QTestIntegrationTestCaseManager.navigatedUrlToQTestTestCase((QTestProject)qTestProject, (QTestTestCase)this.qTestTestCase, (String)projectEntity.getFolderLocation());
            Program.launch((String)url.toString());
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.VIEW_MSG_UNABLE_NAVIGATE_TEST_CASE, (String)e.getClass().getSimpleName());
        }
    }

    private void performUploadTestCase() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (this.isDirty()) {
            MessageDialog.openInformation(null, (String)StringConstants.INFORMATION, (String)StringConstants.VIEW_MSG_SAVE_BEFORE_UPLOADING);
            return;
        }
        try {
            TestCaseRepo testCaseRepo = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)this.testCaseEntity, (ProjectEntity)projectEntity);
            if (testCaseRepo == null) {
                MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)StringConstants.VIEW_MSG_TEST_CASE_NOT_IN_REPO);
                return;
            }
            QTestModule module = QTestIntegrationFolderManager.getQTestModuleByFolderEntity((FolderEntity)this.testCaseEntity.getParentFolder());
            if (module != null && module.getParentId() <= 0L) {
                MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)StringConstants.VIEW_MSG_UNABLE_UPLOAD_TEST_CASE_UNDER_ROOT_MODULE);
                return;
            }
            UploadTestCaseJob uploadJob = new UploadTestCaseJob(StringConstants.JOB_TITLE_UPLOAD_TEST_CASE, UISynchronizeService.getInstance().getSync());
            ArrayList<IntegratedFileEntity> uploadedEntities = new ArrayList<IntegratedFileEntity>();
            TestCaseEntity originalEntity = TestCaseController.getInstance().getTestCase(this.testCaseEntity.getId());
            uploadedEntities.add((IntegratedFileEntity)originalEntity);
            QTestUploadTestCaseHandler.addParentToUploadedEntities((IntegratedFileEntity)originalEntity, uploadedEntities);
            uploadJob.setFileEntities(uploadedEntities);
            uploadJob.doTask();
        }
        catch (Exception ex) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)StringConstants.VIEW_MSG_UNABLE_UPLOAD_TEST_CASE, (String)ex.getClass().getSimpleName());
        }
    }

    protected void performLinkTestCase() throws InvocationTargetException, InterruptedException {
        if (this.isDirty()) {
            MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_MSG_WARN_TEST_CASE_NOT_SAVED);
            return;
        }
        ProgressMonitorDialog progress = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        progress.run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_MSG_PERFORMING_LINK_TEST_CASE_ACTION, -1);
                try {
                    ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
                    TestCaseRepo testCaseRepo = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)QTestIntegrationTestCaseView.this.testCaseEntity, (ProjectEntity)projectEntity);
                    Preconditions.checkNotNull((Object)testCaseRepo);
                    QTestModule qTestParentModule = QTestIntegrationFolderManager.getQTestModuleByFolderEntity((FolderEntity)QTestIntegrationTestCaseView.this.testCaseEntity.getParentFolder());
                    Preconditions.checkNotNull((Object)qTestParentModule);
                    if (qTestParentModule.getId() <= 0L) {
                        QTestIntegrationTestCaseView.this.uiSyncExec(() -> MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_MSG_WARN_NOT_LINK_TEST_CASE_UNDER_ROOT));
                        return;
                    }
                    Long testCaseId = QTestIntegrationTestCaseView.this.retrieveQTestIdFromTestCaseName(QTestIntegrationTestCaseView.this.testCaseEntity);
                    if (testCaseId == null) {
                        QTestIntegrationTestCaseView.this.uiSyncExec(() -> MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_MSG_WARN_INVALID_ID_FROM_TEST_CASE_NAME));
                        return;
                    }
                    QTestSettingCredential credential = QTestSettingCredential.getCredential((String)projectEntity.getFolderLocation());
                    QTestTestCase qTestTestCase = QTestIntegrationTestCaseManager.getTestCaseFromQTest((IQTestCredential)credential, (long)testCaseRepo.getQTestProject().getId(), (long)testCaseId, null);
                    if (qTestTestCase.getParentId() != qTestParentModule.getId()) {
                        QTestIntegrationTestCaseView.this.uiSyncExec(() -> MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)MessageFormat.format(ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_MSG_WARN_TEST_CASE_NOT_FOUND_UNDER_MODULE, testCaseId.toString(), qTestParentModule.getName())));
                        return;
                    }
                    try {
                        QTestIntegrationTestCaseView.this.testCaseEntity.setDescription(QTestIntegrationUtil.getHtmlInnerText((String)qTestTestCase.getDescription()));
                        QTestIntegrationTestCaseView.this.testCaseEntity.setComment(QTestIntegrationUtil.getListTestStepDescription((QTestTestCase)qTestTestCase));
                        QTestIntegrationTestCaseView.this.testCaseEntity.getIntegratedEntities().add(QTestIntegrationTestCaseManager.getIntegratedEntityByQTestTestCase((QTestTestCase)qTestTestCase));
                        QTestIntegrationTestCaseView.this.uiSyncExec(() -> QTestIntegrationTestCaseView.this.reloadView());
                        QTestIntegrationTestCaseView.this.getEventBroker().send("PROPERTIES/ENTITY_UPDATED", (Object)QTestIntegrationTestCaseView.this.testCaseEntity);
                        QTestIntegrationTestCaseView.this.uiSyncExec(() -> QTestIntegrationTestCaseView.this.setDirty(true));
                    }
                    catch (AuthServiceException ex) {
                        QTestIntegrationTestCaseView.this.uiSyncExec(() -> MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_MSG_UNABLE_TO_LINK_TEST_CASE, (String)ex.getMessage()));
                    }
                    catch (Exception ex) {
                        QTestIntegrationTestCaseView.this.uiSyncExec(() -> MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerIntegrationQtestMessageConstants.QTestIntegrationTestCaseView_MSG_UNABLE_TO_LINK_TEST_CASE, (String)ex.getClass().getSimpleName()));
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private void uiSyncExec(Runnable runnable) {
        UISynchronizeService.getInstance().getSync().syncExec(runnable);
    }

    private Long retrieveQTestIdFromTestCaseName(TestCaseEntity testCase) {
        String name = testCase.getName();
        String[] parts = StringUtils.split((String)name, (String)" ");
        if (parts != null && parts.length > 0) {
            try {
                return Long.valueOf(parts[0]);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private void initialize() {
        if (this.testCaseEntity == null) {
            this.btnUpload.setEnabled(false);
            this.btnDisintegrate.setEnabled(false);
            this.btnNavigate.setEnabled(false);
            return;
        }
        this.reloadView();
    }

    private void reloadView() {
        if (this.container.isDisposed()) {
            return;
        }
        IntegratedEntity integratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)this.testCaseEntity);
        this.qTestTestCase = QTestIntegrationTestCaseManager.getQTestTestCaseByIntegratedEntity((IntegratedEntity)integratedEntity);
        if (this.qTestTestCase == null) {
            boolean isParentFolderIntegrated;
            this.btnUpload.setEnabled(true);
            this.btnDisintegrate.setEnabled(false);
            this.btnNavigate.setEnabled(false);
            this.btnUpdate.setEnabled(false);
            try {
                isParentFolderIntegrated = QTestIntegrationUtil.isIntegrated((IntegratedFileEntity)this.testCaseEntity.getParentFolder(), (ProjectEntity)this.testCaseEntity.getProject());
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                isParentFolderIntegrated = false;
            }
            if (isParentFolderIntegrated) {
                this.btnLinkTestCase.setEnabled(true);
            } else {
                this.btnLinkTestCase.setEnabled(false);
            }
        } else {
            this.btnUpload.setEnabled(false);
            this.btnDisintegrate.setEnabled(true);
            this.btnNavigate.setEnabled(true);
            this.btnLinkTestCase.setEnabled(false);
            this.btnUpdate.setEnabled(true);
        }
        if (this.qTestTestCase != null) {
            this.txtID.setText(String.valueOf(this.qTestTestCase.getId()));
            this.txtParentID.setText(String.valueOf(this.qTestTestCase.getParentId()));
            this.txtAlias.setText(this.qTestTestCase.getPid());
            String version = this.qTestTestCase.getVersion();
            this.txtVersion.setText(StringUtils.defaultIfBlank((String)version, (String)""));
        } else {
            this.txtID.setText("");
            this.txtParentID.setText("");
            this.txtAlias.setText("");
            this.txtVersion.setText("");
        }
    }

    private IEventBroker getEventBroker() {
        return EventBrokerSingleton.getInstance().getEventBroker();
    }

    public void handleEvent(Event event) {
        String testCaseId;
        if (event.getTopic().equals("TESTCASE/UPDATED") && StringUtils.isNotBlank((String)(testCaseId = (String)((Object[])EventUtil.getData((Event)event))[0])) && testCaseId.equals(this.testCaseEntity.getId())) {
            this.reloadView();
        }
    }

    public TestCaseEntity getTestCase() {
        return this.testCaseEntity;
    }

    public void setTestCase(TestCaseEntity testCase) {
        this.testCaseEntity = testCase;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.TEST_CASE_INTEGRATION_QTEST;
    }

    public void onSaveSuccess(TestCaseEntity testCase) {
        super.onSaveSuccess(testCase);
        try {
            QTestSyncStatusUtil.recursivelyUnmarkAllStatusesIfNoChildWithSameStatus((FolderEntity)testCase.getParentFolder(), (ProjectEntity)testCase.getProject());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

