/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.wizard.page;

import com.kms.katalon.composer.components.impl.control.GifCLabel;
import com.kms.katalon.composer.components.impl.wizard.AbstractWizardPage;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.qtest.constant.ComposerIntegrationQtestMessageConstants;
import com.kms.katalon.composer.integration.qtest.constant.ImageConstants;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.wizard.page.QTestWizardPage;
import com.kms.katalon.integration.qtest.QTestIntegrationAuthenticationManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.credential.IQTestToken;
import com.kms.katalon.integration.qtest.credential.impl.QTestCredentialImpl;
import com.kms.katalon.integration.qtest.exception.QTestAPIConnectionException;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.setting.QTestVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AuthenticationWizardPage
extends AbstractWizardPage
implements QTestWizardPage {
    private IQTestToken fToken;
    private String fServerUrl = "https://";
    private String fUsername = "";
    private String fPwd = "";
    private boolean fEncryptionEnabled = false;
    private QTestVersion fVersion;
    private boolean isDirty = false;
    private boolean isPasswordShowed = false;
    private String lblStatusText = "";
    private Text txtServerURL;
    private Text txtUsername;
    private Text txtPassword;
    private Button btnShowPassword;
    private Label lblConnectedStatus;
    private Button btnConnect;
    private GifCLabel connectingLabel;
    private Composite connectingComposite;
    private Label lblConnecting;
    private InputStream inputStream;
    private Composite headerComposite;
    private Label lblHeader;
    private Composite stepAreaComposite;
    private Label lblVersion;
    private Combo cbbQTestVersion;
    private Button chckEncryptAuthentication;
    private ModifyListener modifyTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AuthenticationWizardPage.this.isDirty = true;
            if (!AuthenticationWizardPage.this.btnConnect.getEnabled()) {
                AuthenticationWizardPage.this.btnConnect.setEnabled(true);
            }
            AuthenticationWizardPage.this.lblConnectedStatus.setText("");
            AuthenticationWizardPage.this.firePageChanged();
        }
    };

    public AuthenticationWizardPage() {
        this.fVersion = QTestVersion.getLastest();
    }

    public String getTitle() {
        return StringConstants.WZ_P_AUTHENTICATION_TITLE;
    }

    public void createStepArea(Composite parent) {
        this.stepAreaComposite = new Composite(parent, 0);
        this.stepAreaComposite.setLayout((Layout)new GridLayout(1, false));
        this.headerComposite = new Composite(this.stepAreaComposite, 0);
        this.headerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.headerComposite.setLayout((Layout)new GridLayout(1, false));
        this.lblHeader = new Label(this.headerComposite, 64);
        this.lblHeader.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblHeader.setText(StringConstants.WZ_P_AUTHENTICATION_INFO);
        Composite authenticationComposite = new Composite(this.stepAreaComposite, 0);
        GridLayout glAuthenticationComposite = new GridLayout(3, false);
        glAuthenticationComposite.horizontalSpacing = 15;
        authenticationComposite.setLayout((Layout)glAuthenticationComposite);
        authenticationComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lblVersion = new Label(authenticationComposite, 0);
        this.lblVersion.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblVersion.setText(StringConstants.DIA_TITLE_VERSION);
        this.cbbQTestVersion = new Combo(authenticationComposite, 8);
        this.cbbQTestVersion.setItems(QTestVersion.valuesAsStrings());
        new Label(authenticationComposite, 0);
        Label lblServerURL = new Label(authenticationComposite, 0);
        lblServerURL.setText(StringConstants.CM_SERVER_URL);
        this.txtServerURL = new Text(authenticationComposite, 2048);
        this.txtServerURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(authenticationComposite, 0);
        Label lblUsername = new Label(authenticationComposite, 0);
        lblUsername.setText(StringConstants.CM_USERNAME);
        this.txtUsername = new Text(authenticationComposite, 2048);
        this.txtUsername.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(authenticationComposite, 0);
        Label lblPassword = new Label(authenticationComposite, 0);
        lblPassword.setText(StringConstants.CM_PASSWORD);
        Composite passwordComposite = new Composite(authenticationComposite, 0);
        passwordComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glPassword = new GridLayout(2, false);
        glPassword.marginWidth = 0;
        glPassword.marginHeight = 0;
        passwordComposite.setLayout((Layout)glPassword);
        this.txtPassword = new Text(passwordComposite, 2048);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnShowPassword = new Button(passwordComposite, 32);
        this.btnShowPassword.setText(StringConstants.WZ_P_AUTHENTICATION_SHOW_PASSWORD);
        this.chckEncryptAuthentication = new Button(authenticationComposite, 32);
        this.chckEncryptAuthentication.setLayoutData((Object)new GridData(16384, 128, true, false, 2, 1));
        this.chckEncryptAuthentication.setText(ComposerIntegrationQtestMessageConstants.WZ_P_AUTHENTICATION_ENCRYPT_AUTHENTICATION_DATA);
        Composite connectionComposite = new Composite(authenticationComposite, 0);
        GridLayout glConectionComposite = new GridLayout(2, false);
        glConectionComposite.marginWidth = 0;
        connectionComposite.setLayout((Layout)glConectionComposite);
        connectionComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.btnConnect = new Button(connectionComposite, 0x800000);
        this.btnConnect.setText(StringConstants.WZ_P_AUTHENTICATION_CONNECT_ACCOUNT);
        this.connectingComposite = new Composite(connectionComposite, 0);
        this.connectingComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.connectingComposite.setLayout((Layout)new GridLayout(2, false));
        this.connectingLabel = new GifCLabel(this.connectingComposite, 0x20000000);
        this.connectingLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblConnecting = new Label(this.connectingComposite, 0);
        this.lblConnecting.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblConnecting.setText(StringConstants.CM_CONNECTING);
        this.lblConnectedStatus = new Label(connectionComposite, 64);
        this.lblConnectedStatus.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        FontData[] fD = this.lblConnectedStatus.getFont().getFontData();
        fD[0].setHeight(10);
        this.lblConnectedStatus.setFont(new Font((Device)Display.getCurrent(), fD));
    }

    public void setInput(Map<String, Object> sharedData) {
        this.txtServerURL.setText(this.fServerUrl);
        this.txtUsername.setText(this.fUsername);
        this.txtPassword.setText(this.fPwd);
        this.chckEncryptAuthentication.setSelection(this.fEncryptionEnabled);
        this.cbbQTestVersion.select(this.fVersion.ordinal());
        this.setConnectedStatus(this.lblStatusText, this.canFlipToNextPage());
        this.btnConnect.setEnabled(!this.canFlipToNextPage());
        this.btnShowPassword.setSelection(this.isPasswordShowed);
        this.maskPasswordField();
        this.setConnectingCompositeVisible(false);
    }

    public void registerControlModifyListeners() {
        this.btnShowPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationWizardPage.this.maskPasswordField();
            }
        });
        this.txtServerURL.addModifyListener(this.modifyTextListener);
        this.txtUsername.addModifyListener(this.modifyTextListener);
        this.txtPassword.addModifyListener(this.modifyTextListener);
        this.cbbQTestVersion.addModifyListener(this.modifyTextListener);
        this.chckEncryptAuthentication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationWizardPage.this.fEncryptionEnabled = AuthenticationWizardPage.this.chckEncryptAuthentication.getSelection();
            }
        });
        this.stepAreaComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IOUtils.closeQuietly((InputStream)AuthenticationWizardPage.this.inputStream);
            }
        });
        this.btnConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringBuilder message = new StringBuilder();
                if (AuthenticationWizardPage.this.txtServerURL.getText().isEmpty()) {
                    message.append(StringConstants.DIA_MSG_ENTER_SERVER_URL);
                }
                if (AuthenticationWizardPage.this.txtUsername.getText().isEmpty()) {
                    if (message.length() > 0) {
                        message.append("\n");
                    }
                    message.append(StringConstants.DIA_MSG_ENTER_USERNAME);
                }
                if (AuthenticationWizardPage.this.txtPassword.getText().isEmpty()) {
                    if (message.length() > 0) {
                        message.append("\n");
                    }
                    message.append(StringConstants.DIA_MSG_ENTER_PASSWORD);
                }
                if (!message.toString().isEmpty()) {
                    MessageDialog.openInformation(null, (String)StringConstants.INFO, (String)message.toString());
                    return;
                }
                AuthenticationWizardPage.this.isDirty = true;
                AuthenticationWizardPage.this.lblConnectedStatus.setText("");
                final String newServerUrl = AuthenticationWizardPage.this.txtServerURL.getText();
                final String newUsername = AuthenticationWizardPage.this.txtUsername.getText();
                final String newPassword = AuthenticationWizardPage.this.txtPassword.getText();
                final QTestVersion newVersion = QTestVersion.valueOf((int)AuthenticationWizardPage.this.cbbQTestVersion.getSelectionIndex());
                AuthenticationWizardPage.this.setConnectingCompositeVisible(true);
                Job job = new Job(""){

                    /*
                     * Loose catch block
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        IStatus iStatus;
                        try {
                            (this).AuthenticationWizardPage.this.fToken = QTestIntegrationAuthenticationManager.getToken((IQTestCredential)new QTestCredentialImpl().setServerUrl(newServerUrl).setUsername(newUsername).setPassword(newPassword).setVersion(newVersion));
                            AuthenticationWizardPage.this.setConnectedStatus(StringConstants.WZ_P_AUTHENTICATION_MGS_CONNECT_SUCCESSFUL, true);
                            (this).AuthenticationWizardPage.this.fServerUrl = newServerUrl;
                            (this).AuthenticationWizardPage.this.fUsername = newUsername;
                            (this).AuthenticationWizardPage.this.fPwd = newPassword;
                            (this).AuthenticationWizardPage.this.fVersion = newVersion;
                            (this).AuthenticationWizardPage.this.isDirty = false;
                            UISynchronizeService.getInstance().getSync().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    AuthenticationWizardPage.this.firePageChanged();
                                }
                            });
                            iStatus = Status.OK_STATUS;
                        }
                        catch (QTestAPIConnectionException qTestAPIConnectionException) {
                            AuthenticationWizardPage.this.setConnectedStatus(ComposerIntegrationQtestMessageConstants.WZ_P_AUTHENTICATION_MGS_BAD_CREDENTIALS, false);
                            IStatus iStatus2 = Status.OK_STATUS;
                            UISynchronizeService.getInstance().getSync().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        AuthenticationWizardPage.this.setConnectingCompositeVisible(false);
                                    }
                                    catch (IllegalArgumentException | IllegalStateException | SWTException throwable) {}
                                }
                            });
                            monitor.done();
                            return iStatus2;
                        }
                        catch (QTestException qTestException) {
                            AuthenticationWizardPage.this.setConnectedStatus(StringConstants.WZ_P_AUTHENTICATION_MGS_CONNECT_FAILED, false);
                            IStatus iStatus3 = Status.OK_STATUS;
                            {
                                catch (Throwable throwable) {
                                    UISynchronizeService.getInstance().getSync().syncExec(new /* invalid duplicate definition of identical inner class */);
                                    monitor.done();
                                    throw throwable;
                                }
                            }
                            UISynchronizeService.getInstance().getSync().syncExec(new /* invalid duplicate definition of identical inner class */);
                            monitor.done();
                            return iStatus3;
                        }
                        UISynchronizeService.getInstance().getSync().syncExec(new /* invalid duplicate definition of identical inner class */);
                        monitor.done();
                        return iStatus;
                    }
                };
                job.setUser(false);
                job.schedule();
            }
        });
    }

    private void setConnectedStatus(final String text, final boolean isSuccessful) {
        UISynchronizeService.getInstance().getSync().syncExec(new Runnable(){

            @Override
            public void run() {
                AuthenticationWizardPage.this.lblConnectedStatus.setText(text);
                AuthenticationWizardPage.this.lblConnectedStatus.setForeground(isSuccessful ? ColorUtil.getTextSuccessfulColor() : ColorUtil.getTextErrorColor());
            }
        });
    }

    private void setConnectingCompositeVisible(boolean isConnectingCompositeVisible) {
        block11: {
            if (isConnectingCompositeVisible) {
                try {
                    try {
                        this.inputStream = ImageConstants.URL_16_LOADING.openStream();
                        this.connectingLabel.setGifImage(this.inputStream);
                        this.connectingComposite.layout(true, true);
                    }
                    catch (IOException iOException) {
                        if (this.inputStream != null) {
                            this.closeQuietlyWithLog(this.inputStream);
                            this.inputStream = null;
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (this.inputStream != null) {
                        this.closeQuietlyWithLog(this.inputStream);
                        this.inputStream = null;
                    }
                    throw throwable;
                }
                if (this.inputStream != null) {
                    this.closeQuietlyWithLog(this.inputStream);
                    this.inputStream = null;
                }
            } else if (this.inputStream != null) {
                this.closeQuietlyWithLog(this.inputStream);
                this.inputStream = null;
            }
        }
        this.connectingComposite.setVisible(isConnectingCompositeVisible);
        this.btnConnect.setEnabled(!isConnectingCompositeVisible);
    }

    private void maskPasswordField() {
        if (this.btnShowPassword.getSelection()) {
            this.txtPassword.setEchoChar('\u0000');
        } else {
            this.txtPassword.setEchoChar("\u2022".charAt(0));
        }
    }

    public boolean canFlipToNextPage() {
        return this.fToken != null && !this.isDirty;
    }

    public Map<String, Object> storeControlStates() {
        HashMap<String, Object> sharedData = new HashMap<String, Object>();
        sharedData.put("serverUrl", this.fServerUrl);
        sharedData.put("username", this.fUsername);
        sharedData.put("password", this.fPwd);
        sharedData.put("token", this.fToken);
        sharedData.put("version", this.fVersion);
        sharedData.put("enableAuthenticationEncryption", this.fEncryptionEnabled);
        this.lblStatusText = this.lblConnectedStatus.getText();
        this.isPasswordShowed = this.btnShowPassword.getSelection();
        return sharedData;
    }

    @Override
    public String getStepIndexAsString() {
        return "1";
    }

    @Override
    public boolean isChild() {
        return false;
    }
}

