/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.search.view;

import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.resources.util.ImageUtil;
import com.kms.katalon.composer.search.constants.StringConstants;
import com.kms.katalon.composer.search.view.QSearchInput;
import com.kms.katalon.composer.search.view.QSearchQuery;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class QSearchPage
extends DialogPage
implements ISearchPage {
    private Text searchText;
    private Button chckTestCase;
    private Button chckTestObject;
    private Button chckTestSuite;
    private Button chckTestData;
    private Button chckKeyword;
    private Button chckIsWholeWord;
    private Button chckIsRegularExpression;
    private Button chckIsCaseSensitive;
    private Button chckReport;
    private Group grpScope;

    public void createControl(Composite parent) {
        this.setTabFolderIcon(parent);
        Composite compositeContainer = new Composite(parent, 0);
        compositeContainer.setLayout((Layout)new GridLayout(1, false));
        Composite compositeSearch = new Composite(compositeContainer, 0);
        compositeSearch.setLayout((Layout)new GridLayout(1, false));
        compositeSearch.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite compositeSearchHeader = new Composite(compositeSearch, 0);
        GridLayout glCompositeSearchHeader = new GridLayout(1, false);
        glCompositeSearchHeader.marginWidth = 0;
        glCompositeSearchHeader.marginHeight = 0;
        compositeSearchHeader.setLayout((Layout)glCompositeSearchHeader);
        compositeSearchHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblContainingText = new Label(compositeSearchHeader, 0);
        lblContainingText.setText(StringConstants.VIEW_LBL_CONTAINING_TEXT);
        Composite compositeSearchDetails = new Composite(compositeSearch, 0);
        GridLayout glCompositeSearchDetails = new GridLayout(2, false);
        glCompositeSearchDetails.marginHeight = 0;
        glCompositeSearchDetails.marginWidth = 0;
        compositeSearchDetails.setLayout((Layout)glCompositeSearchDetails);
        compositeSearchDetails.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite compositeSearchText = new Composite(compositeSearchDetails, 0);
        GridLayout glCompositeSearchText = new GridLayout(1, false);
        glCompositeSearchText.marginWidth = 0;
        glCompositeSearchText.marginHeight = 0;
        compositeSearchText.setLayout((Layout)glCompositeSearchText);
        compositeSearchText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.searchText = new Text(compositeSearchText, 2048);
        this.searchText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblTips = new Label(compositeSearchText, 0);
        lblTips.setText("( * = anything, ? = any character, \\ = escape for literals: * ? \\)");
        Composite compositeSearchType = new Composite(compositeSearchDetails, 0);
        GridLayout gl_compositeSearchType = new GridLayout(1, false);
        gl_compositeSearchType.marginHeight = 0;
        compositeSearchType.setLayout((Layout)gl_compositeSearchType);
        this.chckIsCaseSensitive = new Button(compositeSearchType, 32);
        this.chckIsCaseSensitive.setText(StringConstants.VIEW_CHKBOX_CASE_SENSITIVE);
        this.chckIsRegularExpression = new Button(compositeSearchType, 32);
        this.chckIsRegularExpression.setText(StringConstants.VIEW_CHKBOX_REGULAR_EXPRESSION);
        this.chckIsWholeWord = new Button(compositeSearchType, 32);
        this.chckIsWholeWord.setText(StringConstants.VIEW_CHKBOX_WHOLE_WORD);
        this.chckIsWholeWord.setVisible(false);
        Composite compositeEntityType = new Composite(compositeContainer, 0);
        compositeEntityType.setLayout((Layout)new GridLayout(1, true));
        compositeEntityType.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.grpScope = new Group(compositeEntityType, 0);
        this.grpScope.setText(StringConstants.VIEW_LBL_SEARCH_IN);
        this.grpScope.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.grpScope.setLayout((Layout)new GridLayout(2, true));
        this.chckTestCase = new Button((Composite)this.grpScope, 32);
        this.chckTestCase.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chckTestCase.setText(StringConstants.VIEW_CHKBOX_TEST_CASE);
        this.chckTestObject = new Button((Composite)this.grpScope, 32);
        this.chckTestObject.setText(StringConstants.VIEW_CHKBOX_TEST_OBJ);
        this.chckTestSuite = new Button((Composite)this.grpScope, 32);
        this.chckTestSuite.setText(StringConstants.VIEW_CHKBOX_TEST_SUITE);
        this.chckTestData = new Button((Composite)this.grpScope, 32);
        this.chckTestData.setText(StringConstants.VIEW_CHKBOX_TEST_DATA);
        this.chckKeyword = new Button((Composite)this.grpScope, 32);
        this.chckKeyword.setText(StringConstants.VIEW_CHKBOX_KEYWORD);
        this.chckReport = new Button((Composite)this.grpScope, 32);
        this.chckReport.setText(StringConstants.VIEW_CHKBOX_REPORT);
        this.setControl((Control)compositeContainer);
    }

    private void setTabFolderIcon(Composite parent) {
        if (!(parent.getParent() instanceof TabFolder)) {
            return;
        }
        TabFolder tabFolder = (TabFolder)parent.getParent();
        if (tabFolder.getItemCount() <= 0) {
            return;
        }
        tabFolder.getItem(0).setImage(ImageUtil.loadImage((Bundle)FrameworkUtil.getBundle(ImageManager.class), (String)"/icons/search_16.png"));
    }

    private QSearchQuery createQuery() {
        ArrayList<String> fileNamePatterns = new ArrayList<String>();
        fileNamePatterns.add("!CustomKeywords.groovy");
        fileNamePatterns.add("!GlobalVariable.groovy");
        fileNamePatterns.add("!Temp*.groovy");
        String asterisk = "*";
        if (this.chckTestCase.getSelection()) {
            fileNamePatterns.add(String.valueOf(asterisk) + TestCaseEntity.getTestCaseFileExtension());
            fileNamePatterns.add("Script*.groovy");
        }
        if (this.chckTestObject.getSelection()) {
            fileNamePatterns.add(String.valueOf(asterisk) + WebElementEntity.getWebElementFileExtension());
        }
        if (this.chckTestData.getSelection()) {
            fileNamePatterns.add(String.valueOf(asterisk) + DataFileEntity.getTestDataFileExtension());
        }
        if (this.chckTestSuite.getSelection()) {
            fileNamePatterns.add(String.valueOf(asterisk) + TestSuiteEntity.getTestSuiteFileExtension());
        }
        if (this.chckKeyword.getSelection()) {
            if (!fileNamePatterns.contains("Script*.groovy")) {
                fileNamePatterns.add("!Script*.groovy");
            }
            fileNamePatterns.add(String.valueOf(asterisk) + ".groovy");
        }
        if (this.chckReport.getSelection()) {
            fileNamePatterns.add(String.valueOf(asterisk) + ReportEntity.getReportFileExtension());
        }
        QSearchInput input = new QSearchInput(this.searchText.getText(), this.chckIsCaseSensitive.getSelection(), this.chckIsRegularExpression.getSelection(), fileNamePatterns.toArray(new String[0]), GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject()));
        return new QSearchQuery(input.getSearchText(), input.isRegExSearch(), input.isCaseSensitiveSearch(), input.getScope());
    }

    public void setContainer(ISearchPageContainer container) {
        container.getSelection();
    }

    public boolean performAction() {
        try {
            NewSearchUI.runQueryInBackground((ISearchQuery)this.createQuery());
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public void setVisible(boolean visible) {
        if (visible && this.searchText != null) {
            this.searchText.setFocus();
        }
        super.setVisible(visible);
    }
}

