/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.factory;

import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.custom.parser.MethodUtils;
import com.kms.katalon.util.groovy.MethodNodeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.MethodNode;

public class CustomMethodNodeFactory {
    private Map<String, List<MethodNode>> methodNodesMap = new HashMap<String, List<MethodNode>>();
    private Map<String, List<String>> methodParameterNamesMap;
    private Map<String, Set<String>> classPathMap = new HashMap<String, Set<String>>();
    private Map<String, String> javadocMap = new HashMap<String, String>();
    private static CustomMethodNodeFactory _instance;

    private CustomMethodNodeFactory() {
        this.methodParameterNamesMap = new HashMap<String, List<String>>();
    }

    public static CustomMethodNodeFactory getInstance() {
        if (_instance == null) {
            _instance = new CustomMethodNodeFactory();
        }
        return _instance;
    }

    public void addMethodNodes(String className, List<MethodNode> methodNodes, String filePath) {
        ArrayList<MethodNode> customKeywordMethods = new ArrayList<MethodNode>();
        block0: for (MethodNode method : methodNodes) {
            if (method.getAnnotations() == null) continue;
            for (AnnotationNode annotationNode : method.getAnnotations()) {
                if (!this.isKeywordAnnotationNode(annotationNode)) continue;
                customKeywordMethods.add(method);
                continue block0;
            }
        }
        this.methodNodesMap.put(className, customKeywordMethods);
        this.addClassToClassPath(className, filePath);
    }

    public void addJavadoc(MethodNode methodNode, String htmlJavadoc) {
        String descriptor = MethodNodeUtil.getDescriptor((MethodNode)methodNode);
        this.javadocMap.put(descriptor, htmlJavadoc);
    }

    public String getJavadoc(MethodNode methodNode) {
        String descriptor = MethodNodeUtil.getDescriptor((MethodNode)methodNode);
        return StringUtils.defaultIfBlank((String)this.javadocMap.get(descriptor), (String)"");
    }

    public void addPluginMethodNodes(String className, List<MethodNode> methodNodes, String filePath, Map<String, List<String>> parameterMaps) {
        ArrayList<MethodNode> customKeywordMethods = new ArrayList<MethodNode>();
        block0: for (MethodNode method : methodNodes) {
            if (method.getAnnotations() == null) continue;
            for (AnnotationNode annotationNode : method.getAnnotations()) {
                if (!this.isKeywordAnnotationNode(annotationNode)) continue;
                customKeywordMethods.add(method);
                String typesName = MethodUtils.getParametersDescriptor(method);
                String methodName = String.valueOf(method.getName()) + "#" + typesName;
                List<String> parameterNames = parameterMaps.get(methodName);
                this.methodParameterNamesMap.put(String.valueOf(className) + '#' + methodName, parameterNames);
                continue block0;
            }
        }
        this.methodNodesMap.put(className, customKeywordMethods);
        this.addClassToClassPath(className, filePath);
    }

    private void addClassToClassPath(String className, String filePath) {
        Set<String> classes = this.classPathMap.get(filePath);
        if (classes == null) {
            classes = new HashSet<String>();
        }
        classes.add(className);
        this.classPathMap.put(filePath, classes);
    }

    private boolean isKeywordAnnotationNode(AnnotationNode annotationNode) {
        String annotaionClassNodeName = annotationNode.getClassNode().getName();
        return Keyword.class.getName().equals(annotaionClassNodeName) || Keyword.class.getSimpleName().equals(annotaionClassNodeName);
    }

    public void removeMethodNodes(String filePath) {
        Set<String> classes = this.classPathMap.get(filePath);
        if (classes == null) {
            return;
        }
        classes.stream().forEach(clazz -> {
            if (this.methodNodesMap.containsKey(clazz)) {
                this.methodNodesMap.remove(clazz);
            }
        });
        this.classPathMap.remove(filePath);
    }

    public void reset() {
        this.methodNodesMap.clear();
        this.classPathMap.clear();
        this.methodParameterNamesMap.clear();
        this.javadocMap.clear();
    }

    public boolean isCustomKeywordClass(String className) {
        return StringUtils.isNotEmpty((String)className) && this.methodNodesMap.containsKey(className);
    }

    public boolean isCustomKeywordMethod(MethodNode method) {
        if (method.getAnnotations() != null) {
            for (AnnotationNode annotationNode : method.getAnnotations()) {
                if (!this.isKeywordAnnotationNode(annotationNode)) continue;
                return true;
            }
        }
        return false;
    }

    public MethodNode findBestMatch(String className, String methodName, String[] parameterTypes) {
        MethodNode methodNode = this.find(className, methodName, parameterTypes);
        if (methodNode == null) {
            methodNode = this.find(className, methodName, parameterTypes.length);
        }
        return methodNode;
    }

    private MethodNode find(String className, String methodName, String[] parameterTypes) {
        List<MethodNode> methodNodes = this.getMethodNodesMap().get(className);
        for (MethodNode methodNode : methodNodes) {
            if (!MethodNodeUtil.matchMethodWithLooseParamTypesChecking((MethodNode)methodNode, (String)className, (String)methodName, (String[])parameterTypes)) continue;
            return methodNode;
        }
        return null;
    }

    private MethodNode find(String className, String methodName, int numberOfParameters) {
        List<MethodNode> methodNodes = this.getMethodNodesMap().get(className);
        for (MethodNode methodNode : methodNodes) {
            if (!MethodNodeUtil.matchMethod((MethodNode)methodNode, (String)className, (String)methodName, (int)numberOfParameters)) continue;
            return methodNode;
        }
        return null;
    }

    public Map<String, List<MethodNode>> getMethodNodesMap() {
        return this.methodNodesMap;
    }

    public Map<String, List<String>> getMethodParameterNamesMap() {
        return this.methodParameterNamesMap;
    }
}

