/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.handlers;

import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.transfer.TransferMoveFlag;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.constants.StringConstants;
import com.kms.katalon.composer.explorer.handlers.CopyHandler;
import com.kms.katalon.entity.folder.FolderEntity;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;

public class CutHandler
extends CopyHandler {
    @Inject
    EPartService partService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canExecute() {
        if (!this.isExplorerPartActive()) {
            return false;
        }
        Object[] selectedObjects = this.getExplorerSelection();
        if (selectedObjects.length == 0) {
            return false;
        }
        try {
            String entityTag = null;
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Object entity = objectArray[n2];
                if (!(entity instanceof ITreeEntity)) {
                    return false;
                }
                ITreeEntity treeEntity = (ITreeEntity)entity;
                if (treeEntity.getParent() == null) return false;
                if (!treeEntity.isRemoveable()) return false;
                if (!treeEntity.isRenamable()) return false;
                if (treeEntity instanceof PackageTreeEntity) return false;
                if (StringUtils.isEmpty((String)treeEntity.getCopyTag())) {
                    return false;
                }
                String copyTag = treeEntity.getCopyTag();
                if (StringUtils.equals((String)copyTag, (String)FolderEntity.FolderType.REPORT.toString())) {
                    return false;
                }
                if (StringUtils.equals((String)copyTag, (String)FolderEntity.FolderType.USER.toString())) {
                    return false;
                }
                if (entityTag == null) {
                    entityTag = copyTag;
                } else if (!StringUtils.equalsIgnoreCase((String)copyTag, (String)entityTag)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    @Override
    public void execute() {
        if (this.selectionService != null && this.partService != null && !this.partService.getDirtyParts().isEmpty()) {
            if (!MessageDialog.openConfirm(null, (String)StringConstants.HAND_CONFIRM_TITLE, (String)StringConstants.HAND_CONFIRM_MSG_REQUIRE_SAVE_ALL_B4_CONTINUE_MOVING)) {
                return;
            }
            if (!this.partService.saveAll(true)) {
                return;
            }
        }
        super.execute();
        TransferMoveFlag.setMove((boolean)true);
    }
}

