/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.handler;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.handlers.NewTestCaseHandler;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.composer.webui.recorder.constants.ComposerWebuiRecorderMessageConstants;
import com.kms.katalon.composer.webui.recorder.dialog.RecorderDialog;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.objectspy.dialog.SaveToObjectRepositoryDialog;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.WebParent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openqa.selenium.Keys;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RecordHandler {
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private UISynchronize sync;
    private RecorderDialog recordDialog;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("KATALON/RECORD", new EventHandler(){

            public void handleEvent(Event event) {
                if (!RecordHandler.this.canExecute()) {
                    return;
                }
                RecordHandler.this.execute();
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute() {
        Shell shell = null;
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (activeShell == null) {
            activeShell = new Shell();
        }
        boolean firstRecord = false;
        UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
        if (currentProfile.isNewUser() && !currentProfile.isDoneOpenRecorder()) {
            firstRecord = true;
        }
        try {
            TestCaseCompositePart testCaseCompositePart = this.getSelectedTestCasePart();
            if (testCaseCompositePart != null) {
                if (!this.featureService.canUse(KSEFeature.CUSTOM_KEYWORD) && testCaseCompositePart.isUseCustomKeyword()) {
                    String dialogMessage = ComposerTestcaseMessageConstants.MSG_KSE_FEATURE_TEST_CASE_CONTAINS_CUSTOM_KEYWORD;
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CUSTOM_KEYWORD, (String)"", (String)dialogMessage);
                    return;
                }
                if (!this.verifyTestCase(testCaseCompositePart)) {
                    return;
                }
            }
            List wrapper = new ArrayList();
            List<Object> variables = new ArrayList<VariableEntity>();
            TestCaseEntity testCaseEntity = null;
            boolean shouldOverride = true;
            if (testCaseCompositePart != null) {
                String scriptContent = StringUtils.defaultString((String)testCaseCompositePart.getScriptContent());
                wrapper = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper((String)scriptContent).getRunMethod().getBlock().getAstChildren();
                testCaseEntity = testCaseCompositePart.getTestCase();
                variables = testCaseCompositePart.getTestCase().clone().getVariables();
            }
            if (this.recordDialog != null && !this.recordDialog.isDisposed()) {
                this.recordDialog.getShell().forceActive();
                return;
            }
            shell = this.getShell(activeShell);
            this.recordDialog = new RecorderDialog(shell, testCaseEntity, wrapper, variables);
            int responseCode = this.recordDialog.open();
            if (responseCode != 0) {
                return;
            }
            SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult = this.recordDialog.getTargetFolderTreeEntity();
            List<WebPage> recordedElements = this.recordDialog.getElements();
            if (this.recordDialog.getScriptWrapper() == null || this.recordDialog.getScriptWrapper().getBlock() == null || this.recordDialog.getScriptWrapper().getBlock().getAstChildren() == null || this.recordDialog.getScriptWrapper().getBlock().getAstChildren().isEmpty()) {
                return;
            }
            try {
                boolean isNew = false;
                TestCaseEntity newTestCase = testCaseEntity;
                if (newTestCase == null) {
                    newTestCase = this.createNewTestCase();
                    isNew = true;
                }
                if (testCaseCompositePart == null || testCaseCompositePart.isDisposed()) {
                    testCaseCompositePart = this.getTestCasePartByTestCase(newTestCase);
                    shouldOverride = false;
                } else if (!wrapper.isEmpty()) {
                    MessageDialog dialog = new MessageDialog(activeShell, GlobalStringConstants.CONFIRMATION, null, MessageFormat.format(ComposerWebuiRecorderMessageConstants.DIA_APPEND_TEST_CASE_SCRIPT, testCaseEntity.getName()), 5, 0, new String[]{ComposerWebuiRecorderMessageConstants.DIA_CONFIRM_APPEND_TEST_CASE_SCRIPT, ComposerWebuiRecorderMessageConstants.DIA_CONFIRM_REPLACE_TEST_CASE_SCRIPT});
                    shouldOverride = dialog.open() != 0;
                }
                this.updateRecordedElementsAfterSavingToObjectRepository(recordedElements, folderSelectionResult != null ? folderSelectionResult.getEntitySavedMap() : Collections.emptyMap());
                this.doGenerateTestScripts(newTestCase, testCaseCompositePart, folderSelectionResult, recordedElements, this.recordDialog.getScriptWrapper(), this.recordDialog.getVariables(), shouldOverride, isNew);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)activeShell, (String)GlobalStringConstants.ERROR, (String)ComposerWebuiRecorderMessageConstants.HAND_ERROR_MSG_CANNOT_GEN_TEST_STEPS);
                LoggerSingleton.logError((Throwable)e);
            }
        }
        finally {
            if (shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
            if (firstRecord) {
                this.eventBroker.post("RECORDER/DONE_FIRST_RECORD", null);
            }
        }
    }

    private void updateRecordedElementsAfterSavingToObjectRepository(List<WebPage> recordedElements, Map<WebElement, FileEntity> entitySavedMap) {
        List recordedElementNames = recordedElements.stream().map(b -> b.getName()).collect(Collectors.toList());
        entitySavedMap.entrySet().stream().filter(a -> a.getKey() instanceof WebPage && ((WebElement)a.getKey()).getTag() != null && ((WebElement)a.getKey()).getTag().equals("cloned")).map(a -> (WebPage)a.getKey()).forEach(a -> {
            try {
                WebPage recordedWebPage = (WebPage)recordedElements.get(recordedElementNames.indexOf(a.getName()));
                List aChildNames = a.getChildren().stream().map(b -> b.getName()).collect(Collectors.toList());
                recordedWebPage.getChildren().removeIf(b -> aChildNames.contains(b.getName()));
                recordedElements.add((WebPage)a);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        });
    }

    private Shell getShell(Shell activeShell) {
        String os = Platform.getOS();
        if ("win32".equals(os) || "linux".equals(os)) {
            return null;
        }
        Shell shell = new Shell();
        Rectangle activeShellSize = activeShell.getBounds();
        shell.setLocation((activeShellSize.width - shell.getBounds().width) / 2, (activeShellSize.height - shell.getBounds().height) / 2);
        return shell;
    }

    private TestCaseEntity createNewTestCase() throws Exception {
        TestCaseEntity testCase = NewTestCaseHandler.doCreateNewTestCase((ITreeEntity)new FolderTreeEntity(FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject()), null), (IEventBroker)EventBrokerSingleton.getInstance().getEventBroker());
        if (testCase == null) {
            return null;
        }
        return testCase;
    }

    private void doGenerateTestScripts(final TestCaseEntity newTestCase, final TestCaseCompositePart testCaseCompositePart, final SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult, final List<WebPage> recordedElements, final ScriptNodeWrapper wrapper, final VariableEntity[] variables, final boolean shouldOverride, final boolean isNew) {
        if (testCaseCompositePart == null) {
            return;
        }
        final TestCasePart testCasePart = testCaseCompositePart.getChildTestCasePart();
        if (testCasePart.getTreeTableInput() == null) {
            testCaseCompositePart.loadTreeTableInput();
        }
        Job job = new Job(ComposerWebuiRecorderMessageConstants.JOB_GENERATE_SCRIPT_MESSAGE){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(ComposerWebuiRecorderMessageConstants.JOB_GENERATE_SCRIPT_MESSAGE, -1);
                    RecordHandler.this.addRecordedElements(recordedElements, folderSelectionResult, monitor);
                    RecordHandler.this.sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                List children = wrapper.getBlock().getAstChildren();
                                if (children.isEmpty()) {
                                    return;
                                }
                                testCasePart.addDefaultImports();
                                testCasePart.getTreeTableInput().getMainClassNode().addImport(Keys.class);
                                if (shouldOverride) {
                                    testCasePart.clearAndAddStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
                                } else {
                                    testCasePart.addStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
                                }
                                testCasePart.addVariables(variables);
                                testCasePart.getTreeTableInput().setChanged(true);
                                testCaseCompositePart.changeScriptNode(testCasePart.getTreeTableInput().getMainClassNode());
                                testCaseCompositePart.recorderSave(isNew);
                                if (OSUtil.isMacBigSurOrLater() && testCaseCompositePart.getSelectedPart() == testCaseCompositePart.getChildManualPart() && testCasePart.getTestCaseTreeTable() != null) {
                                    testCasePart.getTestCaseTreeTable().getTree().redraw();
                                }
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                        }
                    });
                    if (folderSelectionResult != null) {
                        FolderTreeEntity targetFolderTreeEntity = folderSelectionResult.getSelectedParentFolder();
                        RecordHandler.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)targetFolderTreeEntity.getParent());
                        RecordHandler.this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)targetFolderTreeEntity);
                        RecordHandler.this.eventBroker.send("EXPLORER/EXPAND_TREE_ENTITY", (Object)targetFolderTreeEntity);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    RecordHandler.this.sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalStringConstants.ERROR, (String)ComposerWebuiRecorderMessageConstants.HAND_ERROR_MSG_CANNOT_GEN_TEST_STEPS);
                            LoggerSingleton.logError((Throwable)e);
                        }
                    });
                    LoggerSingleton.logError((Throwable)e);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
                if (newTestCase != null && currentProfile.isNewUser() && !currentProfile.isDoneRunFirstTestCase()) {
                    currentProfile.setDoneSaveFirstRecord(true);
                    UserProfileHelper.saveProfile((UserProfile)currentProfile);
                    RecordHandler.this.eventBroker.post("FIRST_TEST_CASE_CREATED", (Object)newTestCase);
                }
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private TestCaseCompositePart getSelectedTestCasePart() throws Exception {
        MPartStack composerStack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        MPart selectedPart = (MPart)composerStack.getSelectedElement();
        if (selectedPart == null || !selectedPart.getElementId().startsWith("com.kms.katalon.composer.content.testcase") || !(selectedPart.getObject() instanceof TestCaseCompositePart)) {
            return null;
        }
        return (TestCaseCompositePart)selectedPart.getObject();
    }

    private TestCaseCompositePart getTestCasePartByTestCase(TestCaseEntity testCase) throws Exception {
        if (testCase == null) {
            return null;
        }
        MPart selectedPart = (MPart)this.modelService.find(EntityPartUtil.getTestCaseCompositePartId((String)testCase.getId()), (MUIElement)this.application);
        if (selectedPart == null || !(selectedPart.getObject() instanceof TestCaseCompositePart)) {
            return null;
        }
        return (TestCaseCompositePart)selectedPart.getObject();
    }

    private boolean verifyTestCase(TestCaseCompositePart testCaseCompositePart) throws Exception {
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (testCaseCompositePart.getDirty().isDirty()) {
            if (!MessageDialog.openConfirm((Shell)activeShell, (String)GlobalStringConstants.WARN, (String)ComposerWebuiRecorderMessageConstants.HAND_ERROR_MSG_PLS_SAVE_TEST_CASE)) {
                return false;
            }
            testCaseCompositePart.save();
        }
        try {
            testCaseCompositePart.getAstNodesFromScript();
        }
        catch (CompilationFailedException compilationFailedException) {
            MessageDialog.openWarning((Shell)activeShell, (String)GlobalStringConstants.WARN, (String)ComposerWebuiRecorderMessageConstants.HAND_ERROR_MSG_PLS_FIX_TEST_CASE);
            return false;
        }
        return true;
    }

    private void addRecordedElements(List<WebPage> recordedElements, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult, IProgressMonitor monitor) throws Exception {
        for (WebPage pageElement : recordedElements) {
            FolderEntity importedFolder = (FolderEntity)folderSelectionResult.getEntitySavedMap().get(pageElement);
            if (importedFolder != null) {
                pageElement.setFolderAlias(importedFolder);
            }
            for (WebElement childElement : pageElement.getChildren()) {
                this.addRecordedElement(childElement, importedFolder, folderSelectionResult);
            }
            monitor.worked(1);
        }
    }

    private void addRecordedElement(WebElement element, FolderEntity parentFolder, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult) throws Exception {
        FileEntity entity = folderSelectionResult.getEntitySavedMap().entrySet().stream().filter(e -> {
            WebElement savedElement = (WebElement)e.getKey();
            WebPage savedRoot = savedElement.getRoot();
            if (savedRoot == null) {
                return false;
            }
            WebPage root = element.getRoot();
            return savedElement.equals((Object)element) && root != null && savedRoot.getName().equals(root.getName());
        }).map(e -> (FileEntity)e.getValue()).findFirst().orElse(null);
        if (entity != null) {
            element.setName(entity.getName());
        }
        if (element instanceof WebParent var5_6) {
            for (WebElement childElement : webParent.getChildren()) {
                this.addRecordedElement(childElement, parentFolder, folderSelectionResult);
            }
        }
    }
}

