/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.preferences;

import com.kms.katalon.composer.components.dialogs.FieldEditorPreferencePageWithHelp;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.webui.recorder.constants.ComposerWebuiRecorderMessageConstants;
import com.kms.katalon.composer.webui.recorder.preferences.RecorderPreferenceDefaultValueInitializer;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RecorderPreferencePage
extends FieldEditorPreferencePageWithHelp {
    private Combo cbbDefaultBrowser;
    private Composite mainComposite;
    private Button chckPinRecorder;
    private Text txtProfile;
    private static final int MIN_PORT_NUMBER = 1;
    private static final int MAX_PORT_NUMBER = 65534;
    private static final String URL_WEB_RECORDER_USING_CHROME_W_PROFILE = "https://docs.katalon.com/katalon-studio/docs/record-web-utility-using-chrome-with-profile.html";
    private static final String DEFAULT_CHROME_USER_DATA_FOR_WINDOWS = "\\Google\\Chrome\\User Data";
    private static final String DEFAULT_CHROME_USER_DATA_FOR_MAC = "/Library/Application Support/Google/Chrome";
    private static final String DEFAULT_CHROME_USER_DATA_FOR_LINUX = "/.config/google-chrome";

    public RecorderPreferencePage() {
        this.setPreferenceStore((IPreferenceStore)PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.webui.recorder"));
        this.setPreferenceStore((IPreferenceStore)PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.webui.objectspy"));
    }

    protected Control createContents(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        this.mainComposite.setLayout((Layout)layout);
        this.mainComposite.setLayoutData((Object)new GridData(768));
        this.chckPinRecorder = new Button(this.mainComposite, 32);
        this.chckPinRecorder.setText(ComposerWebuiRecorderMessageConstants.PREF_LBL_PIN_RECORDER_WINDOW);
        GridData ldPinRecorder = new GridData(16384, 0x1000000, true, false);
        ldPinRecorder.horizontalSpan = 2;
        this.chckPinRecorder.setLayoutData((Object)ldPinRecorder);
        Label lblDefaultBrowser = new Label(this.mainComposite, 0);
        lblDefaultBrowser.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblDefaultBrowser.setText(ComposerWebuiRecorderMessageConstants.PREF_LBL_DEFAULT_BROWSER);
        this.cbbDefaultBrowser = new Combo(this.mainComposite, 12);
        this.cbbDefaultBrowser.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cbbDefaultBrowser.setText(ComposerWebuiRecorderMessageConstants.PREF_LBL_DEFAULT_BROWSER);
        IntegerFieldEditor portEditor = new IntegerFieldEditor("utilitiesAddon.instantBrowserPort", ComposerWebuiRecorderMessageConstants.PREF_LBL_ACTIVE_BROWSER_PORT, this.mainComposite);
        portEditor.setValidRange(1, 65534);
        this.addField((FieldEditor)portEditor);
        this.addCheckboxField(this.mainComposite);
        Group grpChromeProfile = new Group(this.mainComposite, 0);
        grpChromeProfile.setText(ComposerWebuiRecorderMessageConstants.MSG_WEB_RECORDER_USING_CHROME_W_PROFILE);
        GridLayout lChromeProfile = new GridLayout(2, false);
        lChromeProfile.marginWidth = 0;
        grpChromeProfile.setLayout((Layout)lChromeProfile);
        GridData gdChromeProfile = new GridData(4, 4, true, false, 2, 1);
        gdChromeProfile.verticalIndent = 20;
        grpChromeProfile.setLayoutData((Object)gdChromeProfile);
        Label lblPrompt = new Label((Composite)grpChromeProfile, 0);
        lblPrompt.setText(ComposerWebuiRecorderMessageConstants.MSG_SPECIFY_CHROME_PROFILE_FOR_LOADING_KRU);
        Label lblHelp = new Label((Composite)grpChromeProfile, 0);
        lblHelp.setImage(ImageManager.getImage((String)"help_16.png"));
        lblHelp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                try {
                    Program.launch((String)RecorderPreferencePage.URL_WEB_RECORDER_USING_CHROME_W_PROFILE);
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openWarning((Shell)RecorderPreferencePage.this.getShell(), (String)GlobalMessageConstants.ERROR, (String)ex.getMessage());
                }
            }
        });
        Composite cpProfileEditor = new Composite((Composite)grpChromeProfile, 0);
        GridData gdProfileEditor = new GridData(4, 4, true, false, 2, 1);
        cpProfileEditor.setLayoutData((Object)gdProfileEditor);
        GridLayout glProfileEditor = new GridLayout(2, false);
        glProfileEditor.marginWidth = 0;
        glProfileEditor.marginHeight = 0;
        cpProfileEditor.setLayout((Layout)glProfileEditor);
        Label lblProfile = new Label(cpProfileEditor, 0);
        lblProfile.setText(ComposerWebuiRecorderMessageConstants.LBL_DIC_EDITOR_FOR_CHROME_PROFILE);
        Composite cpInput = new Composite(cpProfileEditor, 0);
        cpInput.setLayout((Layout)new GridLayout(2, false));
        cpInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtProfile = new Text(cpInput, 2048);
        this.txtProfile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button btnBrowse = new Button(cpInput, 0);
        btnBrowse.setText(ComposerWebuiRecorderMessageConstants.BTN_BROWSE);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                dialog.setFilterPath(RecorderPreferencePage.getDefaultChromeUserDataDir());
                RecorderPreferencePage.this.txtProfile.setText(dialog.open());
            }
        });
        this.setInput();
        this.initialize();
        this.checkState();
        return this.mainComposite;
    }

    private static String getDefaultChromeUserDataDir() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return String.valueOf(System.getenv("LOCALAPPDATA")) + DEFAULT_CHROME_USER_DATA_FOR_WINDOWS;
        }
        if (SystemUtils.IS_OS_MAC) {
            return String.valueOf(System.getProperty("user.home")) + DEFAULT_CHROME_USER_DATA_FOR_MAC;
        }
        if (SystemUtils.IS_OS_LINUX) {
            return String.valueOf(System.getProperty("user.home")) + DEFAULT_CHROME_USER_DATA_FOR_LINUX;
        }
        return "";
    }

    private void setInput() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        List<String> browsers = this.getDefaultBrowserOptions();
        String selectedBrowser = preferenceStore.getString("recorder.defaultBrowser");
        int index = browsers.indexOf(selectedBrowser);
        this.cbbDefaultBrowser.setItems(browsers.toArray(new String[browsers.size()]));
        this.cbbDefaultBrowser.select(Math.max(0, index));
        this.chckPinRecorder.setSelection(preferenceStore.getBoolean("recorder.pinWindow"));
        this.txtProfile.setText(preferenceStore.getString("utilitiesAddon.chromeProfile"));
    }

    private List<String> getDefaultBrowserOptions() {
        ArrayList<String> browsers = new ArrayList<String>(Arrays.asList(RecorderPreferenceDefaultValueInitializer.SUPPORTED_BROWSERS));
        if (!"win32".equals(Platform.getOS())) {
            browsers.remove(WebUIDriverType.IE_DRIVER.toString());
        }
        return browsers;
    }

    public boolean performOk() {
        if (this.mainComposite == null || this.mainComposite.isDisposed()) {
            return true;
        }
        ScopedPreferenceStore store = (ScopedPreferenceStore)this.getPreferenceStore();
        store.setValue("recorder.defaultBrowser", this.cbbDefaultBrowser.getText());
        store.setValue("recorder.pinWindow", this.chckPinRecorder.getSelection());
        store.setValue("utilitiesAddon.chromeProfile", this.txtProfile.getText());
        try {
            store.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return super.performOk();
    }

    private void addCheckboxField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.addField((FieldEditor)new BooleanFieldEditor("utilitiesAddon.instantBrowser.doNotShowAgain", ComposerWebuiRecorderMessageConstants.PREF_LBL_ACTIVE_BROWSER_PORT_DO_NOT_SHOW_WARNING_DIALOG, composite));
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.PREFERENCE_UTILITY_ADDON;
    }

    protected void createFieldEditors() {
    }
}

