/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.util;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.model.InputValueEditorProvider;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.composer.webui.recorder.action.HTMLAction;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionMapping;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionParamValueType;
import com.kms.katalon.composer.webui.recorder.action.HTMLSynchronizeAction;
import com.kms.katalon.composer.webui.recorder.action.HTMLValidationAction;
import com.kms.katalon.composer.webui.recorder.action.IHTMLAction;
import com.kms.katalon.composer.webui.recorder.ast.RecordedElementMethodCallWrapper;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.keyword.WebUiBuiltInKeywords;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.custom.keyword.KeywordParameter;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebPage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;

public class HTMLActionUtil {
    private static final String ABOUT_BLANK = "\"about:blank\"";
    public static final int DF_SELECTED_INDEX_IF_NULL = 0;
    private static List<HTMLValidationAction> validationActions;
    private static List<HTMLSynchronizeAction> synchronizeActions;

    public static KeywordClass getWebUiKeywordClass() {
        return KeywordController.getInstance().getBuiltInKeywordClassByName(WebUiBuiltInKeywords.class.getName());
    }

    private static KeywordMethod getMethodInActionMapping(HTMLActionMapping actionMapping) throws ClassNotFoundException {
        IHTMLAction action = actionMapping.getAction();
        if (action == null) {
            return null;
        }
        KeywordMethod method = null;
        for (KeywordMethod declareMethod : KeywordController.getInstance().getBuiltInKeywords(action.getMappedKeywordClassSimpleName())) {
            if (!declareMethod.getName().equals(action.getMappedKeywordMethod())) continue;
            method = declareMethod;
            break;
        }
        return method;
    }

    public static StatementWrapper generateWebUiTestStep(HTMLActionMapping actionMapping, WebElement webElement, ASTNodeWrapper parentClassNode) throws ClassNotFoundException {
        KeywordMethod method = HTMLActionUtil.getMethodInActionMapping(actionMapping);
        if (method == null) {
            return null;
        }
        int actionDataCount = 0;
        IHTMLAction action = actionMapping.getAction();
        MethodCallExpressionWrapper methodCallExpressionWrapper = new MethodCallExpressionWrapper(HTMLActionUtil.getWebUiKeywordClass().getAliasName(), action.getMappedKeywordMethod(), parentClassNode);
        ArgumentListExpressionWrapper argumentListExpressionWrapper = methodCallExpressionWrapper.getArguments();
        int i = 0;
        while (i < method.getParameters().length) {
            Class argumentClass = method.getParameters()[i].getType();
            RecordedElementMethodCallWrapper generatedExression = null;
            if (argumentClass.getName().equals(TestObject.class.getName())) {
                generatedExression = new RecordedElementMethodCallWrapper(parentClassNode, webElement);
            } else if (argumentClass.getName().equals(FailureHandling.class.getName())) {
                generatedExression = AstKeywordsInputUtil.getNewFailureHandlingPropertyExpression(null);
            } else {
                HTMLActionParamValueType paramValueType = actionMapping.getData()[actionDataCount];
                generatedExression = paramValueType.toExpressionWrapper();
                ++actionDataCount;
            }
            argumentListExpressionWrapper.addExpression((ExpressionWrapper)generatedExression);
            ++i;
        }
        return new ExpressionStatementWrapper((ExpressionWrapper)methodCallExpressionWrapper, null);
    }

    private static boolean areElementsEqual(WebElement elm1, WebElement elm2) {
        return new EqualsBuilder().append((Object)elm1.getType(), (Object)elm2.getType()).append((Object)elm1.getTag(), (Object)elm2.getTag()).append(elm1.hasProperty(), elm2.hasProperty()).append((Object)elm1.getXpath(), (Object)elm2.getXpath()).isEquals();
    }

    public static HTMLActionMapping createNewSwitchToWindowAction(String windowTitle) {
        HTMLActionParamValueType paramType = HTMLActionParamValueType.newInstance((InputValueEditorProvider)InputValueType.String, HTMLActionUtil.convertToExpressionWrapper(GroovyStringUtil.toGroovyStringFormat((String)windowTitle)));
        return new HTMLActionMapping((IHTMLAction)HTMLAction.SwitchToWindow, new HTMLActionParamValueType[]{paramType}, null);
    }

    public static String getPageTitleForAction(HTMLActionMapping actionMapping) {
        WebElementPropertyEntity pageTitle;
        WebElement element = actionMapping.getTargetElement();
        while (element != null && !(element instanceof WebPage)) {
            element = element.getParent();
        }
        if (element != null && (pageTitle = element.getProperty("title")) != null) {
            return pageTitle.getValue();
        }
        return "";
    }

    public static List<IHTMLAction> getAllHTMLActions() {
        ArrayList<IHTMLAction> result = new ArrayList<IHTMLAction>();
        HTMLAction[] hTMLActionArray = HTMLAction.values();
        int n = hTMLActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            HTMLAction htmlAction = hTMLActionArray[n2];
            result.add(htmlAction);
            ++n2;
        }
        return result;
    }

    public static List<HTMLValidationAction> getAllHTMLValidationActions() {
        if (validationActions != null) {
            return validationActions;
        }
        validationActions = new ArrayList<HTMLValidationAction>();
        Method[] methodArray = WebUiBuiltInKeywords.class.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("verify")) {
                validationActions.add(new HTMLValidationAction(method.getName(), WebUiBuiltInKeywords.class.getName(), WebUiBuiltInKeywords.class.getSimpleName(), method.getName(), TestCaseEntityUtil.getBuiltinKeywordJavadocText((String)WebUiBuiltInKeywords.class.getName(), (String)method.getName())));
            }
            ++n2;
        }
        return validationActions;
    }

    public static List<HTMLSynchronizeAction> getAllHTMLSynchronizeActions() {
        if (synchronizeActions != null) {
            return synchronizeActions;
        }
        synchronizeActions = new ArrayList<HTMLSynchronizeAction>();
        Method[] methodArray = WebUiBuiltInKeywords.class.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("wait")) {
                synchronizeActions.add(new HTMLSynchronizeAction(method.getName(), WebUiBuiltInKeywords.class.getName(), WebUiBuiltInKeywords.class.getSimpleName(), method.getName(), TestCaseEntityUtil.getBuiltinKeywordJavadocText((String)WebUiBuiltInKeywords.class.getName(), (String)method.getName())));
            }
            ++n2;
        }
        return synchronizeActions;
    }

    public static HTMLSynchronizeAction getDefaultSynchronizeAction() {
        List<HTMLSynchronizeAction> allActions = HTMLActionUtil.getAllHTMLSynchronizeActions();
        if (allActions == null) {
            return null;
        }
        for (HTMLSynchronizeAction action : allActions) {
            if (!action.getName().equals("waitForElementPresent")) continue;
            return action;
        }
        return allActions.size() > 0 ? allActions.get(allActions.size() - 1) : null;
    }

    public static HTMLValidationAction getDefaultValidationAction() {
        List<HTMLValidationAction> allActions = HTMLActionUtil.getAllHTMLValidationActions();
        if (allActions == null) {
            return null;
        }
        for (HTMLValidationAction action : allActions) {
            if (!action.getName().equals("verifyElementPresent")) continue;
            return action;
        }
        return allActions.size() > 0 ? allActions.get(allActions.size() - 1) : null;
    }

    public static IHTMLAction.HTMLActionParam[] collectKeywordParam(String keywordClass, String keywordMethodName) {
        KeywordMethod keywordMethod = KeywordController.getInstance().getBuiltInKeywordByName(keywordClass, keywordMethodName);
        if (keywordMethod == null) {
            return new IHTMLAction.HTMLActionParam[0];
        }
        ArrayList<IHTMLAction.HTMLActionParam> paramList = new ArrayList<IHTMLAction.HTMLActionParam>();
        int i = 0;
        while (i < keywordMethod.getParameters().length) {
            KeywordParameter parameter = keywordMethod.getParameters()[i];
            if (parameter.isGeneralParam()) {
                paramList.add(new IHTMLAction.HTMLActionParam(parameter.getName(), parameter.getType()));
            }
            ++i;
        }
        return paramList.toArray(new IHTMLAction.HTMLActionParam[paramList.size()]);
    }

    public static boolean hasElement(String keywordClass, String keywordMethodName) {
        KeywordMethod keywordMethod = KeywordController.getInstance().getBuiltInKeywordByName(keywordClass, keywordMethodName);
        if (keywordMethod == null) {
            return false;
        }
        int i = 0;
        while (i < keywordMethod.getParameters().length) {
            if (keywordMethod.getParameters()[i].isTestObjectParam()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static HTMLActionParamValueType[] generateParamDatas(IHTMLAction action, HTMLActionParamValueType[] existingParamDatas) {
        if (action == null || action.getParams() == null) {
            return new HTMLActionParamValueType[0];
        }
        HTMLActionParamValueType[] newParamDataArray = new HTMLActionParamValueType[action.getParams().length];
        int i = 0;
        while (i < action.getParams().length) {
            InputValueType valueType;
            HTMLActionParamValueType existingParamData;
            HTMLActionParamValueType hTMLActionParamValueType = existingParamData = existingParamDatas != null && i < existingParamDatas.length ? existingParamDatas[i] : null;
            if (!HTMLActionUtil.isAssignableFromScript(existingParamData, action.getParams()[i]) && (valueType = AstInputValueTypeOptionsProvider.getAssignableValueType(action.getParams()[i].getClazz())) != null) {
                existingParamData = HTMLActionParamValueType.newInstance((InputValueEditorProvider)valueType);
            }
            newParamDataArray[i] = existingParamData;
            ++i;
        }
        return newParamDataArray;
    }

    private static boolean isAssignableFromScript(HTMLActionParamValueType existingParamData, IHTMLAction.HTMLActionParam param) {
        if (existingParamData == null) {
            return false;
        }
        ExpressionWrapper expression = existingParamData.toExpressionWrapper();
        if (expression == null) {
            return false;
        }
        Class<?> paramClass = param.getClazz();
        ClassNodeWrapper existingParamClassNode = expression.getType();
        if (paramClass.isPrimitive() || existingParamClassNode.getTypeClass() == null) {
            return paramClass.getName().equalsIgnoreCase(existingParamClassNode.getName());
        }
        return paramClass.isAssignableFrom(existingParamClassNode.getTypeClass());
    }

    public static ExpressionWrapper convertToExpressionWrapper(String rawString) {
        return GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)rawString);
    }
}

