/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.complete;

import java.util.Stack;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.GenericAstVisitor;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.GuardedPattern;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;

public class CompletionNodeDetector
extends ASTVisitor {
    private ASTNode searchedNode;
    private ASTNode parent;
    private Expression outerExpression;
    private Stack<ASTNode> interestingEnclosings = new Stack();
    private ASTNode enclosingNode;
    private boolean result;
    private ASTNode blockedNode;
    private boolean containsPotentialPolyExpression = false;

    public static boolean findAny(CompilationUnitDeclaration unit, ASTNode searchFor) {
        FindAny visitor = new FindAny(searchFor);
        unit.traverse((ASTVisitor)visitor, null, false);
        return visitor.found;
    }

    public CompletionNodeDetector(ASTNode searchedNode, ASTNode visitedAst) {
        this.searchedNode = searchedNode;
        this.result = false;
        if (searchedNode != null && visitedAst != null) {
            try {
                if (visitedAst instanceof AbstractMethodDeclaration) {
                    ((AbstractMethodDeclaration)visitedAst).traverse((ASTVisitor)this, null);
                } else if (visitedAst instanceof CompilationUnitDeclaration) {
                    ((CompilationUnitDeclaration)visitedAst).traverse((ASTVisitor)this, null);
                } else {
                    visitedAst.traverse((ASTVisitor)this, null);
                }
            }
            catch (StopTraversal stopTraversal) {
                // empty catch block
            }
        }
    }

    public boolean containsCompletionNode() {
        return this.result;
    }

    public ASTNode getCompletionNodeParent() {
        return this.parent;
    }

    public Expression getCompletionNodeOuterExpression() {
        if (this.outerExpression != null) {
            return this.outerExpression;
        }
        if (this.parent instanceof Expression) {
            return (Expression)this.parent;
        }
        return null;
    }

    public ASTNode getCompletionEnclosingNode() {
        return this.enclosingNode;
    }

    public void endVisit(AllocationExpression allocationExpression, BlockScope scope) {
        this.endVisit((ASTNode)allocationExpression);
    }

    public void endVisit(AND_AND_Expression and_and_Expression, BlockScope scope) {
        this.interestingEnclosings.pop();
        this.endVisit((ASTNode)and_and_Expression);
    }

    public void endVisit(ArrayAllocationExpression arrayAllocationExpression, BlockScope scope) {
        this.endVisit((ASTNode)arrayAllocationExpression);
    }

    public void endVisit(ArrayInitializer arrayInitializer, BlockScope scope) {
        this.endVisit((ASTNode)arrayInitializer);
    }

    public void endVisit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope scope) {
        this.endVisit((ASTNode)arrayQualifiedTypeReference);
    }

    public void endVisit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope scope) {
        this.endVisit((ASTNode)arrayQualifiedTypeReference);
    }

    public void endVisit(ArrayReference arrayReference, BlockScope scope) {
        this.endVisit((ASTNode)arrayReference);
    }

    public void endVisit(ArrayTypeReference arrayTypeReference, BlockScope scope) {
        this.endVisit((ASTNode)arrayTypeReference);
    }

    public void endVisit(ArrayTypeReference arrayTypeReference, ClassScope scope) {
        this.endVisit((ASTNode)arrayTypeReference);
    }

    public void endVisit(Assignment assignment, BlockScope scope) {
        this.endVisit((ASTNode)assignment);
    }

    public void endVisit(BinaryExpression binaryExpression, BlockScope scope) {
        this.endVisit((ASTNode)binaryExpression);
    }

    public void endVisit(CastExpression castExpression, BlockScope scope) {
        this.endVisit((ASTNode)castExpression);
    }

    public void endVisit(CompoundAssignment compoundAssignment, BlockScope scope) {
        this.endVisit((ASTNode)compoundAssignment);
    }

    public void endVisit(ConditionalExpression conditionalExpression, BlockScope scope) {
        this.endVisit((ASTNode)conditionalExpression);
    }

    public void endVisit(EqualExpression equalExpression, BlockScope scope) {
        this.endVisit((ASTNode)equalExpression);
    }

    public void endVisit(ExplicitConstructorCall explicitConstructor, BlockScope scope) {
        this.endVisit((ASTNode)explicitConstructor);
    }

    public void endVisit(FieldReference fieldReference, BlockScope scope) {
        this.endVisit((ASTNode)fieldReference);
    }

    public void endVisit(GuardedPattern guardedPattern, BlockScope scope) {
        this.endVisit((ASTNode)guardedPattern);
    }

    public void endVisit(IfStatement ifStatement, BlockScope scope) {
        this.interestingEnclosings.pop();
    }

    public void endVisit(InstanceOfExpression instanceOfExpression, BlockScope scope) {
        this.endVisit((ASTNode)instanceOfExpression);
    }

    public void endVisit(LocalDeclaration localDeclaration, BlockScope scope) {
        this.endVisit((ASTNode)localDeclaration);
    }

    public void endVisit(MessageSend messageSend, BlockScope scope) {
        this.endVisit((ASTNode)messageSend);
    }

    public void endVisit(OR_OR_Expression or_or_Expression, BlockScope scope) {
        this.endVisit((ASTNode)or_or_Expression);
    }

    public void endVisit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, BlockScope scope) {
        this.endVisit((ASTNode)parameterizedQualifiedTypeReference);
    }

    public void endVisit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, ClassScope scope) {
        this.endVisit((ASTNode)parameterizedQualifiedTypeReference);
    }

    public void endVisit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope scope) {
        this.endVisit((ASTNode)parameterizedSingleTypeReference);
    }

    public void endVisit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, ClassScope scope) {
        this.endVisit((ASTNode)parameterizedSingleTypeReference);
    }

    public void endVisit(PostfixExpression postfixExpression, BlockScope scope) {
        this.endVisit((ASTNode)postfixExpression);
    }

    public void endVisit(PrefixExpression prefixExpression, BlockScope scope) {
        this.endVisit((ASTNode)prefixExpression);
    }

    public void endVisit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope scope) {
        this.endVisit((ASTNode)qualifiedAllocationExpression);
    }

    public void endVisit(QualifiedNameReference qualifiedNameReference, BlockScope scope) {
        this.endVisit((ASTNode)qualifiedNameReference);
    }

    public void endVisit(QualifiedSuperReference qualifiedSuperReference, BlockScope scope) {
        this.endVisit((ASTNode)qualifiedSuperReference);
    }

    public void endVisit(QualifiedThisReference qualifiedThisReference, BlockScope scope) {
        this.endVisit((ASTNode)qualifiedThisReference);
    }

    public void endVisit(QualifiedTypeReference qualifiedTypeReference, BlockScope scope) {
        this.endVisit((ASTNode)qualifiedTypeReference);
    }

    public void endVisit(QualifiedTypeReference qualifiedTypeReference, ClassScope scope) {
        this.endVisit((ASTNode)qualifiedTypeReference);
    }

    public void endVisit(ReferenceExpression referenceExpression, BlockScope blockScope) {
        this.endVisit((ASTNode)referenceExpression);
    }

    public void endVisit(ReturnStatement returnStatement, BlockScope scope) {
        this.endVisit((ASTNode)returnStatement);
    }

    public void endVisit(SingleNameReference singleNameReference, BlockScope scope) {
        this.endVisit((ASTNode)singleNameReference);
    }

    public void endVisit(SingleTypeReference singleTypeReference, BlockScope scope) {
        this.endVisit((ASTNode)singleTypeReference);
    }

    public void endVisit(SingleTypeReference singleTypeReference, ClassScope scope) {
        this.endVisit((ASTNode)singleTypeReference);
    }

    public void endVisit(SuperReference superReference, BlockScope scope) {
        this.endVisit((ASTNode)superReference);
    }

    public void endVisit(SwitchStatement switchStatement, BlockScope scope) {
        this.endVisit((ASTNode)switchStatement);
    }

    public void endVisit(ThisReference thisReference, BlockScope scope) {
        this.endVisit((ASTNode)thisReference);
    }

    public void endVisit(UnaryExpression unaryExpression, BlockScope scope) {
        this.endVisit((ASTNode)unaryExpression);
    }

    public void endVisit(MemberValuePair pair, BlockScope scope) {
        this.endVisit((ASTNode)pair);
    }

    public void endVisit(MemberValuePair pair, CompilationUnitScope scope) {
        this.endVisit((ASTNode)pair);
    }

    public void endVisit(LambdaExpression lambda, BlockScope scope) {
        this.endVisit((ASTNode)lambda);
    }

    public void endVisit(MethodDeclaration methodDeclaration, ClassScope scope) {
        if (this.result) {
            throw new StopTraversal();
        }
    }

    public void endVisit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        if (this.result) {
            throw new StopTraversal();
        }
    }

    public boolean visit(AllocationExpression allocationExpression, BlockScope scope) {
        return this.visit((ASTNode)allocationExpression);
    }

    public boolean visit(AND_AND_Expression and_and_Expression, BlockScope scope) {
        this.interestingEnclosings.add((ASTNode)and_and_Expression);
        return this.visit((ASTNode)and_and_Expression);
    }

    public boolean visit(ArrayAllocationExpression arrayAllocationExpression, BlockScope scope) {
        return this.visit((ASTNode)arrayAllocationExpression);
    }

    public boolean visit(ArrayInitializer arrayInitializer, BlockScope scope) {
        return this.visit((ASTNode)arrayInitializer);
    }

    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope scope) {
        return this.visit((ASTNode)arrayQualifiedTypeReference);
    }

    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope scope) {
        return this.visit((ASTNode)arrayQualifiedTypeReference);
    }

    public boolean visit(ArrayReference arrayReference, BlockScope scope) {
        return this.visit((ASTNode)arrayReference);
    }

    public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope scope) {
        return this.visit((ASTNode)arrayTypeReference);
    }

    public boolean visit(ArrayTypeReference arrayTypeReference, ClassScope scope) {
        return this.visit((ASTNode)arrayTypeReference);
    }

    public boolean visit(Assignment assignment, BlockScope scope) {
        return this.visit((ASTNode)assignment);
    }

    public boolean visit(BinaryExpression binaryExpression, BlockScope scope) {
        return this.visit((ASTNode)binaryExpression);
    }

    public boolean visit(CastExpression castExpression, BlockScope scope) {
        return this.visit((ASTNode)castExpression);
    }

    public boolean visit(CompoundAssignment compoundAssignment, BlockScope scope) {
        return this.visit((ASTNode)compoundAssignment);
    }

    public boolean visit(ConditionalExpression conditionalExpression, BlockScope scope) {
        return this.visit((ASTNode)conditionalExpression);
    }

    public boolean visit(EqualExpression equalExpression, BlockScope scope) {
        return this.visit((ASTNode)equalExpression);
    }

    public boolean visit(ExplicitConstructorCall explicitConstructor, BlockScope scope) {
        return this.visit((ASTNode)explicitConstructor);
    }

    public boolean visit(FieldReference fieldReference, BlockScope scope) {
        return this.visit((ASTNode)fieldReference);
    }

    public boolean visit(GuardedPattern guardedPattern, BlockScope scope) {
        return this.visit((ASTNode)guardedPattern);
    }

    public boolean visit(IfStatement ifStatement, BlockScope scope) {
        this.interestingEnclosings.push((ASTNode)ifStatement);
        return true;
    }

    public boolean visit(InstanceOfExpression instanceOfExpression, BlockScope scope) {
        return this.visit((ASTNode)instanceOfExpression);
    }

    public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
        return this.visit((ASTNode)localDeclaration);
    }

    public boolean visit(MessageSend messageSend, BlockScope scope) {
        return this.visit((ASTNode)messageSend);
    }

    public boolean visit(OR_OR_Expression or_or_Expression, BlockScope scope) {
        return this.visit((ASTNode)or_or_Expression);
    }

    public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, BlockScope scope) {
        return this.visit((ASTNode)parameterizedQualifiedTypeReference);
    }

    public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, ClassScope scope) {
        return this.visit((ASTNode)parameterizedQualifiedTypeReference);
    }

    public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope scope) {
        return this.visit((ASTNode)parameterizedSingleTypeReference);
    }

    public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, ClassScope scope) {
        return this.visit((ASTNode)parameterizedSingleTypeReference);
    }

    public boolean visit(PostfixExpression postfixExpression, BlockScope scope) {
        return this.visit((ASTNode)postfixExpression);
    }

    public boolean visit(PrefixExpression prefixExpression, BlockScope scope) {
        return this.visit((ASTNode)prefixExpression);
    }

    public boolean visit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope scope) {
        return this.visit((ASTNode)qualifiedAllocationExpression);
    }

    public boolean visit(QualifiedNameReference qualifiedNameReference, BlockScope scope) {
        return this.visit((ASTNode)qualifiedNameReference);
    }

    public boolean visit(QualifiedSuperReference qualifiedSuperReference, BlockScope scope) {
        return this.visit((ASTNode)qualifiedSuperReference);
    }

    public boolean visit(QualifiedThisReference qualifiedThisReference, BlockScope scope) {
        return this.visit((ASTNode)qualifiedThisReference);
    }

    public boolean visit(QualifiedTypeReference qualifiedTypeReference, BlockScope scope) {
        return this.visit((ASTNode)qualifiedTypeReference);
    }

    public boolean visit(QualifiedTypeReference qualifiedTypeReference, ClassScope scope) {
        return this.visit((ASTNode)qualifiedTypeReference);
    }

    public boolean visit(ReferenceExpression referenceExpression, BlockScope blockScope) {
        return this.visit((ASTNode)referenceExpression);
    }

    public boolean visit(ReturnStatement returnStatement, BlockScope scope) {
        return this.visit((ASTNode)returnStatement);
    }

    public boolean visit(SingleNameReference singleNameReference, BlockScope scope) {
        return this.visit((ASTNode)singleNameReference);
    }

    public boolean visit(SingleTypeReference singleTypeReference, BlockScope scope) {
        return this.visit((ASTNode)singleTypeReference);
    }

    public boolean visit(SingleTypeReference singleTypeReference, ClassScope scope) {
        return this.visit((ASTNode)singleTypeReference);
    }

    public boolean visit(StringLiteral stringLiteral, BlockScope scope) {
        return this.visit((ASTNode)stringLiteral);
    }

    public boolean visit(SuperReference superReference, BlockScope scope) {
        return this.visit((ASTNode)superReference);
    }

    public boolean visit(SwitchStatement switchStatement, BlockScope blockScope) {
        return this.visit((ASTNode)switchStatement);
    }

    public boolean visit(ThisReference thisReference, BlockScope scope) {
        return this.visit((ASTNode)thisReference);
    }

    public boolean visit(UnaryExpression unaryExpression, BlockScope scope) {
        return this.visit((ASTNode)unaryExpression);
    }

    public boolean visit(MemberValuePair pair, BlockScope scope) {
        return this.visit((ASTNode)pair);
    }

    public boolean visit(MemberValuePair pair, CompilationUnitScope scope) {
        return this.visit((ASTNode)pair);
    }

    private void endVisit(ASTNode astNode) {
        if (this.blockedNode == astNode) {
            return;
        }
        if (this.result) {
            if (!(this.parent != null && (!(this.parent instanceof ArrayInitializer) || !(astNode instanceof Statement)) || astNode == this.searchedNode || astNode instanceof AllocationExpression && ((AllocationExpression)astNode).type == this.searchedNode || astNode instanceof ConditionalExpression && ((ConditionalExpression)astNode).valueIfTrue == this.searchedNode || astNode instanceof ConditionalExpression && ((ConditionalExpression)astNode).valueIfFalse == this.searchedNode)) {
                this.parent = astNode;
            }
            this.checkUpdateOuter(astNode);
        }
    }

    protected void checkUpdateOuter(ASTNode astNode) {
        if (this.containsPotentialPolyExpression && astNode instanceof Expression) {
            this.outerExpression = (Expression)astNode;
        } else {
            this.containsPotentialPolyExpression |= this.isPotentiallyPolyExpression(astNode);
        }
        if (!this.interestingEnclosings.isEmpty()) {
            ASTNode enclosing = this.interestingEnclosings.peek();
            Expression rightOfEnclosing = null;
            if (enclosing instanceof AND_AND_Expression) {
                rightOfEnclosing = ((AND_AND_Expression)enclosing).right;
            } else if (enclosing instanceof IfStatement) {
                rightOfEnclosing = ((IfStatement)enclosing).thenStatement;
            }
            if (rightOfEnclosing == astNode || rightOfEnclosing == this.enclosingNode) {
                this.enclosingNode = enclosing;
                return;
            }
        }
        if (astNode instanceof ReturnStatement || astNode instanceof AbstractVariableDeclaration) {
            this.enclosingNode = astNode;
            throw new StopTraversal();
        }
    }

    private boolean isPotentiallyPolyExpression(ASTNode node) {
        return node instanceof Invocation || node instanceof FunctionalExpression || node instanceof ConditionalExpression;
    }

    private boolean visit(ASTNode astNode) {
        if (this.result) {
            this.blockedNode = astNode;
        }
        if (astNode == this.searchedNode) {
            this.result = true;
        }
        return !this.result;
    }

    static class FindAny
    extends GenericAstVisitor {
        private ASTNode searchFor;
        boolean found;

        public FindAny(ASTNode searchFor) {
            this.searchFor = searchFor;
        }

        protected boolean visitNode(ASTNode node) {
            if (node == this.searchFor) {
                this.found = true;
            }
            return !this.found;
        }
    }

    static class StopTraversal
    extends RuntimeException {
        StopTraversal() {
        }
    }
}

