/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.part.job;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.impl.dialogs.MissingMobileDriverWarningDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.handlers.CheckingTestOpsUsageHandler;
import com.kms.katalon.composer.execution.launcher.IDETestSuiteCollectionLauncher;
import com.kms.katalon.composer.execution.launcher.SubIDELauncher;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.entity.DefaultReportSetting;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.Reportable;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.util.MailUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TestSuiteCollectionBuilderJob
extends Job {
    private TestSuiteCollectionEntity testSuiteCollectionEntity;

    public TestSuiteCollectionBuilderJob(TestSuiteCollectionEntity testSuiteCollectionEntity) {
        super(ComposerTestsuiteCollectionMessageConstants.JOB_TITLE_TEST_SUITE_COLLECTION_BUILDER);
        this.testSuiteCollectionEntity = testSuiteCollectionEntity;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (ApplicationInfo.isPlatformStudio()) {
            try {
                new CheckingTestOpsUsageHandler().execute(null, allowed -> {
                    if (!allowed) {
                        return;
                    }
                    this.safeProcessToRun(monitor);
                });
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return Status.CANCEL_STATUS;
            }
        } else {
            return this.safeProcessToRun(monitor);
        }
        return Status.OK_STATUS;
    }

    protected IStatus safeProcessToRun(IProgressMonitor monitor) {
        try {
            int totalSize = this.testSuiteCollectionEntity.getTestSuiteRunConfigurations().size() + 1;
            monitor.beginTask(ComposerTestsuiteCollectionMessageConstants.JOB_TASK_BUILDING_TEST_SUITE_COLLECTION, totalSize);
            TestSuiteCollectionExecutedEntity executedEntity = new TestSuiteCollectionExecutedEntity(this.testSuiteCollectionEntity);
            executedEntity.setReportable((Reportable)new DefaultReportSetting());
            ProjectEntity project = this.testSuiteCollectionEntity.getProject();
            ReportController reportController = ReportController.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String executionSessionId = dateFormat.format(new Date());
            ReportCollectionEntity reportCollection = reportController.newReportCollection(project, this.testSuiteCollectionEntity, executionSessionId, executedEntity.getId());
            ArrayList<SubIDELauncher> tsLaunchers = new ArrayList<SubIDELauncher>();
            boolean cancelInstallWebDriver = false;
            Map variables = EmailVariableBinding.getVariablesForTestSuiteCollectionEmailSettings((TestSuiteCollectionEntity)this.testSuiteCollectionEntity);
            MailUtil.overrideEmailSettings((EmailConfig)executedEntity.getEmailConfig(project), (ExecutionProfileEntity)GlobalVariableController.getInstance().getDefaultExecutionProfile(project), (Map)variables);
            for (TestSuiteRunConfiguration tsRunConfig : this.testSuiteCollectionEntity.getTestSuiteRunConfigurations()) {
                if (!cancelInstallWebDriver) {
                    cancelInstallWebDriver = !this.checkInstallWebDriver(tsRunConfig);
                }
                monitor.subTask(MessageFormat.format(ComposerTestsuiteCollectionMessageConstants.JOB_TASK_BUILDING_LAUNCHER, tsRunConfig.getTestSuiteEntity().getIdForDisplay()));
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (!tsRunConfig.isRunEnabled()) continue;
                String tscId = ExecutionUtil.getTestSuiteCollectionId((String)this.testSuiteCollectionEntity.getId());
                SubIDELauncher subLauncher = this.buildLauncher(tsRunConfig, reportCollection, executionSessionId, tscId);
                if (subLauncher == null) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                TestSuiteExecutedEntity tsExecutedEntity = (TestSuiteExecutedEntity)subLauncher.getRunConfig().getExecutionSetting().getExecutedEntity();
                if (tsExecutedEntity.getTotalTestCases() == 0) {
                    this.openWarningDialogForEmptyTestSuite(tsExecutedEntity);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                Map tsVariables = EmailVariableBinding.getVariablesForTestSuiteEmailSettings((TestSuiteEntity)((TestSuiteEntity)tsExecutedEntity.getEntity()));
                MailUtil.overrideEmailSettings((EmailConfig)tsExecutedEntity.getEmailConfig(project), (ExecutionProfileEntity)subLauncher.getRunConfig().getExecutionProfile(), (Map)tsVariables);
                executedEntity.addTestSuiteExecutedEntity(tsExecutedEntity);
                tsLaunchers.add(subLauncher);
            }
            LauncherManager launcherManager = LauncherManager.getInstance();
            IDETestSuiteCollectionLauncher launcher = new IDETestSuiteCollectionLauncher(executedEntity, launcherManager, tsLaunchers, this.testSuiteCollectionEntity.getExecutionMode(), reportCollection);
            launcherManager.addLauncher((ILauncher)launcher);
            reportController.updateReportCollection(reportCollection);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (ControllerException | DALException e) {
            LoggerSingleton.logError((Throwable)e);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private boolean checkInstallWebDriver(TestSuiteRunConfiguration tsRunConfig) {
        return true;
    }

    private void openWarningDialogForEmptyTestSuite(final TestSuiteExecutedEntity tsExecutedEntity) {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)GlobalStringConstants.WARN, (String)MessageFormat.format(ComposerTestsuiteCollectionMessageConstants.JOB_MSG_EMPTY_TEST_SUITE, tsExecutedEntity.getSourceId()));
            }
        });
    }

    private SubIDELauncher buildLauncher(final TestSuiteRunConfiguration tsRunConfig, ReportCollectionEntity reportCollection, String executionSessionId, String testSuiteCollectionId) {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        try {
            RunConfigurationDescription configuration = tsRunConfig.getConfiguration();
            IRunConfiguration runConfig = RunConfigurationCollector.getInstance().getRunConfiguration(configuration.getRunConfigurationId(), projectDir, configuration);
            TestSuiteEntity testSuiteEntity = tsRunConfig.getTestSuiteEntity();
            TestSuiteExecutedEntity executedEntity = new TestSuiteExecutedEntity(testSuiteEntity);
            executedEntity.setInCollection(true);
            executedEntity.setTestSuiteCollectionId(testSuiteCollectionId);
            executedEntity.prepareTestCases();
            runConfig.setExecutionSessionId(executionSessionId);
            runConfig.build((FileEntity)testSuiteEntity, (IExecutedEntity)executedEntity);
            SubIDELauncher launcher = new SubIDELauncher(runConfig, LaunchMode.RUN, configuration);
            RunConfigurationDescription clonedConfiguration = (RunConfigurationDescription)configuration.clone();
            clonedConfiguration = this.removeSensitiveDataFromTestCloud(clonedConfiguration);
            reportCollection.getReportItemDescriptions().add(ReportItemDescription.from((String)launcher.getReportEntity().getIdForDisplay(), (RunConfigurationDescription)clonedConfiguration));
            return launcher;
        }
        catch (MobileSetupException e) {
            UISynchronizeService.syncExec(() -> MissingMobileDriverWarningDialog.showWarning((Shell)Display.getCurrent().getActiveShell(), (String)e.getMessage()));
            return null;
        }
        catch (Exception e) {
            UISynchronizeService.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)MessageFormat.format(ComposerTestsuiteCollectionMessageConstants.JOB_MSG_UNABLE_TO_EXECUTE_TEST_SUITE, tsRunConfig.getTestSuiteEntity().getIdForDisplay()), (String)e.getMessage());
                }
            });
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    private RunConfigurationDescription removeSensitiveDataFromTestCloud(RunConfigurationDescription configuration) {
        if (TestCloudPropertyUtil.getInstance().isRunFromTestCloud()) {
            TestCloudPropertyUtil.getInstance().hideConfigurationData(configuration.getRunConfigurationData());
        }
        return configuration;
    }
}

