/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.groovy.util;

import com.kms.katalon.core.keyword.internal.IKeywordContributor;
import com.kms.katalon.core.keyword.internal.KeywordContributorCollection;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.constant.GroovyConstants;
import com.kms.katalon.groovy.helper.ClasspathHelper;
import com.kms.katalon.selenium.TempClass;
import groovy.lang.GroovyClassLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.internal.resources.ModelObjectWriter;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathAttribute;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class GroovyUtil {
    private static final String COMMA_DELIMITER = ",";
    private static final String EXCLUDED_JAR_FILES = "excludedJarFiles";
    private static final String COMPOSER_EXECUTION_BUNDLE_ID = "com.kms.katalon.composer.execution.settings";
    private static final String OUTPUT_FOLDER_NAME = "bin";
    private static final String TEST_CASE_OUTPUT_FOLDER_NAME = "testcase";
    private static final String KEYWORD_OUTPUT_FOLDER_NAME = "keyword";
    private static final String KEYWORD_SOURCE_FOLDER_NAME = "Keywords";
    private static final String TEST_SCRIPT_SOURCE_FOLDER_NAME = "Scripts";
    private static final String TEST_CASE_ROOT_FOLDER_NAME = "Test Cases";
    private static final String TEST_LISTENERS_ROOT_FOLDER_NAME = "Test Listeners";
    private static final String TEST_SUITES_ROOT_FOLDER_NAME = "Test Suites";
    private static final String STEP_DEFINITIONS_ROOT_FOLDER_NAME = "Include/scripts/groovy";
    private static final String OBJECT_REPOSITORY_ROOT_FOLDER_NAME = "Object Repository";
    private static final String GLOBAL_VARIABLE_ROOT_FOLDER_NAME = "Profiles";
    private static final String GROOVY_NATURE = "org.eclipse.jdt.groovy.core.groovyNature";
    private static final String KEYWORD_LIB_FOLDER_NAME = "Libs";
    private static final String KEYWORD_LIB_OUTPUT_FOLDER_NAME = "lib";
    private static final String INCLUDE_OUTPUT_FOLDER_NAME = "groovy";
    private static final String LISTENER_OUTPUT_FOLDER_NAME = "listener";
    private static final String DRIVERS_FOLDER_NAME = "Drivers";
    public static final String PLUGINS_FOLDER_NAME = "Plugins";
    private static final String JDT_LAUNCHING = "org.eclipse.jdt.launching.JRE_CONTAINER";
    private static final String[] KAT_PROJECT_NATURES = new String[]{"org.eclipse.jdt.groovy.core.groovyNature", "org.eclipse.jdt.core.javanature"};
    private static final String RESOURCE_REGEX_FILTER = "org.eclipse.core.resources.regexFilterMatcher";
    private static final String RESOURCE_FILE_NAME_REGEX = "(.*\\.svn-base$)|(.*\\.png$)|(.*\\.log$)|(.*\\.xlsx$)|(.*\\.xls$)|(.*\\.csv$)|(.*\\.txt$)";
    private static final String RESOURCE_FOLDER_NAME_REGEX = ".*\\.svn$";
    private static final String API_SOURCE_EXTENSION = "-sources.jar";
    private static final String GROOVY_FILE_EXTENSION = "groovy";
    private static Map<String, URLClassLoader> classLoaderLookup = new HashMap<String, URLClassLoader>();

    public static IProject getGroovyProject(ProjectEntity projectEntity) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(GroovyUtil.getProjectNameIdFromLocation(projectEntity.getLocation()));
    }

    private static String getProjectNameIdFromLocation(String location) {
        return location.replace(File.separator, "%").replace(":", "%");
    }

    public static IPackageFragment getPackageFragmentFromLocation(String pkgRelativeLocationToProject, boolean isDefaultPackage, ProjectEntity projectEntity) throws CoreException {
        IFolder packageFolder = GroovyUtil.getGroovyProject(projectEntity).getFolder(pkgRelativeLocationToProject);
        packageFolder.refreshLocal(2, null);
        if (packageFolder != null && packageFolder.exists()) {
            IJavaElement javaElement = JavaCore.create((IFolder)packageFolder);
            if (javaElement instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                if (!packageFragment.isOpen()) {
                    packageFragment.open(null);
                }
                return packageFragment;
            }
            if (javaElement instanceof IPackageFragmentRoot && isDefaultPackage) {
                return ((IPackageFragmentRoot)javaElement).getPackageFragment("");
            }
        }
        return null;
    }

    public static void initGroovyProject(ProjectEntity projectEntity, List<File> customKeywordPluginFiles, boolean allowSourceAttachment, IProgressMonitor monitor) throws CoreException, IOException, BundleException {
        SubProgressMonitor subProgressDescription = null;
        if (monitor != null) {
            monitor.beginTask("Initializing project's classpath...", 10);
            subProgressDescription = new SubProgressMonitor(monitor, 1, 4);
            new SubProgressMonitor(monitor, 9, 4);
        }
        GroovyUtil.initGroovyProjectDescription(projectEntity, subProgressDescription);
        GroovyUtil.emptyProjectClasspath(projectEntity);
    }

    public static void emptyProjectClasspath(ProjectEntity projectEntity) throws CoreException {
        GroovyUtil.removeUnusedBinFolder(projectEntity);
        IProject groovyProject = GroovyUtil.getGroovyProject(projectEntity);
        groovyProject.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        IFolder outputParentFolder = groovyProject.getFolder(OUTPUT_FOLDER_NAME);
        if (!outputParentFolder.exists()) {
            outputParentFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IJavaProject javaProject = JavaCore.create((IProject)GroovyUtil.getGroovyProject(projectEntity));
        javaProject.setOutputLocation(outputParentFolder.getFullPath(), (IProgressMonitor)new NullProgressMonitor());
        IClasspathEntry[] entries = new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)new Path(JDT_LAUNCHING))};
        javaProject.setRawClasspath(entries, (IProgressMonitor)new NullProgressMonitor());
        GroovyRuntime.addGroovyClasspathContainer((IJavaProject)javaProject);
    }

    public static void initGroovyProjectClassPath(ProjectEntity projectEntity, List<File> pluginFiles, boolean isNew, boolean allowSourceAttachment, IProgressMonitor monitor) throws CoreException, IOException, BundleException {
        IFolder outputTestCaseFolder;
        IFolder outputKeywordFolder;
        IFolder outputListenerFolder;
        IFolder outputParentFolder;
        IFolder pluginsFolder;
        IFolder driversFolder;
        IFolder keywordLibFolder;
        IFolder testCaseSourceFolder;
        IFolder keywordSourceFolder;
        IProject groovyProject = GroovyUtil.getGroovyProject(projectEntity);
        groovyProject.clearHistory((IProgressMonitor)new NullProgressMonitor());
        groovyProject.refreshLocal(1, monitor);
        IFolder listenerSourceFolder = groovyProject.getFolder(TEST_LISTENERS_ROOT_FOLDER_NAME);
        if (!listenerSourceFolder.exists()) {
            listenerSourceFolder.create(true, true, null);
        }
        if (!(keywordSourceFolder = groovyProject.getFolder(KEYWORD_SOURCE_FOLDER_NAME)).exists()) {
            keywordSourceFolder.create(true, true, null);
        }
        if (!(testCaseSourceFolder = groovyProject.getFolder(TEST_SCRIPT_SOURCE_FOLDER_NAME)).exists()) {
            testCaseSourceFolder.create(true, true, null);
        }
        if (!(keywordLibFolder = groovyProject.getFolder(KEYWORD_LIB_FOLDER_NAME)).exists()) {
            keywordLibFolder.create(true, true, null);
        } else if (isNew) {
            keywordLibFolder.clearHistory(null);
        }
        IFolder sourceMainGroovy = groovyProject.getFolder(STEP_DEFINITIONS_ROOT_FOLDER_NAME);
        if (!sourceMainGroovy.exists()) {
            File sourceMainGroovyFolder = new File(sourceMainGroovy.getRawLocationURI());
            sourceMainGroovyFolder.mkdirs();
            sourceMainGroovy.refreshLocal(2, null);
        }
        if (!(driversFolder = groovyProject.getFolder(DRIVERS_FOLDER_NAME)).exists()) {
            driversFolder.create(true, true, null);
        }
        if (!(pluginsFolder = groovyProject.getFolder(PLUGINS_FOLDER_NAME)).exists()) {
            pluginsFolder.create(true, true, null);
        }
        if (!(outputParentFolder = groovyProject.getFolder(OUTPUT_FOLDER_NAME)).exists()) {
            outputParentFolder.create(true, true, null);
        }
        if (!(outputListenerFolder = outputParentFolder.getFolder(LISTENER_OUTPUT_FOLDER_NAME)).exists()) {
            outputListenerFolder.create(true, true, null);
        }
        if (!(outputKeywordFolder = outputParentFolder.getFolder(KEYWORD_OUTPUT_FOLDER_NAME)).exists()) {
            outputKeywordFolder.create(true, true, null);
        }
        if (!(outputTestCaseFolder = outputParentFolder.getFolder(TEST_CASE_OUTPUT_FOLDER_NAME)).exists()) {
            outputTestCaseFolder.create(true, true, null);
        } else if (isNew) {
            outputTestCaseFolder.clearHistory(null);
        }
        IFolder outputKWLibFolder = outputParentFolder.getFolder(KEYWORD_LIB_OUTPUT_FOLDER_NAME);
        if (!outputKWLibFolder.exists()) {
            outputKWLibFolder.create(true, true, null);
        } else if (isNew) {
            outputKWLibFolder.clearHistory(null);
        }
        IFolder outputSourceMainGroovy = outputParentFolder.getFolder("groovy");
        File outputSourceMainGroovyFolder = new File(outputSourceMainGroovy.getRawLocationURI());
        outputSourceMainGroovyFolder.mkdirs();
        outputSourceMainGroovy.refreshLocal(2, null);
        IJavaProject javaProject = JavaCore.create((IProject)groovyProject);
        javaProject.setOutputLocation(outputParentFolder.getFullPath(), null);
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        entries.add(JavaCore.newContainerEntry((IPath)new Path(JDT_LAUNCHING)));
        IPackageFragmentRoot keywordPackageRoot = javaProject.getPackageFragmentRoot((IResource)keywordSourceFolder);
        entries.add(JavaCore.newSourceEntry((IPath)keywordPackageRoot.getPath(), (IPath[])new Path[0], (IPath[])new Path[0], (IPath)outputKeywordFolder.getFullPath()));
        IPackageFragmentRoot listenerPackageRoot = javaProject.getPackageFragmentRoot((IResource)listenerSourceFolder);
        entries.add(JavaCore.newSourceEntry((IPath)listenerPackageRoot.getPath(), (IPath[])new Path[0], (IPath[])new Path[0], (IPath)outputListenerFolder.getFullPath()));
        IPackageFragmentRoot keywordLibPackageRoot = javaProject.getPackageFragmentRoot((IResource)keywordLibFolder);
        entries.add(JavaCore.newSourceEntry((IPath)keywordLibPackageRoot.getPath(), (IPath[])new Path[0], (IPath[])new Path[0], (IPath)outputKWLibFolder.getFullPath()));
        IPackageFragmentRoot sourceMainGroovyPackageRoot = javaProject.getPackageFragmentRoot((IResource)sourceMainGroovy);
        entries.add(JavaCore.newSourceEntry((IPath)sourceMainGroovyPackageRoot.getPath(), (IPath[])new Path[0], (IPath[])new Path[0], (IPath)outputSourceMainGroovy.getFullPath()));
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, allowSourceAttachment);
        GroovyUtil.removeUserDefinedJarsFromClassPath(projectEntity, entries);
        File driversDir = driversFolder.getRawLocation().toFile();
        ArrayList<File> allJarFiles = new ArrayList<File>();
        allJarFiles.addAll(Arrays.asList(driversDir.listFiles()));
        allJarFiles.addAll(pluginFiles);
        for (File jarFile : allJarFiles) {
            IClasspathEntry oldEntry = null;
            if (!jarFile.isFile() || !jarFile.getName().endsWith(".jar")) continue;
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 1 && e.getPath().toFile().getAbsolutePath().equals(jarFile.getAbsolutePath())) {
                    oldEntry = e;
                    break;
                }
                ++n2;
            }
            if (oldEntry != null) {
                GroovyUtil.addJarFileToClasspath(jarFile, oldEntry, entries);
                continue;
            }
            GroovyUtil.addJarFileToClasspath(jarFile, entries);
        }
        javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), monitor);
        GroovyRuntime.addGroovyClasspathContainer((IJavaProject)javaProject);
        GroovyUtil.removeUnusedBinFolder(projectEntity);
    }

    private static void removeUserDefinedJarsFromClassPath(ProjectEntity projectEntity, List<IClasspathEntry> entries) throws IOException {
        List<String> excludedJarFileNames = GroovyUtil.getExcludedJarFileNames(projectEntity);
        for (String excludedJarFileName : excludedJarFileNames) {
            entries.removeIf(entry -> {
                String entryFileName = entry.getPath().toFile().getName();
                return entryFileName.equals(excludedJarFileName);
            });
        }
    }

    public static List<String> getExcludedJarFileNames(ProjectEntity projectEntity) throws IOException {
        BundleSettingStore store = new BundleSettingStore(projectEntity.getFolderLocation(), COMPOSER_EXECUTION_BUNDLE_ID, true);
        List<String> excludedJarFiles = Arrays.asList(store.getString(EXCLUDED_JAR_FILES, "").split(COMMA_DELIMITER));
        return excludedJarFiles;
    }

    private static void removeUnusedBinFolder(ProjectEntity projectEntity) {
        File binFolder = new File(projectEntity.getFolderLocation(), OUTPUT_FOLDER_NAME);
        List<String> binFolerNames = Arrays.asList(TEST_CASE_OUTPUT_FOLDER_NAME, KEYWORD_LIB_OUTPUT_FOLDER_NAME, KEYWORD_OUTPUT_FOLDER_NAME, LISTENER_OUTPUT_FOLDER_NAME, "groovy");
        if (binFolder.exists() && binFolder.listFiles() != null) {
            File[] fileArray = binFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File binFile = fileArray[n2];
                String fileName = binFile.getName();
                if (!binFile.isDirectory() || !binFolerNames.contains(fileName)) {
                    FileUtils.deleteQuietly((File)binFile);
                }
                ++n2;
            }
        }
    }

    private static void addClassPathOfCoreBundleToJavaProject(List<IClasspathEntry> entries, boolean allowSourceAttachment) throws IOException, BundleException {
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"com.kms.katalon.core"), allowSourceAttachment);
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, FrameworkUtil.getBundle(TempClass.class), allowSourceAttachment);
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"com.kms.katalon.core.appium"), allowSourceAttachment);
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"com.kms.katalon.constant"), allowSourceAttachment);
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"com.kms.katalon.util"), allowSourceAttachment);
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"org.eclipse.equinox.common"), allowSourceAttachment);
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"com.kms.katalon.netlightbody"), allowSourceAttachment);
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"com.kms.katalon.poi"), allowSourceAttachment);
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"com.kms.katalon.proxyvole"), allowSourceAttachment);
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"javassist"), allowSourceAttachment);
        GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"com.kms.katalon.groovy-extended"), allowSourceAttachment);
        if (GroovyUtil.isStartFromEclipseIDE()) {
            GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"com.kms.katalon.entity"), allowSourceAttachment);
            GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, Platform.getBundle((String)"org.eclipse.core.commands"), allowSourceAttachment);
        }
        for (IKeywordContributor contributor : KeywordContributorCollection.getKeywordContributors()) {
            Bundle coreBundle = FrameworkUtil.getBundle(contributor.getClass());
            GroovyUtil.addClassPathOfCoreBundleToJavaProject(entries, coreBundle, allowSourceAttachment);
        }
    }

    private static boolean isStartFromEclipseIDE() throws IOException {
        Bundle coreBundle = Platform.getBundle((String)"com.kms.katalon.entity");
        File customBundleFile = FileLocator.getBundleFile((Bundle)coreBundle).getAbsoluteFile();
        if (customBundleFile == null || !customBundleFile.exists()) {
            return false;
        }
        return customBundleFile.isDirectory();
    }

    private static void addClassPathOfCoreBundleToJavaProject(List<IClasspathEntry> entries, Bundle coreBundle, boolean allowSourceAttachment) throws IOException, BundleException {
        int n;
        if (coreBundle == null) {
            return;
        }
        File customBundleFile = FileLocator.getBundleFile((Bundle)coreBundle).getAbsoluteFile();
        if (customBundleFile == null || !customBundleFile.exists()) {
            return;
        }
        if (customBundleFile.isDirectory()) {
            GroovyUtil.addSourceFolderToClassPath(customBundleFile, entries);
        } else {
            GroovyUtil.addJarFileToClasspath(customBundleFile, entries, coreBundle, allowSourceAttachment);
            File libDir = GroovyUtil.getPlatformLibDir();
            if (libDir.isDirectory()) {
                File[] fileArray = libDir.listFiles();
                n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File jarFile = fileArray[n2];
                    GroovyUtil.addJarFileToClasspath(jarFile, entries);
                    ++n2;
                }
            }
        }
        String requireBundle = (String)coreBundle.getHeaders().get("Require-Bundle");
        ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requireBundle);
        if (elements == null) {
            return;
        }
        ManifestElement[] manifestElementArray = elements;
        int n3 = elements.length;
        n = 0;
        while (n < n3) {
            File requiredBundleLocation;
            ManifestElement manifestElement = manifestElementArray[n];
            Bundle requiredBundle = Platform.getBundle((String)manifestElement.getValue());
            if (requiredBundle != null && (requiredBundleLocation = FileLocator.getBundleFile((Bundle)requiredBundle).getAbsoluteFile()) != null && requiredBundleLocation.exists()) {
                if (requiredBundleLocation.isFile()) {
                    GroovyUtil.addJarFileToClasspath(requiredBundleLocation, entries, requiredBundle, allowSourceAttachment);
                } else if (requiredBundle.getSymbolicName().contains("org.junit")) {
                    File junitJar = new File(requiredBundleLocation, "junit.jar");
                    GroovyUtil.addJarFileToClasspath(junitJar, entries, requiredBundle, allowSourceAttachment);
                }
            }
            ++n;
        }
    }

    private static File getConfigurationFolder() throws IOException {
        return new File(FileLocator.resolve((URL)Platform.getConfigurationLocation().getURL()).getFile());
    }

    private static File getPlatformResourcesDir() throws IOException {
        return new File(GroovyUtil.getConfigurationFolder(), "resources");
    }

    private static File getPlatformAPIDocDir() throws IOException {
        return new File(GroovyUtil.getPlatformResourcesDir(), "apidocs");
    }

    private static File getPlatformLibDir() throws IOException {
        return new File(GroovyUtil.getPlatformResourcesDir(), KEYWORD_LIB_OUTPUT_FOLDER_NAME);
    }

    private static File getPlatformSourceDir() throws IOException {
        return new File(GroovyUtil.getPlatformResourcesDir(), "source");
    }

    protected static void addSourceFolderToClassPath(File customBundleFile, List<IClasspathEntry> entries) {
        entries.add(JavaCore.newLibraryEntry((IPath)new Path(new File(customBundleFile, OUTPUT_FOLDER_NAME).getAbsolutePath()), (IPath)new Path(new File(customBundleFile, "src").getAbsolutePath()), null));
        File resourceFolder = new File(customBundleFile, "resources" + File.separator + KEYWORD_LIB_OUTPUT_FOLDER_NAME);
        if (resourceFolder.exists() && resourceFolder.isDirectory()) {
            File[] fileArray = resourceFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File jarFile = fileArray[n2];
                GroovyUtil.addJarFileToClasspath(jarFile, entries);
                ++n2;
            }
        }
    }

    private static void addJarFileToClasspath(File jarFile, List<IClasspathEntry> entries) {
        IClasspathEntry entry;
        if (GroovyUtil.checkRequiredBundleLocation(jarFile, entries) && (entry = JavaCore.newLibraryEntry((IPath)new Path(jarFile.getAbsolutePath()), null, null)) != null && !entries.contains(entry)) {
            entries.add(entry);
        }
    }

    private static void addJarFileToClasspath(File jarFile, IClasspathEntry oldEntry, List<IClasspathEntry> entries) {
        IClasspathEntry entry;
        if (GroovyUtil.checkRequiredBundleLocation(jarFile, entries) && (entry = JavaCore.newLibraryEntry((IPath)new Path(jarFile.getAbsolutePath()), (IPath)oldEntry.getSourceAttachmentPath(), (IPath)oldEntry.getSourceAttachmentRootPath(), (IAccessRule[])oldEntry.getAccessRules(), (IClasspathAttribute[])oldEntry.getExtraAttributes(), (boolean)oldEntry.isExported())) != null && !entries.contains(entry)) {
            entries.add(entry);
        }
    }

    private static void addJarFileToClasspath(File jarFile, List<IClasspathEntry> entries, Bundle bundle, boolean allowSourceAttachment) throws IOException {
        if (GroovyUtil.checkRequiredBundleLocation(jarFile, entries)) {
            IClasspathEntry entry;
            File javaDocDir = new File(GroovyUtil.getPlatformAPIDocDir(), bundle.getSymbolicName());
            String javadocLoc = javaDocDir.toURI().toString();
            IClasspathAttribute[] attributes = null;
            if (FileLocator.getBundleFile((Bundle)bundle).isFile() && javaDocDir.isDirectory() && javaDocDir.exists()) {
                attributes = new IClasspathAttribute[]{new ClasspathAttribute("javadoc_location", javadocLoc)};
            }
            File javaSourceDir = new File(GroovyUtil.getPlatformSourceDir(), bundle.getSymbolicName());
            Path sourcePath = null;
            if (FileLocator.getBundleFile((Bundle)bundle).isFile() && javaSourceDir.isDirectory() && javaSourceDir.exists() && bundle.getSymbolicName().startsWith("com.kms.katalon.core") && allowSourceAttachment) {
                javaSourceDir = new File(javaSourceDir, String.valueOf(bundle.getSymbolicName()) + API_SOURCE_EXTENSION);
                sourcePath = new Path(javaSourceDir.getAbsolutePath());
            }
            if ((entry = JavaCore.newLibraryEntry((IPath)new Path(jarFile.getAbsolutePath()), sourcePath, null, null, (IClasspathAttribute[])attributes, (boolean)false)) != null && !entries.contains(entry)) {
                entries.add(entry);
            }
        }
    }

    private static boolean checkRequiredBundleLocation(File requiredBundleLocation, List<IClasspathEntry> entries) {
        String bundleName = FilenameUtils.getBaseName((String)requiredBundleLocation.getName());
        if (bundleName == null || bundleName.isEmpty()) {
            return false;
        }
        if (bundleName.contains("_") && ((bundleName = bundleName.split("_")[0]) == null || bundleName.isEmpty())) {
            return false;
        }
        if (bundleName.startsWith("org.eclipse.core")) {
            return false;
        }
        if ("org.eclipse.jdt.core".equalsIgnoreCase(bundleName)) {
            return false;
        }
        if ("com.kms.katalon.custom".equalsIgnoreCase(bundleName)) {
            return false;
        }
        for (IClasspathEntry childEntry : entries) {
            if (childEntry.getPath() == null || childEntry.getEntryKind() != 1 || !FilenameUtils.getBaseName((String)childEntry.getPath().toString()).equals(bundleName)) continue;
            return false;
        }
        return true;
    }

    private static void initGroovyProjectDescription(ProjectEntity projectEntity, IProgressMonitor monitor) throws CoreException, IOException {
        IProjectDescription projectDescription;
        IProject groovyProject = GroovyUtil.getGroovyProject(projectEntity);
        if (groovyProject == null) {
            return;
        }
        if (!groovyProject.exists()) {
            projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectEntity.getName());
            projectDescription.setLocation((IPath)new Path(projectEntity.getFolderLocation()));
            groovyProject.create(projectDescription, null);
            GroovyUtil.createFilters(groovyProject);
            groovyProject.open(128, null);
        } else if (!groovyProject.isOpen()) {
            File descriptionFile = new File(projectEntity.getFolderLocation(), ".project");
            if (!descriptionFile.exists()) {
                ProjectDescription projectDescription2 = ((Project)groovyProject).internalGetDescription();
                projectDescription2.setLocation((IPath)new Path(projectEntity.getFolderLocation()));
                projectDescription2.setNatureIds(KAT_PROJECT_NATURES);
                if (projectDescription2.getFilters() == null) {
                    GroovyUtil.createFilters(groovyProject);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                new ModelObjectWriter().write((Object)projectDescription2, (OutputStream)out, System.lineSeparator());
                FileUtils.writeByteArrayToFile((File)descriptionFile, (byte[])out.toByteArray(), (boolean)false);
            }
            groovyProject.open(null);
        }
        projectDescription = groovyProject.getDescription();
        projectDescription.setNatureIds(new String[]{GROOVY_NATURE, "org.eclipse.jdt.core.javanature"});
        ICommand[] commands = new ICommand[]{projectDescription.newCommand()};
        commands[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
        projectDescription.setBuildSpec(commands);
        groovyProject.setDescription(projectDescription, monitor);
        CompilerUtils.setCompilerLevel((IProject)groovyProject, (SpecifiedVersion)CompilerUtils.getWorkspaceCompilerLevel());
        groovyProject.refreshLocal(0, monitor);
    }

    public static void updateGroovyProject(ProjectEntity projectEntity, IProject oldGroovyProject) throws CoreException {
        IProjectDescription projectDescription = oldGroovyProject.getDescription();
        projectDescription.setName(GroovyUtil.getProjectNameIdFromLocation(projectEntity.getLocation()));
        oldGroovyProject.move(projectDescription, true, null);
    }

    public static boolean isKeywordFile(String filePath, ProjectEntity projectEntity) {
        return filePath.contains(GroovyUtil.getKeywordSourceRootFolder(projectEntity).getLocation().toString());
    }

    public static boolean isScriptFile(String filePath, ProjectEntity projectEntity) {
        return filePath.contains(GroovyUtil.getTestCaseScriptSourceFolder(projectEntity).getLocation().toString());
    }

    public static IFolder getKeywordSourceRootFolder(ProjectEntity projectEntity) {
        return GroovyUtil.getGroovyProject(projectEntity).getFolder(KEYWORD_SOURCE_FOLDER_NAME);
    }

    public static List<IFile> getAllCustomKeywordFiles(ProjectEntity project) throws Exception {
        IFolder srcFolder = GroovyUtil.getCustomKeywordSourceFolder(project);
        List<IFile> children = GroovyUtil.getCustomKeywordFilesInFolder(srcFolder);
        return children;
    }

    public static List<IFile> getCustomKeywordFilesInFolder(IFolder folder) throws Exception {
        ArrayList<IFile> children = new ArrayList<IFile>();
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if ("groovy".equals(file.getFileExtension())) {
                    children.add((IFile)resource);
                }
            } else if (resource instanceof IFolder) {
                children.addAll(GroovyUtil.getCustomKeywordFilesInFolder((IFolder)resource));
            }
            ++n2;
        }
        return children;
    }

    public static List<IPackageFragment> getAllPackageInFolder(ProjectEntity projectEntity, String folderPath) throws JavaModelException {
        IProject groovyProject = GroovyUtil.getGroovyProject(projectEntity);
        ArrayList<IPackageFragment> packageFragments = new ArrayList<IPackageFragment>();
        IPackageFragmentRoot root = JavaCore.create((IProject)groovyProject).getPackageFragmentRoot((IResource)groovyProject.getFolder(folderPath));
        IJavaElement[] iJavaElementArray = root.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment packageFragment;
            IJavaElement javaElement = iJavaElementArray[n2];
            if (javaElement instanceof IPackageFragment && ((packageFragment = (IPackageFragment)javaElement).getCompilationUnits().length > 0 || !packageFragment.hasSubpackages())) {
                packageFragment.getCompilationUnits();
                packageFragments.add((IPackageFragment)javaElement);
            }
            ++n2;
        }
        return packageFragments;
    }

    public static IPackageFragment getDefaultPackageForKeyword(ProjectEntity projectEntity) {
        IProject groovyProject = GroovyUtil.getGroovyProject(projectEntity);
        return JavaCore.create((IProject)groovyProject).getPackageFragmentRoot((IResource)groovyProject.getFolder(KEYWORD_SOURCE_FOLDER_NAME)).getPackageFragment("");
    }

    public static IPackageFragment getDefaultPackageForTestCase(ProjectEntity projectEntity) {
        IProject groovyProject = GroovyUtil.getGroovyProject(projectEntity);
        return JavaCore.create((IProject)groovyProject).getPackageFragmentRoot((IResource)groovyProject.getFolder(TEST_SCRIPT_SOURCE_FOLDER_NAME)).getPackageFragment("");
    }

    public static List<ICompilationUnit> getAllGroovyClasses(IPackageFragment packageFragment) throws CoreException {
        if (packageFragment == null) {
            return Collections.emptyList();
        }
        packageFragment.getResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        ArrayList<ICompilationUnit> groovyClassFiles = new ArrayList<ICompilationUnit>();
        IJavaElement[] iJavaElementArray = packageFragment.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            if (javaElement instanceof CompilationUnit) {
                groovyClassFiles.add((ICompilationUnit)((CompilationUnit)javaElement));
            }
            ++n2;
        }
        return groovyClassFiles;
    }

    public static void openGroovyProject(ProjectEntity projectEntity, List<File> customKeywordPluginFiles, boolean isEnterpriseAccount) throws CoreException, IOException, BundleException {
        GroovyUtil.initGroovyProject(projectEntity, customKeywordPluginFiles, isEnterpriseAccount, null);
        IProject groovyProject = GroovyUtil.getGroovyProject(projectEntity);
        if (groovyProject.exists() && !groovyProject.isOpen()) {
            groovyProject.open(null);
        }
    }

    public static IFolder getCustomKeywordSourceFolder(ProjectEntity project) {
        IProject groovyProject = GroovyUtil.getGroovyProject(project);
        return groovyProject.getFolder(KEYWORD_SOURCE_FOLDER_NAME);
    }

    public static IFolder getTestCaseScriptSourceFolder(ProjectEntity project) {
        IProject groovyProject = GroovyUtil.getGroovyProject(project);
        return groovyProject.getFolder(TEST_SCRIPT_SOURCE_FOLDER_NAME);
    }

    public static IFolder getTestListenerSourceFolder(ProjectEntity project) {
        IProject groovyProject = GroovyUtil.getGroovyProject(project);
        return groovyProject.getFolder(TEST_LISTENERS_ROOT_FOLDER_NAME);
    }

    public static IFolder getTestSuiteSourceFolder(ProjectEntity project) {
        IProject groovyProject = GroovyUtil.getGroovyProject(project);
        return groovyProject.getFolder(TEST_SUITES_ROOT_FOLDER_NAME);
    }

    public static IFolder getStepDefinitionSourceFolder(ProjectEntity project) {
        IProject groovyProject = GroovyUtil.getGroovyProject(project);
        return groovyProject.getFolder(STEP_DEFINITIONS_ROOT_FOLDER_NAME);
    }

    public static IFolder getObjectRepositorySourceFolder(ProjectEntity project) {
        IProject groovyProject = GroovyUtil.getGroovyProject(project);
        return groovyProject.getFolder(OBJECT_REPOSITORY_ROOT_FOLDER_NAME);
    }

    public static IFolder getTestCaseSourceFolder(ProjectEntity project) {
        IProject groovyProject = GroovyUtil.getGroovyProject(project);
        return groovyProject.getFolder(TEST_CASE_ROOT_FOLDER_NAME);
    }

    public static IFolder getGlobalVariableSourceFolder(ProjectEntity project) {
        IProject groovyProject = GroovyUtil.getGroovyProject(project);
        return groovyProject.getFolder(GLOBAL_VARIABLE_ROOT_FOLDER_NAME);
    }

    public static String getTestCaseIdByScriptPath(String scriptFilePath, ProjectEntity projectEntity) {
        String testCaseScriptFolderPath = new File(scriptFilePath).getParent();
        String projectLocation = projectEntity.getFolderLocation();
        String testCaseScriptFolderRelativePath = testCaseScriptFolderPath.substring(projectLocation.length());
        return testCaseScriptFolderRelativePath.substring(1).replaceFirst(TEST_SCRIPT_SOURCE_FOLDER_NAME, TEST_CASE_ROOT_FOLDER_NAME);
    }

    public static IFolder getCustomKeywordLibFolder(ProjectEntity project) {
        IProject groovyProject = GroovyUtil.getGroovyProject(project);
        return groovyProject.getFolder(KEYWORD_LIB_FOLDER_NAME);
    }

    public static void copyPackage(IPackageFragment packageFragment, FolderEntity targetFolder, String newName) throws JavaModelException {
        IProject groovyProject = GroovyUtil.getGroovyProject(targetFolder.getProject());
        IPackageFragmentRoot packageFragmentRoot = JavaCore.create((IProject)groovyProject).getPackageFragmentRoot((IResource)groovyProject.getFolder(KEYWORD_SOURCE_FOLDER_NAME));
        packageFragment.copy((IJavaElement)packageFragmentRoot, null, newName, false, null);
    }

    public static void copyKeyword(IFile keywordFile, IPackageFragment targetPackageFragment, String newName, String extension) throws JavaModelException {
        ICompilationUnit compilationUnit = (ICompilationUnit)JavaCore.create((IFile)keywordFile);
        compilationUnit.copy((IJavaElement)targetPackageFragment, null, newName != null ? String.valueOf(newName) + "." + extension : newName, false, null);
    }

    public static void moveKeyword(IFile keywordFile, IPackageFragment targetPackageFragment, String newName, String extension) throws JavaModelException {
        GroovyCompilationUnit compilationUnit = (GroovyCompilationUnit)JavaCore.create((IFile)keywordFile);
        compilationUnit.move((IJavaElement)targetPackageFragment, null, newName != null ? String.valueOf(newName) + "." + extension : newName, false, null);
    }

    public static String getGroovyClassName(TestCaseEntity testCase) {
        return "Script" + System.currentTimeMillis();
    }

    public static String getScriptPackageRelativePathForFolder(FolderEntity folder) {
        if (folder.getParentFolder() != null) {
            String relativeFolderLocation = folder.getParentFolder().getRelativePath();
            if (relativeFolderLocation.startsWith(TEST_CASE_ROOT_FOLDER_NAME)) {
                relativeFolderLocation = relativeFolderLocation.substring(TEST_CASE_ROOT_FOLDER_NAME.length(), relativeFolderLocation.length());
            }
            return TEST_SCRIPT_SOURCE_FOLDER_NAME + relativeFolderLocation + File.separator + folder.getName();
        }
        return TEST_SCRIPT_SOURCE_FOLDER_NAME;
    }

    public static String getScriptPackageRelativePathForTestCase(String testCaseRelativeId) {
        return TEST_SCRIPT_SOURCE_FOLDER_NAME + testCaseRelativeId.substring(TEST_CASE_ROOT_FOLDER_NAME.length(), testCaseRelativeId.length());
    }

    public static String getScriptPackageRelativePathForTestCase(TestCaseEntity testCase) {
        String relativeFolderLocation = testCase.getParentFolder().getRelativePath();
        if (relativeFolderLocation.startsWith(TEST_CASE_ROOT_FOLDER_NAME)) {
            relativeFolderLocation = relativeFolderLocation.substring(TEST_CASE_ROOT_FOLDER_NAME.length(), relativeFolderLocation.length());
        }
        relativeFolderLocation = TEST_SCRIPT_SOURCE_FOLDER_NAME + relativeFolderLocation + File.separator + testCase.getName();
        return relativeFolderLocation;
    }

    public static String getRelativePathForFolder(FolderEntity folder) {
        String relativeFolderLocation = folder.getRelativePath();
        if (relativeFolderLocation.startsWith(TEST_CASE_ROOT_FOLDER_NAME)) {
            relativeFolderLocation = relativeFolderLocation.substring(TEST_CASE_ROOT_FOLDER_NAME.length(), relativeFolderLocation.length());
        }
        relativeFolderLocation = TEST_SCRIPT_SOURCE_FOLDER_NAME + relativeFolderLocation;
        return relativeFolderLocation;
    }

    public static String getScriptPackageAbsolutePathForTestCase(TestCaseEntity testCase) {
        return String.valueOf(testCase.getParentFolder().getProject().getFolderLocation()) + File.separator + GroovyUtil.getScriptPackageRelativePathForTestCase(testCase);
    }

    public static File initTestCaseScriptFolder(FolderEntity folder) {
        if (folder.getParentFolder() == null) {
            return new File(String.valueOf(folder.getProject().getFolderLocation()) + File.separator + TEST_SCRIPT_SOURCE_FOLDER_NAME);
        }
        File folderFile = new File(String.valueOf(GroovyUtil.initTestCaseScriptFolder(folder.getParentFolder()).getAbsolutePath()) + File.separator + folder.getName());
        if (!folderFile.exists()) {
            folderFile.mkdirs();
        }
        return folderFile;
    }

    public static File getTestCaseScriptFolder(TestCaseEntity testCase) {
        File folderFile = GroovyUtil.initTestCaseScriptFolder(testCase.getParentFolder());
        File testCaseFolderFile = new File(String.valueOf(folderFile.getAbsolutePath()) + File.separator + testCase.getName());
        if (!testCaseFolderFile.exists()) {
            testCaseFolderFile.mkdirs();
        }
        return testCaseFolderFile;
    }

    public static String getScriptNameForTestCase(TestCaseEntity testCase) {
        File testCaseFolderFile = new File(GroovyUtil.getScriptPackageAbsolutePathForTestCase(testCase));
        if (testCaseFolderFile.exists() && testCaseFolderFile.isDirectory()) {
            File[] fileArray = testCaseFolderFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().endsWith(".groovy")) {
                    return file.getName().substring(0, file.getName().length() - ".groovy".length());
                }
                ++n2;
            }
        }
        return null;
    }

    public static void updateTestCasePasted(TestCaseEntity updatedTestCase) throws IOException, CoreException {
        byte[] scriptContents;
        IFile scriptFile;
        GroovyUtil.getTestCaseScriptFolder(updatedTestCase);
        IProject groovyProject = GroovyUtil.getGroovyProject(updatedTestCase.getProject());
        IFolder testCaseScriptFolder = groovyProject.getFolder(GroovyUtil.getScriptPackageRelativePathForTestCase(updatedTestCase));
        String scriptFileName = GroovyUtil.getScriptNameForTestCase(updatedTestCase);
        if (scriptFileName == null) {
            scriptFileName = GroovyUtil.getGroovyClassName(updatedTestCase);
        }
        if (!(scriptFile = testCaseScriptFolder.getFile(String.valueOf(scriptFileName) + ".groovy")).exists()) {
            scriptFile.getLocation().toFile().createNewFile();
            scriptFile.refreshLocal(0, null);
        }
        if ((scriptContents = updatedTestCase.getScriptContents()) != null) {
            scriptFile.setContents((InputStream)new ByteArrayInputStream(scriptContents), true, false, null);
        }
    }

    public static void updateTestCaseFolderDeleted(FolderEntity folder, FolderEntity testCaseRootProject) throws CoreException {
        IFolder scriptFolder = GroovyUtil.getGroovyProject(folder.getProject()).getFolder(GroovyUtil.getRelativePathForFolder(folder));
        if (scriptFolder.exists()) {
            scriptFolder.delete(true, null);
            GroovyUtil.getGroovyProject(folder.getProject()).refreshLocal(2, null);
        }
    }

    public static void updateTestCaseDeleted(TestCaseEntity testCase, FolderEntity testCaseRootProject) throws CoreException {
        try {
            IProject groovyProject = GroovyUtil.getGroovyProject(testCase.getProject());
            IFolder folder = groovyProject.getFolder(GroovyUtil.getScriptPackageRelativePathForTestCase(testCase));
            folder.delete(true, null);
            folder.getParent().refreshLocal(2, null);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    public static URLClassLoader getProjectClassLoader(IJavaProject project, String[] classPathEntries) throws MalformedURLException {
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(project.getClass().getClassLoader());
        int i = 0;
        while (i < classPathEntries.length) {
            String entry = classPathEntries[i];
            Path path = new Path(entry);
            URL url = path.toFile().toURI().toURL();
            groovyClassLoader.addURL(url);
            ++i;
        }
        return groovyClassLoader;
    }

    private static URLClassLoader getProjectClassLoader(IJavaProject project, ClassLoader parent, String[] classPathEntries) throws MalformedURLException {
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(parent);
        int i = 0;
        while (i < classPathEntries.length) {
            String entry = classPathEntries[i];
            Path path = new Path(entry);
            URL url = path.toFile().toURI().toURL();
            groovyClassLoader.addURL(url);
            ++i;
        }
        return groovyClassLoader;
    }

    public static void loadScriptContentIntoTestCase(TestCaseEntity testCase) throws CoreException, IOException {
        if (testCase == null) {
            return;
        }
        ProjectEntity project = testCase.getProject();
        String scriptFolderPath = String.valueOf(project.getFolderLocation()) + File.separator + GroovyUtil.getScriptPackageRelativePathForTestCase(testCase);
        String scriptFileName = GroovyUtil.getScriptNameForTestCase(testCase);
        File scriptFile = new File(String.valueOf(scriptFolderPath) + File.separator + scriptFileName + ".groovy");
        if (!scriptFile.exists()) {
            return;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (StringReader stringReader = new StringReader(FileUtils.readFileToString((File)scriptFile, (String)"UTF-8"));){
            testCase.setScriptContents(IOUtils.toByteArray((Reader)stringReader, (String)"UTF-8"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IFile getTempScriptIFile(File scriptFile, ProjectEntity project) throws CoreException {
        IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder(project);
        IResource[] iResourceArray = libFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && resource.getRawLocation().toFile().getAbsolutePath().equals(scriptFile.getAbsolutePath())) {
                return (IFile)resource;
            }
            ++n2;
        }
        return null;
    }

    public static List<IFile> getAllLibFiles(ProjectEntity project) throws CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder(project);
        IResource[] iResourceArray = libFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && FilenameUtils.getExtension((String)resource.getLocation().toString()).equals("groovy")) {
                files.add((IFile)resource);
            }
            ++n2;
        }
        return files;
    }

    public static void refreshScriptTestCaseClasspath(ProjectEntity projectEntity, FolderEntity testCaseFolder) throws CoreException {
        IProject groovyProject = GroovyUtil.getGroovyProject(projectEntity);
        IFolder scriptFolderOfTestCaseFolder = groovyProject.getFolder(GroovyUtil.getScriptPackageRelativePathForFolder(testCaseFolder));
        scriptFolderOfTestCaseFolder.refreshLocal(1, null);
    }

    public static void refreshInfiniteScriptTestCaseClasspath(ProjectEntity projectEntity, FolderEntity testCaseFolder, IProgressMonitor monitor) throws CoreException {
        IProject groovyProject = GroovyUtil.getGroovyProject(projectEntity);
        IFolder scriptFolderOfTestCaseFolder = groovyProject.getFolder(GroovyUtil.getScriptPackageRelativePathForFolder(testCaseFolder));
        scriptFolderOfTestCaseFolder.refreshLocal(2, monitor);
    }

    public static IFolder getTestCaseRootOutputFolder(IProject groovyProject) {
        IFolder outputParentFolder = groovyProject.getFolder(OUTPUT_FOLDER_NAME);
        return outputParentFolder.getFolder(TEST_CASE_OUTPUT_FOLDER_NAME);
    }

    public static void createTestCaseFolder(IFolder testCaseSourceFolder, IFolder parentSourceFolder, TestCaseEntity testCase) throws CoreException {
        if (!testCaseSourceFolder.exists()) {
            parentSourceFolder.refreshLocal(1, null);
            int index = 0;
            while (index < parentSourceFolder.members().length) {
                IResource resource = parentSourceFolder.members()[index];
                if (resource.getName().equalsIgnoreCase(testCase.getName())) {
                    resource.delete(true, null);
                    parentSourceFolder.refreshLocal(1, null);
                    continue;
                }
                ++index;
            }
            testCaseSourceFolder.create(true, true, null);
        }
    }

    public static List<IFile> getAllFiles(IFolder parentFolder, String extension) throws CoreException {
        ArrayList<IFile> listFiles = new ArrayList<IFile>();
        IResource[] iResourceArray = parentFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource childResource = iResourceArray[n2];
            if (childResource instanceof IFile) {
                if (extension.equals(childResource.getFileExtension())) {
                    listFiles.add((IFile)childResource);
                }
            } else if (childResource instanceof IFolder) {
                listFiles.addAll(GroovyUtil.getAllFiles((IFolder)childResource, extension));
            }
            ++n2;
        }
        return listFiles;
    }

    public static List<IFile> getAllScriptFiles(IFolder parentFolder) throws CoreException {
        return GroovyUtil.getAllFiles(parentFolder, "groovy");
    }

    public static List<IFile> getAllGlobalVariableFiles(ProjectEntity projectEntity) throws CoreException {
        IFolder globalVariableRootFolder = GroovyUtil.getGlobalVariableSourceFolder(projectEntity);
        return GroovyUtil.getAllFiles(globalVariableRootFolder, "glbl");
    }

    public static List<IFile> getAllTestCaseFiles(ProjectEntity projectEntity) throws CoreException {
        IFolder testCaseRootFolder = GroovyUtil.getTestCaseSourceFolder(projectEntity);
        return GroovyUtil.getAllFiles(testCaseRootFolder, "tc");
    }

    public static List<IFile> getAllObjectRepositoryFiles(IFolder parentFolder) throws CoreException {
        parentFolder.refreshLocal(2, null);
        return GroovyUtil.getAllFiles(parentFolder, "rs");
    }

    public static List<IFile> getAllScriptFiles(ProjectEntity projectEntity) throws CoreException {
        ArrayList<IFile> scriptFiles = new ArrayList<IFile>();
        scriptFiles.addAll(GroovyUtil.getAllTestCaseScripts(projectEntity));
        scriptFiles.addAll(GroovyUtil.getAllCustomKeywordsScripts(projectEntity));
        scriptFiles.addAll(GroovyUtil.getAllTestListenerScripts(projectEntity));
        return scriptFiles;
    }

    public static List<IFile> getAllTestCaseScripts(ProjectEntity projectEntity) throws CoreException {
        IFolder testCaseRootFolder = GroovyUtil.getTestCaseScriptSourceFolder(projectEntity);
        return GroovyUtil.getAllScriptFiles(testCaseRootFolder);
    }

    public static List<IFile> getAllCustomKeywordsScripts(ProjectEntity projectEntity) throws CoreException {
        IFolder customKeywordRootFolder = GroovyUtil.getCustomKeywordSourceFolder(projectEntity);
        return GroovyUtil.getAllScriptFiles(customKeywordRootFolder);
    }

    public static List<IFile> getAllTestListenerScripts(ProjectEntity projectEntity) throws CoreException {
        IFolder testListenersRootFolder = GroovyUtil.getTestListenerSourceFolder(projectEntity);
        return GroovyUtil.getAllScriptFiles(testListenersRootFolder);
    }

    public static List<IFile> getAllTestSuiteScripts(ProjectEntity projectEntity) throws CoreException {
        IFolder testSuitesRootFolder = GroovyUtil.getTestSuiteSourceFolder(projectEntity);
        return GroovyUtil.getAllScriptFiles(testSuitesRootFolder);
    }

    public static List<IFile> getAllStepDefinitionScripts(ProjectEntity projectEntity) throws CoreException {
        IFolder stepDefinitionsRootFolder = GroovyUtil.getStepDefinitionSourceFolder(projectEntity);
        return GroovyUtil.getAllScriptFiles(stepDefinitionsRootFolder);
    }

    public static List<IFile> getAllRepositoryScripts(ProjectEntity projectEntity) throws CoreException {
        IFolder objectRepositoryFolder = GroovyUtil.getObjectRepositorySourceFolder(projectEntity);
        return GroovyUtil.getAllObjectRepositoryFiles(objectRepositoryFolder);
    }

    private static void createFilters(IProject groovyProject) throws CoreException {
        groovyProject.createFilter(10, new FileInfoMatcherDescription(RESOURCE_REGEX_FILTER, (Object)RESOURCE_FOLDER_NAME_REGEX), 0, (IProgressMonitor)new NullProgressMonitor());
        groovyProject.createFilter(6, new FileInfoMatcherDescription(RESOURCE_REGEX_FILTER, (Object)RESOURCE_FILE_NAME_REGEX), 0, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void removeProjectClassLoaderFromLookup(ProjectEntity projectEntity) {
        if (classLoaderLookup.containsKey(projectEntity.getLocation())) {
            classLoaderLookup.remove(projectEntity.getLocation());
        }
    }

    public static URLClassLoader getProjectClassLoader(ProjectEntity projectEntity) throws MalformedURLException, CoreException {
        String projectLocation = projectEntity.getLocation();
        if (classLoaderLookup.containsKey(projectLocation)) {
            return classLoaderLookup.get(projectLocation);
        }
        IJavaProject project = JavaCore.create((IProject)GroovyUtil.getGroovyProject(projectEntity));
        URLClassLoader classLoader = GroovyUtil.getProjectClassLoader(project, JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project));
        classLoaderLookup.put(projectLocation, classLoader);
        return classLoader;
    }

    public static URLClassLoader updateProjectClassLoader(ProjectEntity projectEntity) throws MalformedURLException, CoreException {
        String projectLocation = projectEntity.getLocation();
        IJavaProject project = JavaCore.create((IProject)GroovyUtil.getGroovyProject(projectEntity));
        String[] classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
        ClasspathHelper.storeDefaultRuntimeClasspath(classPath);
        URLClassLoader classLoader = GroovyUtil.getProjectClassLoader(project, classPath);
        classLoaderLookup.put(projectLocation, classLoader);
        return classLoader;
    }

    public static void updateProjectClassLoaderAsync(ProjectEntity projectEntity) throws InterruptedException, ExecutionException, MalformedURLException {
        IJavaProject project = JavaCore.create((IProject)GroovyUtil.getGroovyProject(projectEntity));
        CompletableFuture<String[]> completableFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
            }
            catch (CoreException coreException) {
                return null;
            }
        });
        String[] classPaths = completableFuture.get();
        if (Objects.nonNull(classPaths)) {
            ClasspathHelper.storeDefaultRuntimeClasspath(classPaths);
            URLClassLoader classLoader = GroovyUtil.getProjectClassLoader(project, classPaths);
            classLoaderLookup.put(projectEntity.getLocation(), classLoader);
        }
    }

    public static URLClassLoader getProjectClassLoader(ProjectEntity projectEntity, ClassLoader parent) throws MalformedURLException, CoreException {
        String projectLocation = projectEntity.getLocation();
        if (classLoaderLookup.containsKey(projectLocation)) {
            return classLoaderLookup.get(projectLocation);
        }
        IJavaProject project = JavaCore.create((IProject)GroovyUtil.getGroovyProject(projectEntity));
        URLClassLoader classLoader = GroovyUtil.getProjectClassLoader(project, parent, JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project));
        classLoaderLookup.put(projectLocation, classLoader);
        return classLoader;
    }

    public static URLClassLoader getClassLoaderFromParent(ProjectEntity projectEntity, ClassLoader parent) throws MalformedURLException, CoreException {
        IJavaProject project = JavaCore.create((IProject)GroovyUtil.getGroovyProject(projectEntity));
        return GroovyUtil.getProjectClassLoader(project, parent, JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project));
    }

    public static IFolder getPluginsFolder(ProjectEntity project) {
        IProject groovyProject = GroovyUtil.getGroovyProject(project);
        return groovyProject.getFolder(PLUGINS_FOLDER_NAME);
    }

    public static ICompilationUnit getOrCreateGroovyScriptForTestCaseFromPlugin(TestCaseEntity testCase) throws IOException, CoreException {
        GroovyUtil.getTestCaseScriptFolder(testCase);
        IProject groovyProject = GroovyUtil.getGroovyProject(testCase.getProject());
        String parentRelativeFolder = GroovyUtil.getScriptPackageRelativePathForTestCase(testCase);
        IFolder parentFolder = groovyProject.getFolder(parentRelativeFolder);
        if (!parentFolder.exists()) {
            parentFolder.getParent().refreshLocal(1, null);
        }
        parentFolder.refreshLocal(1, null);
        String scriptFileName = GroovyUtil.getScriptNameForTestCase(testCase);
        IFile scriptFile = null;
        if (scriptFileName == null) {
            scriptFileName = GroovyUtil.getGroovyClassName(testCase);
            scriptFile = parentFolder.getFile(String.valueOf(scriptFileName) + ".groovy");
            scriptFile.getLocation().toFile().createNewFile();
            FileUtils.writeStringToFile((File)scriptFile.getLocation().toFile(), (String)GroovyUtil.getFileContent("resources/script_imports.tpl"), (String)"UTF-8", (boolean)true);
            scriptFile.refreshLocal(0, null);
        } else {
            scriptFile = parentFolder.getFile(String.valueOf(scriptFileName) + ".groovy");
        }
        return JavaCore.createCompilationUnitFrom((IFile)scriptFile);
    }

    private static String getFileContent(String filePath) {
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(GroovyConstants.class), (IPath)new Path(filePath), null);
        try {
            return StringUtils.join((Iterable)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream())), (String)"\n");
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

