/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.nio.IntBuffer;

public class IntPointer
extends Pointer {
    public IntPointer(String s2) {
        this(s2.length() + 1);
        this.putString(s2);
    }

    public IntPointer(int ... array) {
        this(array.length);
        this.put(array);
    }

    public IntPointer(IntBuffer buffer) {
        super(buffer);
        if (buffer != null && buffer.hasArray()) {
            int[] array = buffer.array();
            this.allocateArray(array.length);
            this.put(array);
            this.position(buffer.position());
        }
    }

    public IntPointer(int size) {
        try {
            this.allocateArray(size);
        }
        catch (UnsatisfiedLinkError e2) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", e2);
        }
    }

    public IntPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public IntPointer position(int position) {
        return (IntPointer)super.position(position);
    }

    public IntPointer capacity(int capacity) {
        return (IntPointer)super.capacity(capacity);
    }

    public int[] getStringCodePoints() {
        int[] newbuffer;
        int[] buffer = new int[16];
        int i2 = 0;
        int j2 = this.position();
        while ((buffer[i2] = this.position(j2).get()) != 0) {
            ++j2;
            if (++i2 < buffer.length) continue;
            newbuffer = new int[2 * buffer.length];
            System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
            buffer = newbuffer;
        }
        newbuffer = new int[i2];
        System.arraycopy(buffer, 0, newbuffer, 0, i2);
        return newbuffer;
    }

    public String getString() {
        int[] codePoints = this.getStringCodePoints();
        return new String(codePoints, 0, codePoints.length);
    }

    public IntPointer putString(String s2) {
        int[] codePoints = new int[s2.length()];
        for (int i2 = 0; i2 < codePoints.length; ++i2) {
            codePoints[i2] = s2.codePointAt(i2);
        }
        return this.put(codePoints).put(codePoints.length, 0);
    }

    public int get() {
        return this.get(0);
    }

    public native int get(int var1);

    public IntPointer put(int j2) {
        return this.put(0, j2);
    }

    public native IntPointer put(int var1, int var2);

    public IntPointer get(int[] array) {
        return this.get(array, 0, array.length);
    }

    public IntPointer put(int[] array) {
        return this.put(array, 0, array.length);
    }

    public native IntPointer get(int[] var1, int var2, int var3);

    public native IntPointer put(int[] var1, int var2, int var3);

    public final IntBuffer asBuffer() {
        return this.asByteBuffer().asIntBuffer();
    }
}

