/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox;

import edu.umd.cs.piccolo.PCanvas;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class PFrame
extends JFrame {
    private static final Dimension DEFAULT_FRAME_DIMENSION = new Dimension(400, 400);
    private static final Point DEFAULT_FRAME_POSITION = new Point(100, 100);
    private static final long serialVersionUID = 1L;
    private PCanvas canvas;
    private final GraphicsDevice graphicsDevice;
    private transient EventListener escapeFullScreenModeListener;

    public PFrame() {
        this("", false, null);
    }

    public PFrame(String title, boolean fullScreenMode, PCanvas canvas) {
        this(title, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice(), fullScreenMode, canvas);
    }

    public PFrame(String title, GraphicsDevice device, boolean fullScreen, PCanvas canvas) {
        super(title, device.getDefaultConfiguration());
        this.graphicsDevice = device;
        this.setBackground(null);
        this.setBounds(this.getDefaultFrameBounds());
        try {
            this.setDefaultCloseOperation(3);
        }
        catch (SecurityException e2) {
            System.out.println("Ignoring security exception. Assuming Applet Context.");
        }
        this.canvas = canvas == null ? new PCanvas() : canvas;
        this.setContentPane(this.canvas);
        this.validate();
        this.setFullScreenMode(fullScreen);
        this.canvas.requestFocus();
        this.beforeInitialize();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PFrame.this.initialize();
                PFrame.this.repaint();
            }
        });
    }

    public PCanvas getCanvas() {
        return this.canvas;
    }

    public Rectangle getDefaultFrameBounds() {
        return new Rectangle(DEFAULT_FRAME_POSITION, DEFAULT_FRAME_DIMENSION);
    }

    public boolean isFullScreenMode() {
        return this.graphicsDevice.getFullScreenWindow() != null;
    }

    public void setFullScreenMode(boolean fullScreenMode) {
        if (fullScreenMode != this.isFullScreenMode() || !this.isVisible()) {
            if (fullScreenMode) {
                this.switchToFullScreenMode();
            } else {
                this.switchToWindowedMode();
            }
        }
    }

    private void switchToFullScreenMode() {
        this.addEscapeFullScreenModeListener();
        if (this.isDisplayable()) {
            this.dispose();
        }
        this.setUndecorated(true);
        this.setResizable(false);
        this.graphicsDevice.setFullScreenWindow(this);
        if (this.graphicsDevice.isDisplayChangeSupported()) {
            this.chooseBestDisplayMode(this.graphicsDevice);
        }
        this.validate();
    }

    private void switchToWindowedMode() {
        this.removeEscapeFullScreenModeListener();
        if (this.isDisplayable()) {
            this.dispose();
        }
        this.setUndecorated(false);
        this.setResizable(true);
        this.graphicsDevice.setFullScreenWindow(null);
        this.validate();
        this.setVisible(true);
    }

    protected void chooseBestDisplayMode(GraphicsDevice device) {
        DisplayMode best = this.getBestDisplayMode(device);
        if (best != null) {
            device.setDisplayMode(best);
        }
    }

    protected DisplayMode getBestDisplayMode(GraphicsDevice device) {
        Iterator itr = this.getPreferredDisplayModes(device).iterator();
        while (itr.hasNext()) {
            DisplayMode each = (DisplayMode)itr.next();
            DisplayMode[] modes = device.getDisplayModes();
            for (int i2 = 0; i2 < modes.length; ++i2) {
                if (modes[i2].getWidth() != each.getWidth() || modes[i2].getHeight() != each.getHeight() || modes[i2].getBitDepth() != each.getBitDepth()) continue;
                return each;
            }
        }
        return null;
    }

    protected Collection getPreferredDisplayModes(GraphicsDevice device) {
        ArrayList<DisplayMode> result = new ArrayList<DisplayMode>();
        result.add(device.getDisplayMode());
        return result;
    }

    public void addEscapeFullScreenModeListener() {
        this.removeEscapeFullScreenModeListener();
        this.escapeFullScreenModeListener = new KeyAdapter(){

            public void keyPressed(KeyEvent aEvent) {
                if (aEvent.getKeyCode() == 27) {
                    PFrame.this.setFullScreenMode(false);
                }
            }
        };
        this.canvas.addKeyListener((KeyListener)this.escapeFullScreenModeListener);
    }

    public void removeEscapeFullScreenModeListener() {
        if (this.escapeFullScreenModeListener != null) {
            this.canvas.removeKeyListener((KeyListener)this.escapeFullScreenModeListener);
            this.escapeFullScreenModeListener = null;
        }
    }

    public void beforeInitialize() {
    }

    public void initialize() {
    }

    public static void main(String[] argv) {
        new PFrame();
    }
}

