/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.preferences.internal;

import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.PreferenceNodeDescription;
import com.kms.katalon.preferences.PreferencePageBuilder;
import java.text.MessageFormat;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.jface.preference.PreferencePage;

public class PreferenceNodeDescriptionImpl
implements PreferenceNodeDescription {
    private final String bundleId;
    private final String nodeId;
    private final String nodeName;
    private final String parentNodeId;
    private final String preferencePageClassName;
    private final PreferencePageBuilderImpl builder;
    private boolean isPlatformStudio = false;

    public PreferenceNodeDescriptionImpl(String bundleId, String nodeId, String nodeName, String parentNodeId, String preferencePageClassName, boolean isPlatformStudio) {
        this.isPlatformStudio = isPlatformStudio;
        this.bundleId = bundleId;
        this.nodeId = nodeId;
        this.parentNodeId = parentNodeId;
        this.nodeName = nodeName;
        this.preferencePageClassName = preferencePageClassName;
        this.builder = new PreferencePageBuilderImpl();
    }

    @Override
    public String getBundleId() {
        return this.bundleId;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getParentNodeId() {
        return this.parentNodeId;
    }

    @Override
    public PreferencePageBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public boolean hasPage() {
        return this.preferencePageClassName != null && !this.preferencePageClassName.isEmpty();
    }

    public class PreferencePageBuilderImpl
    implements PreferencePageBuilder {
        private static final String TESTOPS_BUNDLE_ID = "com.kms.katalon.composer.integration.analytics";

        @Override
        public PreferencePage build(IContributionFactory factory, IEclipseContext context) {
            block4: {
                try {
                    if (!PreferenceNodeDescriptionImpl.this.isPlatformStudio || !PreferenceNodeDescriptionImpl.this.bundleId.equals(TESTOPS_BUNDLE_ID)) break block4;
                    return null;
                }
                catch (ClassNotFoundException e) {
                    LogUtil.printAndLogError((Throwable)e);
                    return null;
                }
            }
            String prefPageURI = this.getClassURI(PreferenceNodeDescriptionImpl.this.bundleId, PreferenceNodeDescriptionImpl.this.preferencePageClassName);
            Object object = factory.create(prefPageURI, context);
            if (object instanceof PreferencePage) {
                return (PreferencePage)object;
            }
            LogUtil.logErrorMessage((String)MessageFormat.format("Expected instance of PreferencePage: {0}", PreferenceNodeDescriptionImpl.this.preferencePageClassName));
            return null;
        }

        private String getClassURI(String definingBundleId, String spec) throws ClassNotFoundException {
            if (spec.startsWith("platform:")) {
                return spec;
            }
            return "bundleclass://" + definingBundleId + '/' + spec;
        }
    }
}

