/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.dialog;

import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.TitleAreaDialogWithLink;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.project.constants.ComposerProjectMessageConstants;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.handlers.GitHandler;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.dal.fileservice.manager.ProjectFileServiceManager;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.GitRepositoryEntity;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.handler.AnalyticsAuthorizationHandler;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenProjectDialog
extends TitleAreaDialogWithLink {
    private static final String ANALYTICS_PROJECT = "AnalyticsProject";
    private static final String ANALYTICS_GIT = "Git";
    private static final String DEFAULT_PROJECT_LOCATION = GlobalStringConstants.DEFAULT_PROJECT_LOCATION;
    private static final int HORIZONTAL_INDENT = 20;
    private static final int TROUBLESHOOT_ID = 1025;
    private Composite container;
    private Button btnFolderChooser;
    private Button btnFetchProject;
    private Button btnFetchBranch;
    private Button btnSaveAuthentication;
    private Combo cbbGitRepoUrls;
    private Combo cbbActiveProjects;
    private Combo cbbBranch;
    private String title;
    private Text txtPersonalAccessToken;
    private char defaultEchoChar = (char)8226;
    private Text txtUsername;
    private Text testOpsServerUrl;
    private Text txtLocalLocation;
    private List<AnalyticsProject> projectList;
    private AnalyticsProject selectedProject;
    private GitRepositoryEntity selectedGitRepo;
    private String serverUrl;
    private int selectedProjectIndex;
    private int selectedGitRepoIndex;
    private int selectedBranchIndex;
    private boolean showError;
    private List<Ref> availableRefs = new ArrayList<Ref>();
    private Ref head;
    private boolean okButtonClicked = false;
    private boolean saveAuthentication = false;

    public OpenProjectDialog(Shell parentShell) {
        this(parentShell, ComposerProjectMessageConstants.VIEW_OPEN_PROJECT);
    }

    public OpenProjectDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
        this.serverUrl = ApplicationInfo.getTestOpsServer();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.title);
        this.setTitle(this.title);
        this.setMessage(ComposerProjectMessageConstants.VIEW_MSG_PLS_ENTER_PROJ_INFO);
        this.container = this.initializeMainComposite(area);
        this.createFirstPart(this.container);
        this.createSecondPart(this.container);
        this.createSeparatorLine(parent);
        this.addControlModifyListeners();
        this.setInput();
        return area;
    }

    private Composite initializeMainComposite(Composite parent) {
        Composite aContainer = new Composite(parent, 0);
        aContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout glContainer = new GridLayout(2, false);
        aContainer.setLayout((Layout)glContainer);
        glContainer.verticalSpacing = 10;
        glContainer.horizontalSpacing = 0;
        glContainer.marginHeight = 15;
        glContainer.marginBottom = 15;
        glContainer.marginLeft = 15;
        glContainer.marginRight = 15;
        return aContainer;
    }

    private void createBoldText(Composite parent, String content) {
        Label label = new Label(parent, 0);
        label.setText(content);
        ControlUtils.setFontStyle((Control)label, (int)1, (int)-1);
        GridData gdLabel = new GridData(4, 4, true, false);
        gdLabel.horizontalSpan = 2;
        label.setLayoutData((Object)gdLabel);
    }

    private void createLabelWithHelpToolItem(Composite parent, String labelText, String documentationLink) {
        Composite aComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 15;
        aComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(16384, 4, false, false);
        aComposite.setLayoutData((Object)gridData);
        Label label = new Label(aComposite, 0);
        label.setText(labelText);
        new HelpCompositeForDialog(aComposite, documentationLink){

            protected GridData createGridData() {
                return new GridData(16384, 0x1000000, true, false);
            }

            protected GridLayout createLayout() {
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.marginLeft = 0;
                layout.marginRight = 0;
                return layout;
            }
        };
    }

    private Composite createFileChooserComposite(Composite parent) {
        Composite aContainer = new Composite(parent, 0);
        aContainer.setLayoutData((Object)new GridData(768));
        GridLayout aLayout = new GridLayout(2, false);
        aLayout.marginWidth = 0;
        aLayout.marginLeft = 20;
        aContainer.setLayout((Layout)aLayout);
        this.txtLocalLocation = new Text(aContainer, 2048);
        this.txtLocalLocation.setLayoutData((Object)new GridData(768));
        this.txtLocalLocation.setText(DEFAULT_PROJECT_LOCATION);
        this.btnFolderChooser = new Button(aContainer, 8);
        this.btnFolderChooser.setText(StringConstants.VIEW_BTN_BROWSE);
        return aContainer;
    }

    private Composite createBranchComposite(Composite parent) {
        Composite aContainer = new Composite(parent, 0);
        aContainer.setLayoutData((Object)new GridData(768));
        GridLayout aLayout = new GridLayout(2, false);
        aLayout.marginWidth = 0;
        aLayout.marginLeft = 20;
        aContainer.setLayout((Layout)aLayout);
        this.cbbBranch = new Combo(aContainer, 2056);
        this.cbbBranch.setLayoutData((Object)new GridData(768));
        this.btnFetchBranch = new Button(aContainer, 8);
        this.btnFetchBranch.setText(ComposerProjectMessageConstants.BTN_FETCH_BRANCH);
        this.btnFetchBranch.setFocus();
        return aContainer;
    }

    private void createFirstPart(Composite container) {
        this.createBoldText(container, ComposerProjectMessageConstants.RETRIEVE_LINKED_REPO);
        Label lblTestOpsServerUrl = new Label(container, 0);
        lblTestOpsServerUrl.setText(ComposerProjectMessageConstants.VIEW_LBL_TESTOPS_SERVER_URL);
        GridData gridDataForLabel = new GridData(16384, 0x1000000, false, false);
        gridDataForLabel.horizontalIndent = 20;
        lblTestOpsServerUrl.setLayoutData((Object)gridDataForLabel);
        this.testOpsServerUrl = new Text(container, 2048);
        this.testOpsServerUrl.setText(this.serverUrl);
        this.testOpsServerUrl.setEnabled(false);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalIndent = 20;
        this.testOpsServerUrl.setLayoutData((Object)gridData);
        this.createLabelWithHelpToolItem(container, ComposerProjectMessageConstants.VIEW_LBL_PROJECT, ComposerProjectMessageConstants.LINK_CREATE_TO_PROJECT);
        Composite projectNameComposite = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 15;
        gridLayout.marginRight = -5;
        projectNameComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, false);
        projectNameComposite.setLayoutData((Object)gridData);
        this.cbbActiveProjects = new Combo(projectNameComposite, 2056);
        this.cbbActiveProjects.setLayoutData((Object)new GridData(768));
        this.btnFetchProject = new Button(projectNameComposite, 8);
        this.btnFetchProject.setText(ComposerProjectMessageConstants.BTN_FETCH_PROJECT);
    }

    private void createSecondPart(Composite container) {
        this.createBoldText(container, ComposerProjectMessageConstants.CLONE_GIT_REPO);
        Label lblGitRepoUrl = new Label(container, 0);
        lblGitRepoUrl.setText(ComposerProjectMessageConstants.VIEW_LBL_GIT_REPO_URL);
        GridData gridDataForLabel = new GridData(4, 0x1000000, false, false);
        gridDataForLabel.horizontalIndent = 20;
        lblGitRepoUrl.setLayoutData((Object)gridDataForLabel);
        this.cbbGitRepoUrls = new Combo(container, 2056);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = 20;
        this.cbbGitRepoUrls.setLayoutData((Object)gridData);
        Label lblUsername = new Label(container, 0);
        lblUsername.setText(ComposerProjectMessageConstants.VIEW_LBL_USERNAME);
        lblUsername.setLayoutData((Object)gridDataForLabel);
        this.txtUsername = new Text(container, 2048);
        this.txtUsername.setLayoutData((Object)new GridData(768));
        this.txtUsername.setLayoutData((Object)gridData);
        this.createLabelWithHelpToolItem(container, ComposerProjectMessageConstants.VIEW_LBL_PERSONAL_ACCESS_TOKEN, ComposerProjectMessageConstants.LINK_GIT_INTEGRATION_TUTORIAL);
        this.txtPersonalAccessToken = new Text(container, 2048);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = 20;
        this.txtPersonalAccessToken.setLayoutData((Object)gridData);
        this.txtPersonalAccessToken.setEchoChar(this.defaultEchoChar);
        new Label(container, 0);
        Composite personalAccessTokenComp = new Composite(container, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginLeft = 15;
        personalAccessTokenComp.setLayout((Layout)gl);
        Label label = new Label(personalAccessTokenComp, 0);
        label.setText(ComposerProjectMessageConstants.PERSONAL_ACCESS_TOKEN_RECOMMENDATION);
        ControlUtils.setFontStyle((Control)label, (int)2, (int)-1);
        new Label(container, 0);
        this.btnSaveAuthentication = new Button(container, 32);
        GridData gdWebServiceProjectType = new GridData(4, 4, true, false, 1, 1);
        gdWebServiceProjectType.horizontalIndent = 20;
        this.btnSaveAuthentication.setLayoutData((Object)gdWebServiceProjectType);
        this.btnSaveAuthentication.setSelection(this.saveAuthentication);
        this.btnSaveAuthentication.setText(ComposerProjectMessageConstants.VIEW_LBL_SAVE_AUTHENTICATION);
        Label lblBranch = new Label(container, 0);
        lblBranch.setText(ComposerProjectMessageConstants.VIEW_LBL_BRANCH);
        lblBranch.setLayoutData((Object)gridDataForLabel);
        this.createBranchComposite(container);
        Label lblLocalLocation = new Label(container, 0);
        lblLocalLocation.setLayoutData((Object)gridDataForLabel);
        lblLocalLocation.setText(ComposerProjectMessageConstants.VIEW_LBL_LOCAL_LOCATION);
        this.createFileChooserComposite(container);
    }

    private void createSeparatorLine(Composite container) {
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(768));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1025, ComposerProjectMessageConstants.TROUBLESHOOT_LABEL, false);
        this.showError = false;
        this.checkInput();
        this.showError = true;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (1025 == buttonId) {
            Program.launch((String)ComposerProjectMessageConstants.URL_TROUBLESHOOT_FAILED_TO_OPEN_PROJECT);
        }
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(this.convertHorizontalDLUsToPixels(400), -1, true);
    }

    public void setErrorMessage(String newErrorMessage) {
        if (this.showError) {
            super.setErrorMessage(newErrorMessage);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void setInput() {
        UISynchronizeService.asyncExec(() -> {
            UserProfile userProfile = UserProfileHelper.getCurrentProfile();
            this.saveAuthentication = userProfile.isSaveAuthentication();
            if (this.saveAuthentication) {
                UserPasswordCredentials credentials = GitHandler.getGitCredentialsFromUserProfile();
                this.txtUsername.setText(StringUtils.defaultString((String)credentials.getUser(), (String)""));
                this.txtPersonalAccessToken.setText(credentials.getPassword());
            }
            this.btnSaveAuthentication.setSelection(this.saveAuthentication);
            this.fillData();
        });
    }

    private void fetchActiveProject() {
        this.setErrorMessage(null);
        this.selectedProjectIndex = 0;
        this.selectedGitRepoIndex = 0;
        this.selectedBranchIndex = 0;
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        OpenProjectDialog.this.projectList = AnalyticsAuthorizationHandler.getActiveProjects((TestOpsService)TestOpsService.getActiveInstance());
                    }
                    catch (AnalyticsApiException error) {
                        LoggerSingleton.logError((Throwable)error);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException error) {
            LoggerSingleton.logError((Throwable)error);
        }
        if (this.projectList != null && this.projectList.size() > 0) {
            this.cbbActiveProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(this.projectList).toArray(new String[this.projectList.size()]));
            this.cbbActiveProjects.select(this.selectedProjectIndex);
            this.selectedProject = this.projectList.get(this.selectedProjectIndex);
            this.setGitRepoBasedOnProject(this.selectedProject);
            try {
                this.getRepositorySelection(this.selectedGitRepo.getRepository());
                this.setBranchesBasedOnGitRepo(this.selectedGitRepo);
                this.checkInput();
            }
            catch (InterruptedException | InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
                this.setErrorMessage(e.getCause().getMessage());
                this.cbbBranch.setItems(new String[0]);
            }
        } else {
            this.showError = true;
            this.setErrorMessage(ComposerProjectMessageConstants.VIEW_ERROR_MSG_TESTOPS_PROJ_NO_GIT_CONFIGURED);
        }
    }

    private void setGitRepoBasedOnProject(AnalyticsProject project) {
        this.selectedGitRepoIndex = 0;
        if (project.getGitRepositories().size() > 0) {
            this.cbbGitRepoUrls.setItems(AnalyticsAuthorizationHandler.getRepositoriesUrl((List)project.getGitRepositories()).toArray(new String[project.getGitRepositories().size()]));
            this.cbbGitRepoUrls.select(this.selectedGitRepoIndex);
            this.selectedGitRepo = (GitRepositoryEntity)this.selectedProject.getGitRepositories().get(this.selectedGitRepoIndex);
        } else {
            this.setErrorMessage(ComposerProjectMessageConstants.HAND_ERROR_MSG_NO_LINKED_GIT);
        }
    }

    private void setBranchesBasedOnGitRepo(GitRepositoryEntity gitRepo) {
        this.selectedBranchIndex = 0;
        ArrayList<String> BranchNames = new ArrayList<String>();
        for (Ref ref : this.availableRefs) {
            BranchNames.add(ref.getName());
            if (!ref.getName().equals(this.selectedGitRepo.getBranch())) continue;
            this.selectedBranchIndex = this.availableRefs.indexOf(ref);
        }
        this.cbbBranch.setItems(BranchNames.toArray(new String[BranchNames.size()]));
        this.cbbBranch.select(this.selectedBranchIndex);
    }

    private void fillData() {
        this.fetchActiveProject();
    }

    private UsernamePasswordCredentialsProvider getCredentials() {
        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(StringUtils.defaultIfBlank((String)this.txtUsername.getText(), (String)" "), this.txtPersonalAccessToken.getText());
        return credentials;
    }

    private void saveAuthentication() {
        UserProfile userProfile = UserProfileHelper.getCurrentProfile();
        userProfile.setGitUsername("");
        userProfile.setGitPersonalAccessToken("");
        if (this.saveAuthentication) {
            userProfile.setGitUsername(this.txtUsername.getText());
            userProfile.setGitPersonalAccessToken(this.txtPersonalAccessToken.getText());
        }
        userProfile.setSaveAuthentication(this.saveAuthentication);
        UserProfileHelper.saveProfile((UserProfile)userProfile);
    }

    private void saveGitPermission(String repoUrl) {
        try {
            URIish uri = new URIish(repoUrl);
            String username = StringUtils.defaultIfBlank((String)this.txtUsername.getText(), (String)" ");
            String password = this.txtPersonalAccessToken.getText();
            UserPasswordCredentials credentials = new UserPasswordCredentials(username, password);
            SecureStoreUtils.storeCredentials((UserPasswordCredentials)credentials, (URIish)uri);
        }
        catch (URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void getRepositorySelection(String repoUrl) throws InvocationTargetException, InterruptedException {
        ListRemoteOperation listRemoteOp;
        this.head = null;
        this.availableRefs = new ArrayList<Ref>();
        try {
            URIish uri = new URIish(repoUrl);
            Repository db = FileRepositoryBuilder.create((File)new File("/tmp"));
            listRemoteOp = new ListRemoteOperation(db, uri, GitSettings.getRemoteConnectionTimeout());
            UsernamePasswordCredentialsProvider credentials = this.getCredentials();
            if (credentials != null) {
                listRemoteOp.setCredentialsProvider((CredentialsProvider)credentials);
            }
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    listRemoteOp.run(monitor);
                }
            });
        }
        catch (IOException | URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
            return;
        }
        Ref idHEAD = listRemoteOp.getRemoteRef("HEAD");
        boolean headIsMaster = false;
        for (Ref r : listRemoteOp.getRemoteRefs()) {
            ObjectId objectId;
            String n = r.getName();
            if (!n.startsWith("refs/heads/")) continue;
            this.availableRefs.add(r);
            if (idHEAD == null || headIsMaster || (objectId = r.getObjectId()) == null || !objectId.equals((AnyObjectId)idHEAD.getObjectId())) continue;
            headIsMaster = "refs/heads/master".equals(r.getName());
            if (this.head != null && !headIsMaster) continue;
            this.head = r;
        }
        Collections.sort(this.availableRefs, new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (idHEAD != null && this.head == null) {
            this.head = idHEAD;
            this.availableRefs.add(0, idHEAD);
        }
    }

    private boolean validateProject() {
        if (this.selectedProject == null) {
            this.setErrorMessage(ComposerProjectMessageConstants.VIEW_ERROR_MSG_TESTOPS_PROJ_NO_GIT_CONFIGURED);
            return false;
        }
        if (this.selectedGitRepo == null) {
            this.setErrorMessage(ComposerProjectMessageConstants.HAND_ERROR_MSG_NO_LINKED_GIT);
            return false;
        }
        return true;
    }

    private String getProjectLocationInput() {
        if (this.txtLocalLocation == null || StringUtils.isBlank((String)this.txtLocalLocation.getText())) {
            return "";
        }
        String projectLocation = this.txtLocalLocation.getText().trim();
        if (!projectLocation.contains(File.separator)) {
            projectLocation = String.valueOf(DEFAULT_PROJECT_LOCATION) + File.separator + projectLocation;
        }
        return projectLocation;
    }

    private boolean validateProjectFolderLocation() {
        String projectLocation = this.getProjectLocationInput();
        if (StringUtils.isBlank((String)projectLocation)) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_CANNOT_BE_BLANK);
            return false;
        }
        Path folderPath = null;
        try {
            folderPath = Paths.get(projectLocation, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_INVALID);
            return false;
        }
        File folderLocation = folderPath.toFile();
        if (!folderLocation.exists()) {
            return true;
        }
        if (!folderLocation.canRead()) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_NOT_READABLE);
            return false;
        }
        if (!folderLocation.canWrite()) {
            this.setErrorMessage(StringConstants.VIEW_ERROR_MSG_PROJ_LOC_NOT_WRITEABLE);
            return false;
        }
        try {
            String katalonFolderAbsolutePath = new File(Platform.getInstallLocation().getURL().getFile()).getAbsolutePath();
            String locFileAbsolutePath = new File(projectLocation).getAbsolutePath();
            if (locFileAbsolutePath.startsWith(katalonFolderAbsolutePath)) {
                this.setErrorMessage(StringConstants.CANNOT_CREATE_PROJECT_IN_KATALON_FOLDER);
                return false;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        return true;
    }

    private boolean validateCredential() {
        if (StringUtils.isBlank((String)this.txtPersonalAccessToken.getText())) {
            this.setErrorMessage(ComposerProjectMessageConstants.HAND_ERROR_MSG_CREDENTIALS_INVALID);
            return false;
        }
        return true;
    }

    private boolean validateBranch() {
        String branch = this.cbbBranch.getText();
        return !StringUtils.isBlank((String)branch);
    }

    private void checkInput() {
        if (this.okButtonClicked) {
            return;
        }
        this.getButton(0).setEnabled(this.validateProject() && this.validateCredential() && this.validateProjectFolderLocation() && this.validateBranch());
        if (this.getButton(0).getEnabled()) {
            this.setErrorMessage(null);
        }
    }

    private File createLocalProjectFolder(String parentFolderLocation, String projectName) {
        int projectIndex = 1;
        File projectFolder = new File(String.valueOf(parentFolderLocation) + File.separator + projectName);
        while (projectFolder.exists()) {
            projectFolder = new File(String.valueOf(parentFolderLocation) + File.separator + projectName + " (" + projectIndex + ")");
            ++projectIndex;
        }
        projectFolder.mkdirs();
        return projectFolder;
    }

    protected void okPressed() {
        this.okButtonClicked = true;
        String repoUrl = this.selectedGitRepo.getRepository();
        try {
            URIish uri = new URIish(repoUrl).setUser(null);
            repoUrl = uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        String selectedBranch = this.cbbBranch.getText();
        this.selectedGitRepo.setBranch(selectedBranch);
        File directory = this.createLocalProjectFolder(this.txtLocalLocation.getText(), this.selectedGitRepo.getName());
        try {
            FileUtils.forceDelete((File)directory);
        }
        catch (IOException exception) {
            LoggerSingleton.logError((Throwable)exception);
        }
        StringBuilder message = new StringBuilder();
        this.saveGitPermission(repoUrl);
        this.saveAuthentication();
        ProjectEntity gitProject = null;
        gitProject = GitHandler.cloneGitProject(repoUrl, selectedBranch, directory, message);
        if (gitProject == null && StringUtils.isNotBlank((String)message.toString())) {
            this.setErrorMessage(message.toString());
            return;
        }
        ProjectController projectController = ProjectController.getInstance();
        if (gitProject == null) {
            try {
                gitProject = projectController.addNewTestOpsProjectWithoutNewFolder(this.selectedGitRepo.getName(), "", directory.getPath());
                gitProject.setType(ProjectType.WEBUI);
                ProjectController.getInstance().updateProject(gitProject);
                EventBrokerSingleton.getInstance().getEventBroker().send("PROJECT/CREATED", (Object)gitProject);
                Trackings.trackCreatingProject((String)gitProject.getUUID(), (ProjectType)ProjectType.WEBUI);
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
                LoggerSingleton.logError((Throwable)e);
                Trackings.trackOpenProjectFailed();
                return;
            }
        }
        super.okPressed();
        if (gitProject != null) {
            try {
                ProjectFileServiceManager.updateProjectLocation((String)gitProject.getId());
                String projectId = gitProject.getId();
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put(ANALYTICS_PROJECT, this.selectedProject);
                options.put(ANALYTICS_GIT, this.selectedGitRepo);
                UISynchronizeService.syncExec(() -> {
                    EventBrokerSingleton.getInstance().getEventBroker().send("PROJECT/OPEN", (Object)projectId);
                    Trackings.trackOpenProjectSucceeded();
                    KatalonApplicationActivator.getTestOpsConfiguration().testOpsPlatformIntergration(options);
                });
            }
            catch (Exception e) {
                LoggerSingleton.getInstance().getLogger().error((Throwable)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)ComposerProjectMessageConstants.HAND_ERROR_MSG_UNABLE_TO_CLONE);
            }
        }
    }

    private void addControlModifyListeners() {
        this.txtLocalLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenProjectDialog.this.checkInput();
            }
        });
        this.txtPersonalAccessToken.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenProjectDialog.this.checkInput();
            }
        });
        this.txtUsername.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenProjectDialog.this.checkInput();
            }
        });
        if (this.btnFolderChooser == null) {
            return;
        }
        this.btnFolderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(OpenProjectDialog.this.btnFolderChooser.getShell());
                dialog.setFilterPath(OpenProjectDialog.this.getProjectLocationInput());
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                OpenProjectDialog.this.txtLocalLocation.setText(path);
                OpenProjectDialog.this.checkInput();
            }
        });
        this.cbbActiveProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenProjectDialog.this.cbbBranch.setItems(new String[0]);
                OpenProjectDialog.this.selectedProject = OpenProjectDialog.this.projectList.get(OpenProjectDialog.this.cbbActiveProjects.getSelectionIndex());
                OpenProjectDialog.this.setGitRepoBasedOnProject(OpenProjectDialog.this.selectedProject);
                try {
                    OpenProjectDialog.this.selectedGitRepo = (GitRepositoryEntity)OpenProjectDialog.this.selectedProject.getGitRepositories().get(OpenProjectDialog.this.cbbGitRepoUrls.getSelectionIndex());
                    OpenProjectDialog.this.getRepositorySelection(OpenProjectDialog.this.selectedGitRepo.getRepository());
                    OpenProjectDialog.this.setBranchesBasedOnGitRepo(OpenProjectDialog.this.selectedGitRepo);
                    OpenProjectDialog.this.checkInput();
                }
                catch (InterruptedException | InvocationTargetException error) {
                    LoggerSingleton.logError((Throwable)error);
                    OpenProjectDialog.this.setErrorMessage(error.getCause().getMessage());
                    OpenProjectDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        this.cbbGitRepoUrls.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    OpenProjectDialog.this.cbbBranch.setItems(new String[0]);
                    OpenProjectDialog.this.selectedGitRepo = (GitRepositoryEntity)OpenProjectDialog.this.selectedProject.getGitRepositories().get(OpenProjectDialog.this.cbbGitRepoUrls.getSelectionIndex());
                    OpenProjectDialog.this.getRepositorySelection(OpenProjectDialog.this.selectedGitRepo.getRepository());
                    OpenProjectDialog.this.setBranchesBasedOnGitRepo(OpenProjectDialog.this.selectedGitRepo);
                    OpenProjectDialog.this.checkInput();
                }
                catch (InterruptedException | InvocationTargetException error) {
                    LoggerSingleton.logError((Throwable)error);
                    OpenProjectDialog.this.setErrorMessage(error.getCause().getMessage());
                    OpenProjectDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        this.btnFetchProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenProjectDialog.this.cbbBranch.setItems(new String[0]);
                OpenProjectDialog.this.fetchActiveProject();
                OpenProjectDialog.this.checkInput();
            }
        });
        this.btnFetchBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    OpenProjectDialog.this.cbbBranch.setItems(new String[0]);
                    OpenProjectDialog.this.getRepositorySelection(OpenProjectDialog.this.selectedGitRepo.getRepository());
                    OpenProjectDialog.this.setBranchesBasedOnGitRepo(OpenProjectDialog.this.selectedGitRepo);
                    OpenProjectDialog.this.checkInput();
                }
                catch (InterruptedException | InvocationTargetException error) {
                    LoggerSingleton.logError((Throwable)error);
                    OpenProjectDialog.this.setErrorMessage(error.getCause().getMessage());
                    OpenProjectDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        this.btnSaveAuthentication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenProjectDialog.this.saveAuthentication = OpenProjectDialog.this.btnSaveAuthentication.getSelection();
            }
        });
        EventBrokerSingleton.getInstance().getEventBroker().subscribe("CLOSE_DIALOG", new EventHandler(){

            public void handleEvent(Event event) {
                OpenProjectDialog.this.close();
            }
        });
    }
}

