/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ProjectCreatedHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("PROJECT/CREATED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                Object object = this.getObject(event);
                ProjectCreatedHandler.this.execute(object);
            }
        });
    }

    @Execute
    public void execute(@UIEventTopic(value="PROJECT/CREATED") Object object) {
        if (object != null) {
            ProjectEntity projectEntity = (ProjectEntity)object;
            WebUiExecutionSettingStore store = new WebUiExecutionSettingStore(projectEntity);
            UserProfile userProfile = UserProfileHelper.getCurrentProfile();
            userProfile.setDoneCreateFirstProject(true);
            userProfile.addCompletedTour("CREATE_FIRST_PROJECT");
            UserProfileHelper.saveProfile((UserProfile)userProfile);
            try {
                store.setCapturedTestObjectSelectorMethod(SelectorMethod.XPATH);
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }
}

