/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.handlers;

import com.kms.katalon.application.preference.ProjectSettingPreference;
import com.kms.katalon.composer.components.constants.ComponentSize;
import com.kms.katalon.composer.components.impl.helpers.DialogBuilder;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.project.constants.ComposerProjectMessageConstants;
import com.kms.katalon.composer.project.constants.ProjectPreferenceConstants;
import com.kms.katalon.composer.project.template.RecentProjectOpener;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Button;

public class RecentProjectHandler {
    @Inject
    EventBroker eventBroker;
    @Inject
    private EPartService partService;

    @Execute
    public void execute(@Optional @Named(value="com.kms.katalon.composer.project.command.openrecentproject.parameters.project") @Named(value="com.kms.katalon.composer.project.command.openrecentproject.parameters.project") String projectPk) throws Exception {
        if (projectPk != null) {
            if (ProjectController.getInstance().getCurrentProject() != null) {
                this.eventBroker.post("PROJECT/SAVE_SESSION", (Object)projectPk);
            }
            RecentProjectOpener opener = new RecentProjectOpener(this.eventBroker, projectPk, "PROJECT/OPEN");
            opener.doOpenProject();
        }
    }

    @Inject
    @Optional
    private void openLastRecentProject(@UIEventTopic(value="ACTIVATION/CHECKED") Object object) {
        if (ProjectController.getInstance().getCurrentProject() != null || ProjectController.getInstance().isOpenning()) {
            return;
        }
        try {
            ProjectSettingPreference projectPreferences = new ProjectSettingPreference();
            List recentProjects = projectPreferences.getRecentProjects();
            if (recentProjects == null || recentProjects.isEmpty()) {
                return;
            }
            if (RecentProjectHandler.getGeneralStore().getBoolean("general.autoRestorePreviousSession")) {
                ScopedPreferenceStore store;
                String latestOpenedProject;
                MPart explorerPart = this.partService.findPart("com.kms.katalon.composer.part.explorer");
                if (explorerPart != null) {
                    this.partService.activate(explorerPart, true);
                }
                if (StringUtils.isNotEmpty((String)(latestOpenedProject = (store = PreferenceStoreManager.getPreferenceStore(this.getClass())).getString(ProjectPreferenceConstants.LATEST_OPENED_PROJECT)))) {
                    if (ProjectController.getInstance().getProject(latestOpenedProject) != null) {
                        RecentProjectOpener opener = new RecentProjectOpener(this.eventBroker, latestOpenedProject, "PROJECT/OPEN_LATEST");
                        opener.doOpenProject();
                    } else {
                        new DialogBuilder().error().message(ComposerProjectMessageConstants.MSG_CANNOT_FOUND_THE_LOCAL_PROJECT).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.CLOSE).onClick(event -> ((Button)event.widget).getShell().close()).width(80).defaultButton()).size(ComponentSize.MEDIUM).build().open();
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public static ScopedPreferenceStore getGeneralStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
    }
}

