/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.sample;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.sample.SampleRemoteProject;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewSampleRemoteProjectDialog
extends TitleAreaDialog {
    private static final String DEFAULT_PROJECT_LOCATION = String.valueOf(System.getProperty("user.home")) + File.separator + StringConstants.APP_NAME;
    private SampleRemoteProject sampleProject;
    private Text txtSourceURL;
    private Text txtProjectName;
    private Text txtProjectLocation;
    private Button btnFolderChooser;
    private ProjectEntity projectInfo;

    public ProjectEntity getProjectInfo() {
        return this.projectInfo;
    }

    public NewSampleRemoteProjectDialog(Shell parentShell, SampleRemoteProject sampleProject) {
        super(parentShell);
        this.sampleProject = sampleProject;
    }

    protected void registerControlModifyListeners() {
        this.btnFolderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(NewSampleRemoteProjectDialog.this.btnFolderChooser.getShell());
                dialog.setFilterPath(NewSampleRemoteProjectDialog.this.getProjectLocationInput());
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                String location = NewSampleRemoteProjectDialog.this.txtProjectLocation.getText();
                if (location.isEmpty()) {
                    NewSampleRemoteProjectDialog.this.txtProjectLocation.setText(path);
                } else {
                    NewSampleRemoteProjectDialog.this.txtProjectLocation.setText(path);
                }
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String newLocation = NewSampleRemoteProjectDialog.this.txtProjectLocation.getText();
                if (newLocation.isEmpty()) {
                    NewSampleRemoteProjectDialog.this.setMessage("Project location cannot be empty.", 2);
                    NewSampleRemoteProjectDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                String newName = NewSampleRemoteProjectDialog.this.txtProjectName.getText();
                if (newName.isEmpty()) {
                    NewSampleRemoteProjectDialog.this.setMessage("Project name cannot be empty.", 2);
                    NewSampleRemoteProjectDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                if (new File(newLocation, newName).exists()) {
                    NewSampleRemoteProjectDialog.this.setMessage("A project with the same name already exists in the selected location.", 3);
                    NewSampleRemoteProjectDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                NewSampleRemoteProjectDialog.this.setInfoMessage();
                NewSampleRemoteProjectDialog.this.getButton(0).setEnabled(true);
            }
        };
        this.txtProjectName.addModifyListener(modifyListener);
        this.txtProjectLocation.addModifyListener(modifyListener);
    }

    private void setInfoMessage() {
        this.setMessage("Please enter your project information", 1);
    }

    protected void setInput() {
        this.txtSourceURL.setText(this.sampleProject.getSourceUrl());
        this.txtProjectLocation.setText(DEFAULT_PROJECT_LOCATION);
        this.txtProjectName.setText(this.getSuggestedLocation(DEFAULT_PROJECT_LOCATION));
        this.txtProjectName.selectAll();
        this.txtProjectName.forceFocus();
        this.setInfoMessage();
    }

    private String getSuggestedLocation(String parentLocation) {
        String name = this.sampleProject.getName();
        String suggestedProjectLocation = new File(parentLocation, name).getAbsolutePath();
        if (!new File(suggestedProjectLocation).exists()) {
            return name;
        }
        int num = 1;
        String newSuggestedName;
        while (new File(parentLocation, newSuggestedName = String.format("%s_%d", name, num)).exists()) {
            ++num;
        }
        return newSuggestedName;
    }

    private String getProjectLocationInput() {
        if (this.txtProjectLocation == null || StringUtils.isBlank((CharSequence)this.txtProjectLocation.getText())) {
            return "";
        }
        String projectLocation = this.txtProjectLocation.getText().trim();
        if (!projectLocation.contains(File.separator)) {
            projectLocation = String.valueOf(DEFAULT_PROJECT_LOCATION) + File.separator + projectLocation;
        }
        return projectLocation;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 15;
        gridLayout.verticalSpacing = 15;
        container.setLayout((Layout)gridLayout);
        Label lblSourceURL = new Label(container, 0);
        lblSourceURL.setText("Repository URL");
        this.txtSourceURL = new Text(container, 2048);
        this.txtSourceURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtSourceURL.setEditable(false);
        this.txtSourceURL.setBackground(ColorUtil.getDisabledItemBackgroundColor());
        Label lblProjectName = new Label(container, 0);
        lblProjectName.setText("Project Name");
        this.txtProjectName = new Text(container, 2048);
        this.txtProjectName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblProjectLocation = new Label(container, 0);
        lblProjectLocation.setText("Project Location");
        Composite locationControlsComposite = new Composite(container, 0);
        locationControlsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout glLocationControl = new GridLayout(2, false);
        glLocationControl.marginWidth = 0;
        glLocationControl.marginHeight = 0;
        locationControlsComposite.setLayout((Layout)glLocationControl);
        this.txtProjectLocation = new Text(locationControlsComposite, 2048);
        this.txtProjectLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnFolderChooser = new Button(locationControlsComposite, 0);
        this.btnFolderChooser.setText("Browse...");
        this.setInput();
        this.registerControlModifyListeners();
        return container;
    }

    protected Point getInitialSize() {
        return new Point(600, super.getInitialSize().y);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Clone Remote Project");
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected void okPressed() {
        this.projectInfo = new ProjectEntity();
        this.projectInfo.setName(this.txtProjectName.getText());
        this.projectInfo.setFolderLocation(this.txtProjectLocation.getText());
        super.okPressed();
    }
}

