/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.template;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.constants.ComponentSize;
import com.kms.katalon.composer.components.impl.helpers.DialogBuilder;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.project.constants.ComposerProjectMessageConstants;
import com.kms.katalon.composer.project.dialog.OpenProjectDialog;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.GitRepositoryEntity;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.handler.AnalyticsAuthorizationHandler;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.NoRouteToHostException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.NoSuchFileException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;

public class RecentProjectOpener {
    private static final String ACTIVE_PROJECT = "ACTIVE";
    private static final int OPEN_PROJECT_CODE = 0;
    private static final int NO_MATCHING_PROJECT_CODE = 1;
    private static final int NO_MATCHING_GIT_REPO_URL_CODE = 2;
    private static final int NO_LOCAL_LOCATION_FOUND_CODE = 3;
    private static boolean isValidatedSuccess = false;
    @Inject
    EventBroker eventBroker;
    private String eventConstant;
    private String projectPk;
    private Throwable throwable;

    public RecentProjectOpener(EventBroker eventBroker, String projectPk, String eventConstant) {
        this.eventBroker = eventBroker;
        this.eventConstant = eventConstant;
        this.projectPk = projectPk;
    }

    private void handlePersonalAccessToken(String gitRepoUrl) {
        block4: {
            try {
                UserPasswordCredentials credential = SecureStoreUtils.getCredentials((URIish)new URIish(gitRepoUrl));
                if (credential != null) break block4;
                String personalAccessToken = "";
                String encryptedPersonalAccessToken = UserProfileHelper.getCurrentProfile().getGitPersonalAccessToken();
                CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)StringUtils.defaultIfBlank((String)encryptedPersonalAccessToken, (String)" "));
                try {
                    personalAccessToken = CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
                }
                catch (IOException | GeneralSecurityException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                this.setGitPermission(gitRepoUrl, UserProfileHelper.getCurrentProfile().getGitUsername(), personalAccessToken);
            }
            catch (URISyntaxException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private void setGitPermission(String repoUrl, String username, String personalAccessToken) {
        try {
            URIish uri = new URIish(repoUrl);
            UserPasswordCredentials credentials = new UserPasswordCredentials(StringUtils.defaultIfBlank((String)username, (String)" "), personalAccessToken);
            SecureStoreUtils.storeCredentials((UserPasswordCredentials)credentials, (URIish)uri);
        }
        catch (URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private List<AnalyticsProject> getProjectList() throws Exception {
        List analyticsProjectList = AnalyticsAuthorizationHandler.getProjectsList((TestOpsService)TestOpsService.getInstance());
        return analyticsProjectList;
    }

    private List<AnalyticsProject> getActiveProjects(List<AnalyticsProject> projects) throws Exception {
        ArrayList<AnalyticsProject> activeProjects = new ArrayList<AnalyticsProject>();
        for (AnalyticsProject project : projects) {
            if (!project.getStatus().equals(ACTIVE_PROJECT)) continue;
            activeProjects.add(project);
        }
        return activeProjects;
    }

    private int isRecentProjectAllowedToOpen(ProjectEntity localProjectEntity, AnalyticsProject analyticsProject, List<AnalyticsProject> analyticsProjectList) {
        block11: {
            block10: {
                if (analyticsProject != null) break block10;
                return 1;
            }
            if (localProjectEntity != null) break block11;
            return 2;
        }
        try {
            AnalyticsSettingStore settingStore = new AnalyticsSettingStore(localProjectEntity.getFolderLocation());
            AnalyticsProject matchingAnalyticsProject = null;
            Long projectId = analyticsProject.getId();
            String gitRepoUrl = "";
            if (settingStore.getGitRepositoryEntity() != null) {
                gitRepoUrl = settingStore.getGitRepositoryEntity().getRepository();
            }
            boolean matchingProject = false;
            boolean matchingGitRepoUrl = false;
            for (AnalyticsProject project : analyticsProjectList) {
                if (!projectId.equals(project.getId())) continue;
                matchingAnalyticsProject = project;
                matchingProject = true;
                break;
            }
            if (matchingProject) {
                if (!StringUtils.isBlank((String)gitRepoUrl)) {
                    for (GitRepositoryEntity gitRepo : matchingAnalyticsProject.getGitRepositories()) {
                        if (!gitRepoUrl.equalsIgnoreCase(gitRepo.getRepository())) continue;
                        matchingGitRepoUrl = true;
                        break;
                    }
                }
                if (!matchingGitRepoUrl) {
                    return 2;
                }
                return 0;
            }
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex, (String)ex.getMessage());
        }
        return 1;
    }

    private void openErrorMessageDialog(String errorMessage) {
        new DialogBuilder().warning().message(errorMessage).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.DIA_TROUBLESHOOT).onClick(event -> Program.launch((String)ComposerProjectMessageConstants.URL_TROUBLESHOOT_FAIL_OPEN_RECENT_PROJECT))).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.DIA_OPEN_PROJECT).onClick(event -> UITimeUtil.setTimeout(() -> {
            OpenProjectDialog openProjectDialog = new OpenProjectDialog(Display.getCurrent().getActiveShell());
            openProjectDialog.open();
        }, (long)100L)).defaultButton().closeButton()).build().open();
    }

    private void openErrorMessageDialogV2(String errorMessage, ComponentSize size) {
        new DialogBuilder().error().message(errorMessage).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.CLOSE).onClick(event -> ((Button)event.widget).getShell().close()).width(80)).size(size).build().open();
    }

    private void openErrorMessageProject(int returnCode) {
        switch (returnCode) {
            case 1: {
                Trackings.trackTroubleshootOpenRecentProjectClicked((String)"Invalid projectId");
                this.openErrorMessageDialog(ComposerProjectMessageConstants.HAND_ERROR_NO_MATCHING_TO_PROJECT);
                break;
            }
            case 2: {
                Trackings.trackTroubleshootOpenRecentProjectClicked((String)"Invalid repo");
                this.openErrorMessageDialog(ComposerProjectMessageConstants.HAND_ERROR_NO_MATCHING_GIT_REPO_URL);
                break;
            }
            case 3: {
                Trackings.trackTroubleshootOpenRecentProjectClicked((String)"Project cannot be found");
                this.openErrorMessageDialog(ComposerProjectMessageConstants.HAND_ERROR_NO_RECENT_PROJECT_FOUND);
            }
        }
    }

    public void doOpenProject() throws Exception {
        if (ApplicationInfo.isPlatformStudio()) {
            block7: {
                isValidatedSuccess = false;
                this.throwable = null;
                try {
                    this.validateProjectInformation();
                }
                catch (Exception e) {
                    if (!(e instanceof NoSuchFileException)) break block7;
                    this.openErrorMessageDialogV2(ComposerProjectMessageConstants.MSG_CANNOT_FOUND_THE_LOCAL_PROJECT, ComponentSize.MEDIUM);
                    return;
                }
            }
            if (!isValidatedSuccess) {
                if (this.throwable != null) {
                    if (this.throwable.getCause() instanceof UnknownHostException || this.throwable.getCause() instanceof NoRouteToHostException) {
                        this.openErrorMessageDialogV2("Cannot open the project. Please check your internet connection and try again.", ComponentSize.MEDIUM);
                    } else {
                        this.openErrorMessageDialogV2("Cannot open the project. This project cannot be found on TestOps or has invalid Git configuration.", ComponentSize.MEDIUM);
                    }
                }
                return;
            }
        }
        this.eventBroker.send(this.eventConstant, (Object)this.projectPk);
    }

    private void validateProjectInformation() throws Exception {
        final ProjectEntity localProjectEntity = (ProjectEntity)EntityService.getInstance().getEntityByPath(this.projectPk);
        final AnalyticsSettingStore testOpsSettingStore = new AnalyticsSettingStore(localProjectEntity.getFolderLocation());
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block10: {
                    try {
                        try {
                            if (RecentProjectOpener.this.eventConstant.equals("PROJECT/OPEN")) {
                                monitor.beginTask(ComposerProjectMessageConstants.MSG_OPEN_RECENT_PROJECT_PROGRESS, 7);
                            } else {
                                monitor.beginTask(ComposerProjectMessageConstants.MSG_OPEN_LATEST_RECENT_PROJECT_PROGRESS, 100);
                            }
                            monitor.subTask("Validating Git Credential...");
                            monitor.worked(1);
                            monitor.subTask("Granting Integrating information...");
                            List<AnalyticsProject> analyticsProjectList = RecentProjectOpener.this.getActiveProjects(RecentProjectOpener.this.getProjectList());
                            monitor.worked(1);
                            monitor.subTask("Getting stored Project information...");
                            AnalyticsProject analyticsProject = testOpsSettingStore.getProject();
                            monitor.worked(1);
                            monitor.subTask("Validating Project information...");
                            final int returnCode = RecentProjectOpener.this.isRecentProjectAllowedToOpen(localProjectEntity, analyticsProject, analyticsProjectList);
                            monitor.worked(1);
                            if (returnCode == 0) {
                                monitor.subTask("Enabling Project integration...");
                                testOpsSettingStore.enableIntegration(true);
                                monitor.worked(1);
                                monitor.subTask("Handling personal access token...");
                                RecentProjectOpener.this.handlePersonalAccessToken(testOpsSettingStore.getGitRepositoryEntity().getRepository());
                                monitor.worked(1);
                                isValidatedSuccess = true;
                                break block10;
                            }
                            UISynchronizeService.getInstance().getSync().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    RecentProjectOpener.this.openErrorMessageProject(returnCode);
                                    isValidatedSuccess = false;
                                }
                            });
                        }
                        catch (Exception e) {
                            if (e instanceof IllegalArgumentException || e instanceof AnalyticsApiException) {
                                RecentProjectOpener.this.throwable = e;
                            } else {
                                LoggerSingleton.logError((Throwable)e);
                            }
                            isValidatedSuccess = false;
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        });
    }
}

