/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.template;

import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.composer.project.sample.SampleLocalProject;
import com.kms.katalon.composer.project.sample.SampleProjectType;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;

public class SampleProjectProvider {
    private static final String RESOURCES_SAMPLE_PROJECTS_FOLDER = "resources" + File.separator + "samples";
    public static final String SAMPLE_WEB_UI = StringConstants.SAMPLE_WEB_UI_PROJECT;
    public static final String SAMPLE_MOBILE = StringConstants.SAMPLE_MOBILE_PROJECT;
    public static final String SAMPLE_WEB_SERVICE = StringConstants.SAMPLE_WEB_SERVICE_PROJECT;
    private static final List<SampleLocalProject> SAMPLE_PROJECTS = Arrays.asList(SampleProjectProvider.createSampleProjectInfo(SampleProjectType.WEBUI, SAMPLE_WEB_UI, "WebUI"), SampleProjectProvider.createSampleProjectInfo(SampleProjectType.MOBILE, SAMPLE_MOBILE, "Mobile"), SampleProjectProvider.createSampleProjectInfo(SampleProjectType.WS, SAMPLE_WEB_SERVICE, "WebService"));
    private static SampleProjectProvider instance;

    private SampleProjectProvider() {
    }

    public static SampleProjectProvider getInstance() {
        if (instance == null) {
            instance = new SampleProjectProvider();
        }
        return instance;
    }

    public List<SampleLocalProject> getSampleProjects() {
        return SAMPLE_PROJECTS;
    }

    private static SampleLocalProject createSampleProjectInfo(SampleProjectType type, String name, String resourceFileName) {
        SampleLocalProject sampleProject = new SampleLocalProject();
        sampleProject.setType(type);
        sampleProject.setName(name);
        sampleProject.setResourceName(resourceFileName);
        return sampleProject;
    }

    private String getResourcesLocation(String projectName) {
        return String.valueOf(RESOURCES_SAMPLE_PROJECTS_FOLDER) + File.separator + projectName;
    }

    private void extractProjectSource(String projectName, String unzipedLocation) throws IOException {
        this.processZipFileInputStream(this.getResourceAsInputStream(this.getClass(), String.valueOf(this.getResourcesLocation(projectName)) + ".zip"), unzipedLocation);
    }

    private void processZipFileInputStream(InputStream is, String location) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream stream = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                File file = new File(location, entry.getName());
                if (entry.isDirectory()) {
                    if (file.exists()) continue;
                    file.mkdirs();
                    continue;
                }
                this.writeZipEntryToFile(stream, file);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeZipEntryToFile(ZipInputStream zis, File outputFile) throws IOException {
        byte[] buffer = new byte[2048];
        try (FileOutputStream output = null;){
            output = new FileOutputStream(outputFile);
            int len = 0;
            while ((len = zis.read(buffer)) > 0) {
                output.write(buffer, 0, len);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getResourceAsInputStream(Class<?> clazz, String filePath) throws IOException {
        String projectPath = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(projectPath = URLDecoder.decode(projectPath, "utf-8"));
        if (jarFile.isDirectory()) {
            return new FileInputStream(new File(jarFile, filePath).getAbsolutePath());
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (JarFile jar = new JarFile(jarFile);){
            JarEntry jarEntry;
            Enumeration<JarEntry> entries = jar.entries();
            String relativePath = filePath.replace(File.separator, "/");
            do {
                if (entries.hasMoreElements()) continue;
                return null;
            } while (!(jarEntry = entries.nextElement()).getName().equals(relativePath));
            File extractedFile = new File(ClassPathResolver.getConfigurationFolder(), relativePath);
            FileUtils.copyInputStreamToFile((InputStream)jar.getInputStream(jarEntry), (File)extractedFile);
            return new FileInputStream(extractedFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public void extractSampleWebUIProject(SampleLocalProject sampleProject, String location) throws IOException {
        this.extractProjectSource(sampleProject.getResourceName(), location);
    }
}

