/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.FindsByIosClassChain;
import io.appium.java_client.FindsByIosNSPredicate;
import io.appium.java_client.FindsByIosUIAutomation;
import io.appium.java_client.HasOnScreenKeyboard;
import io.appium.java_client.HidesKeyboardWithKeyName;
import io.appium.java_client.LocksDevice;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.battery.HasBattery;
import io.appium.java_client.ios.HasIOSClipboard;
import io.appium.java_client.ios.HasIOSSettings;
import io.appium.java_client.ios.IOSBatteryInfo;
import io.appium.java_client.ios.ListensToSyslogMessages;
import io.appium.java_client.ios.PerformsTouchID;
import io.appium.java_client.ios.PushesFiles;
import io.appium.java_client.ios.ShakesDevice;
import io.appium.java_client.screenrecording.CanRecordScreen;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.ws.StringWebSocketClient;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpClient;

public class IOSDriver<T extends WebElement>
extends AppiumDriver<T>
implements HidesKeyboardWithKeyName,
ShakesDevice,
HasIOSSettings,
HasOnScreenKeyboard,
FindsByIosUIAutomation<T>,
LocksDevice,
PerformsTouchID,
FindsByIosNSPredicate<T>,
FindsByIosClassChain<T>,
PushesFiles,
CanRecordScreen,
HasIOSClipboard,
ListensToSyslogMessages,
HasBattery<IOSBatteryInfo> {
    private static final String IOS_PLATFORM = "iOS";
    private StringWebSocketClient syslogClient;

    public IOSDriver(HttpCommandExecutor executor, Capabilities capabilities) {
        super(executor, IOSDriver.substituteMobilePlatform(capabilities, IOS_PLATFORM));
    }

    public IOSDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM));
    }

    public IOSDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(remoteAddress, httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM));
    }

    public IOSDriver(AppiumDriverLocalService service, Capabilities desiredCapabilities) {
        super(service, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM));
    }

    public IOSDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(service, httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM));
    }

    public IOSDriver(AppiumServiceBuilder builder, Capabilities desiredCapabilities) {
        super(builder, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM));
    }

    public IOSDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(builder, httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM));
    }

    public IOSDriver(HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM));
    }

    public IOSDriver(Capabilities desiredCapabilities) {
        super(IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM));
    }

    @Override
    public void runAppInBackground(Duration duration) {
        this.execute(MobileCommand.RUN_APP_IN_BACKGROUND, (Map)MobileCommand.prepareArguments("seconds", MobileCommand.prepareArguments("timeout", duration.toMillis())));
    }

    @Override
    public WebDriver.TargetLocator switchTo() {
        return new InnerTargetLocator();
    }

    @Override
    public IOSBatteryInfo getBatteryInfo() {
        return new IOSBatteryInfo((Map)this.execute("executeScript", (Map)ImmutableMap.of((Object)"script", (Object)"mobile: batteryInfo", (Object)"args", Collections.emptyList())).getValue());
    }

    public Capabilities getCapabilities() {
        MutableCapabilities capabilities = (MutableCapabilities)super.getCapabilities();
        capabilities.setCapability("platformName", IOS_PLATFORM);
        return capabilities;
    }

    @Override
    public synchronized StringWebSocketClient getSyslogClient() {
        if (this.syslogClient == null) {
            this.syslogClient = new StringWebSocketClient();
        }
        return this.syslogClient;
    }

    class IOSAlert
    implements Alert {
        private final Alert alert;

        IOSAlert(Alert alert) {
            this.alert = alert;
        }

        public void dismiss() {
            IOSDriver.this.execute("dismissAlert");
        }

        public void accept() {
            IOSDriver.this.execute("acceptAlert");
        }

        public String getText() {
            Response response = IOSDriver.this.execute("getAlertText");
            return response.getValue().toString();
        }

        public void sendKeys(String keysToSend) {
            IOSDriver.this.execute("setAlertValue", (Map)MobileCommand.prepareArguments("value", keysToSend));
        }
    }

    private class InnerTargetLocator
    extends RemoteWebDriver.RemoteTargetLocator {
        private InnerTargetLocator() {
            super((RemoteWebDriver)IOSDriver.this);
        }

        public Alert alert() {
            return new IOSAlert(super.alert());
        }
    }
}

